%TIMESTEPPING Class definition
%
%   Usage:
%      timestepping=timestepping();

classdef timestepping
	properties (SetAccess=public) 
		time_step       = modelfield('default',0,'marshall',true,'format','Double');
		final_time      = modelfield('default',0,'marshall',true,'format','Double');
		time_adapt      = modelfield('default',0,'marshall',true,'format','Boolean');
		cfl_coefficient = modelfield('default',0,'marshall',true,'format','Double');
	end
	methods
		function obj = timestepping(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

			%time between 2 time steps
			obj.time_step=1/2;

			%final time
			obj.final_time=10*obj.time_step;

			%time adaptation? 
			obj.time_adapt=0;
			obj.cfl_coefficient=.5;
		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

			checkfield(md,'timestepping.time_adapt','numel',1,'values',[0 1]);
			checkfield(md,'timestepping.cfl_coefficient','numel',1,'>',0,'<=',1);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   timestepping parameters:'));

			fielddisplay(obj,'time_step','length of time steps [yrs]');
			fielddisplay(obj,'final_time','final time to stop the simulation [yrs]');
			fielddisplay(obj,'time_adapt','use cfl condition to define time step ? (0 or 1) ');
			fielddisplay(obj,'cfl_coefficient','coefficient applied to cfl condition');

		end % }}}
	end
end
