%PRIVATE class definition
%
%   Usage:
%      private=private();

classdef private
	properties (SetAccess=public) 
		 runtimename = modelfield('default','','marshall',false);
		 bamg        = modelfield('default',0,'marshall',false);
		 solution    = modelfield('default','','marshall',false);
	end
	methods
		function obj = private(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				case 1
					in=varargin{1};
					if (isa(in,'numeric') & in==0),
						% requesting templates do nothing
					else
						error('constructor not supported');
					end 
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%first, use the defaults provided by the properties definition above. 
			fieldnames=fields(obj);
			for i=1:length(fieldnames),
				fieldname=fieldnames{i};
				obj.(fieldname)=obj.(fieldname).default;
			end

		end % }}}
		function checkconsistency(obj,md,solution,analyses) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   private parameters: do not change'));

			fielddisplay(obj,'runtimename','name of the run launched');
			fielddisplay(obj,'bamg','structure with mesh properties construced if bamg is used to mesh the domain');
			fielddisplay(obj,'solution','type of solution launched');

		end % }}}
	end
end
