function pairoptions=removefield(pairoptions,field,warn)
%REMOVEFIELD - delete a field in an option list
%
%   Usage:
%      pairoptions=removefield(pairoptions,field,warn)
%
%   if warn==1 display an info message to wan user that
%   some of his options have been removed.

%check is field exist
if exist(pairoptions,field),

	%find where the field is located
	lines=find(~strcmpi(pairoptions.list(:,1),field));

	%remove duplicates from the options list
	pairoptions.list=pairoptions.list(lines,:);

	%warn user if requested
	if warn
		disp(['removefield info: option ' field ' has been removed from the list of options.'])
	end
end
