/*!\file: solver_linear.cpp
 * \brief: numerical core of linear solutions
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"

void solver_linear(FemModel* femmodel){

	/*intermediary: */
	Mat  Kff = NULL, Kfs   = NULL;
	Vec  ug  = NULL;
	Vec  uf  = NULL;
	Vec  pf  = NULL;
	Vec  df  = NULL;
	Vec  ys  = NULL;
	int  configuration_type;

	/*Recover parameters: */
	femmodel->parameters->FindParam(&configuration_type,ConfigurationTypeEnum);
	UpdateConstraintsx(femmodel->nodes,femmodel->constraints,femmodel->parameters);

	SystemMatricesx(&Kff, &Kfs, &pf, &df, NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	CreateNodalConstraintsx(&ys,femmodel->nodes,configuration_type);
	Reduceloadx(pf, Kfs, ys); MatFree(&Kfs);
	Solverx(&uf, Kff, pf, NULL, df, femmodel->parameters); MatFree(&Kff); VecFree(&pf); VecFree(&df);
	Mergesolutionfromftogx(&ug, uf,ys,femmodel->nodes,femmodel->parameters);VecFree(&uf);VecFree(&ys);
	InputUpdateFromSolutionx( femmodel->elements,femmodel->nodes, femmodel->vertices, femmodel->loads, femmodel->materials, femmodel->parameters,ug); 
	VecFree(&ug); VecFree(&uf);
}
