/*
 * solutions.h: 
 */

#ifndef SOLUTIONS_H_
#define SOLUTIONS_H_

#include "../objects/objects.h"
#include "../io/io.h"

struct OptArgs;
class FemModel;

/*cores: */
void adjointdiagnostic_core(FemModel* femmodel);
void adjointbalancethickness_core(FemModel* femmodel);
void gradient_core(FemModel* femmodel,int step=0, double search_scalar=0);
void diagnostic_core(FemModel* femmodel);
void hydrology_core(FemModel* femmodel);
void hydrology_core_step(FemModel* femmodel,int step, double time);
void thermal_core(FemModel* femmodel);
void thermal_core_step(FemModel* femmodel,int step, double time);
void enthalpy_core(FemModel* femmodel);
void surfaceslope_core(FemModel* femmodel);
void bedslope_core(FemModel* femmodel);
void control_core(FemModel* femmodel);
void controltao_core(FemModel* femmodel);
void prognostic_core(FemModel* femmodel);
void balancethickness_core(FemModel* femmodel);
void slopecompute_core(FemModel* femmodel);
void steadystate_core(FemModel* femmodel);
void transient_core(FemModel* femmodel);
double objectivefunctionC(double search_scalar,OptArgs* optargs);

//convergence:
void convergence(int* pconverged, Mat K_ff,Vec p_f,Vec u_f,Vec u_f_old,Parameters* parameters);
bool controlconvergence(double J,double tol_cm);
bool steadystateconvergence(FemModel* femmodel);

//optimization
int GradJSearch(double* search_vector,FemModel* femmodel,int step);

//diverse
void ProcessArguments(int* solution,char** pbinname,char** poutbinname,char** ppetscname,char** plockname,int argc,char **argv);
void WriteLockFile(char* filename);
void controlrestart(FemModel* femmodel,double* J);
void ResetBoundaryConditions(FemModel* femmodel, int analysis_type);

//solution configuration
void AnalysisConfiguration(int** panalyses,int* pnumanalyses, int solutiontype);
void CorePointerFromSolutionEnum(void (**psolutioncore)(FemModel*),Parameters* parameters,int solutiontype);
void AdjointCorePointerFromSolutionEnum(void (**padjointcore)(FemModel*),int solutiontype);

#endif
