/*! \file PetscMatParam.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _PETSCMATPARAM_H_
#define _PETSCMATPARAM_H_

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#ifdef _SERIAL_
#include <mex.h>
#endif

#include "./Param.h"
#include "../../include/include.h"
#include "../../shared/shared.h"
/*}}}*/

class PetscMatParam: public Param{

	private: 
		/*just hold 3 values for 3 vertices: */
		int enum_type;
		Mat value;

	public:
		/*PetscMatParam constructors, destructors: {{{1*/
		PetscMatParam();
		PetscMatParam(int enum_type,Mat value);
		~PetscMatParam();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*Param vritual function definitions: {{{1*/
		int   InstanceEnum(){return enum_type;}
		void  GetParameterValue(bool* pbool){_error_("PetscMat param of enum %i (%s) cannot return a bool",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(int* pinteger){_error_("PetscMat param of enum %i (%s) cannot return an integer",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(int** pintarray,int* pM){_error_("PetscMat param of enum %i (%s) cannot return an array of integers",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(int** pintarray,int* pM,int* pN){_error_("PetscMat param of enum %i (%s) cannot return an array of integers",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(double* pdouble){_error_("PetscMat param of enum %i (%s) cannot return a double",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(char** pstring){_error_("PetscMat param of enum %i (%s) cannot return a string",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(char*** pstringarray,int* pM){_error_("PetscMat param of enum %i (%s) cannot return a string arrayl",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM){_error_("PetscMat param of enum %i (%s) cannot return a double array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(double** pdoublearray,int* pM, int* pN){_error_("PetscMat param of enum %i (%s) cannot return a double array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(double*** parray, int* pM,int** pmdims, int** pndims){_error_("PetscMat param of enum %i (%s) cannot return a matrix array",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(Vec* pvec){_error_("PetscMat param of enum %i (%s) cannot return a vec",enum_type,EnumToStringx(enum_type));}
		void  GetParameterValue(Mat* poutput);
		void  GetParameterValue(FILE** pfid){_error_("PetscMat param of enum %i (%s) cannot return a FILE",enum_type,EnumToStringx(enum_type));}

		void  SetValue(bool boolean){_error_("PetscMat param of enum %i (%s) cannot hold a boolean",enum_type,EnumToStringx(enum_type));}
		void  SetValue(int integer){_error_("PetscMat param of enum %i (%s) cannot hold an integer",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double scalar){_error_("PetscMat param of enum %i (%s) cannot hold a scalar",enum_type,EnumToStringx(enum_type));}
		void  SetValue(char* string){_error_("PetscMat param of enum %i (%s) cannot hold a string",enum_type,EnumToStringx(enum_type));}
		void  SetValue(char** stringarray,int M){_error_("PetscMat param of enum %i (%s) cannot hold a string array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double* doublearray,int M){_error_("PetscMat param of enum %i (%s) cannot hold a double array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double* pdoublearray,int M,int N){_error_("PetscMat param of enum %i (%s) cannot hold a double array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(int* intarray,int M){_error_("PetscMat param of enum %i (%s) cannot hold a int array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(int* pintarray,int M,int N){_error_("PetscMat param of enum %i (%s) cannot hold a int array",enum_type,EnumToStringx(enum_type));}
		void  SetValue(Vec vec){_error_("PetscMat param of enum %i (%s) cannot hold a Vec",enum_type,EnumToStringx(enum_type));}
		void  SetValue(Mat mat);
		void  SetValue(FILE* fid){_error_("PetscMat param of enum %i (%s) cannot hold a FILE",enum_type,EnumToStringx(enum_type));}
		void  SetValue(double** array, int M, int* mdim_array, int* ndim_array){_error_("PetscMat param of enum %i (%s) cannot hold an array of matrices",enum_type,EnumToStringx(enum_type));}
		void  UnitConversion(int direction_enum);

		char* GetParameterName(void);
		#ifdef _SERIAL_
		void  SetMatlabField(mxArray* dataref);
		#endif

		/*}}}*/
};
#endif  /* _PETSCMATPARAM_H */
