/*!\file Friction.h
 * \brief: header file for friction object
 */

#ifndef _FRICTION_H_
#define _FRICTION_H_

/*Headers:*/
/*{{{1*/
class Inputs;
class Matpar;
/*}}}*/

class Friction{

	public:
		int analysis_type;

		char* element_type;
		Inputs* inputs;
		Matpar* matpar;

		/*methods: */
		Friction();
		Friction(char* element_type, Inputs* inputs,Matpar* matpar, int analysis_type);
		~Friction();
	
		void  Echo(void);
		void  GetAlpha2(double* palpha2, GaussTria* gauss,int vxenum,int vyenum,int vzenum);
		void  GetAlpha2(double* palpha2, GaussPenta* gauss,int vxenum,int vyenum,int vzenum);
		void  GetAlphaComplement(double* alpha_complement, GaussTria* gauss,int vxenum,int vyenum,int vzenum);
		void  GetAlphaComplement(double* alpha_complement, GaussPenta* gauss,int vxenum,int vyenum,int vzenum);
		void  GetInputValue(double* pvalue,GaussTria* gauss,int enum_type);
		void  GetInputValue(double* pvalue,GaussPenta* gauss,int enum_type);

};

#endif  /* _FRICTION_H_ */
