/*!\file KML_Overlay.cpp
 * \brief: implementation of the kml_overlay abstract object
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*Constructors/destructor/copy*/
/*FUNCTION KML_Overlay::KML_Overlay(){{{1*/
KML_Overlay::KML_Overlay(){

	strcpy(color     ,"ffffffff");
	memcpy(color,"ffffffff",(strlen("ffffffff")+1)*sizeof(char));

	draword   = 0;
	icon      =NULL;

}
/*}}}*/
/*FUNCTION KML_Overlay::~KML_Overlay(){{{1*/
KML_Overlay::~KML_Overlay(){

	if (icon) {
		delete icon;
		icon      =NULL;
	}

}
/*}}}*/

/*Other*/
/*FUNCTION KML_Overlay::Echo {{{1*/
void  KML_Overlay::Echo(){

	bool  flag=true;

	KML_Feature::Echo();

	_printf_(flag,"         color: \"%s\"\n" ,color);
	_printf_(flag,"       draword: %d\n"     ,draword);
	_printf_(flag,"          icon: %p\n"     ,icon);

	return;
}
/*}}}*/

/*FUNCTION KML_Overlay::DeepEcho {{{1*/
void  KML_Overlay::DeepEcho(){

	char  indent[81]="";

	KML_Overlay::DeepEcho(indent);

	return;
}
/*}}}*/

/*FUNCTION KML_Overlay::DeepEcho {{{1*/
void  KML_Overlay::DeepEcho(char* indent){

	char  indent2[81];
	bool  flag=true;

	KML_Feature::DeepEcho(indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	_printf_(flag,"%s         color: %s\n"          ,indent,color);
	_printf_(flag,"%s       draword: %d\n"          ,indent,draword);
	if (icon)
		icon->DeepEcho(indent2);
	else
		_printf_(flag,"%s          icon: %p\n"          ,indent,icon);

	return;
}
/*}}}*/

/*FUNCTION KML_Overlay::Write {{{1*/
void  KML_Overlay::Write(FILE* filout,char* indent){

	char  indent2[81];

	KML_Feature::Write(filout,indent);

	memcpy(indent2,indent,(strlen(indent)+1)*sizeof(char));

	strcat(indent2,"  ");

	if (color     && strlen(color))
		fprintf(filout,"%s  <color>%s</color>\n",indent,color);
	fprintf(filout,"%s  <drawOrder>%d</drawOrder>\n",indent,draword);
	if (icon)
		icon->Write(filout,indent2);

	return;
}
/*}}}*/

/*FUNCTION KML_Overlay::Read {{{1*/
void  KML_Overlay::Read(FILE* fid,char* kstr){

/*  process field within opening and closing tags  */

	if      (!strncmp(kstr,"</Overlay", 9)) {
		xfree((void**)&kstr);
		return;
	}
	else if (!strncmp(kstr,"</",2))
		_error_("KML_Overlay::Read -- Unexpected closing tag %s.\n",kstr);
	else if (strncmp(kstr,"<",1))
		_error_("KML_Overlay::Read -- Unexpected field \"%s\".\n",kstr);

	else if (!strcmp(kstr,"<color>"))
		KMLFileTokenParse( color     ,NULL,KML_OVERLAY_COLOR_LENGTH,
						  kstr,
						  fid);
	else if (!strcmp(kstr,"<drawOrder>"))
		KMLFileTokenParse(&draword   ,
						  kstr,
						  fid);

	else if (!strncmp(kstr,"<Icon", 5)) {
		icon      =new KML_Icon();
		icon      ->Read(fid,kstr);
	}

	else if (!strncmp(kstr,"<",1))
		KML_Feature::Read(fid,kstr);

	return;
}
/*}}}*/

