/*! \file PentaVertexInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _PENTAVERTEXINPUT_H_
#define _PENTAVERTEXINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../Elements/PentaRef.h"
class GaussTria;
/*}}}*/

class PentaVertexInput: public Input, public PentaRef{

	public:
		/*just hold 6 values for 6 vertices: */
		int    enum_type;
		double values[6];

		/*PentaVertexInput constructors, destructors: {{{1*/
		PentaVertexInput();
		PentaVertexInput(int enum_type,double* values);
		~PentaVertexInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		#ifdef _SERIAL_
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		#endif
		int   ObjectEnum();
		Object* copy();
		/*}}}*/
		/*PentaVertexInput management: {{{1*/
		int   InstanceEnum();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB);
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		ElementResult* SpawnResult(int step, double time);
		void AddTimeValues(double* values,int step,double time){_error_("not supported yet");};
		void Configure(Parameters* parameters);
		/*}}}*/
		/*numerics: {{{1*/
		void GetInputValue(bool* pvalue){_error_("not implemented yet");};
		void GetInputValue(int* pvalue){_error_("not implemented yet");};
		void GetInputValue(double* pvalue){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussTria* gauss){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussPenta* gauss);
		void GetInputValue(double* pvalue,GaussTria* gauss ,int index){_error_("not implemented yet");};
		void GetInputValue(double* pvalue,GaussPenta* gauss ,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetInputDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss);
		void GetInputAverage(double* pvalue);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss);
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss);
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss);
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss);
		void ChangeEnum(int newenumtype);

		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(double minimum);
		void Scale(double scale_factor);
		void ArtificialNoise(double min,double max){_error_("not implemented yet");};
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		double InfinityNorm(void);
		double Max(void);
		double MaxAbs(void);
		double Min(void);
		double MinAbs(void);
		void Extrude(void);
		void VerticallyIntegrate(Input* thickness_input);
		void GetVectorFromInputs(Vec vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _PENTAVERTEXINPUT_H */
