/*!\file RequestedOutputsx
 * \brief: compute outputs that were requested specifically for this solution, such as BasalStress, StrainHeating, etc ...
 */

#include "../../modules/modules.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void RequestedOutputsx(Results* results,Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters, int* requested_outputs, int numoutputs, int step, double time){

	int  i,j;
	int  output_enum;
	double output_value;
	Element* element=NULL;

	/*retrieve parameters: */
	if(numoutputs){
		for(i=0;i<numoutputs;i++){
			output_enum=requested_outputs[i];

			switch(output_enum){

				case IceVolumeEnum:
					Responsex(&output_value,elements,nodes,vertices,loads,materials,parameters,"IceVolume",false,0);
					results->AddObject(new DoubleExternalResult(results->Size()+1,IceVolumeEnum,output_value,step,time));
					break;
				default:
					/*create this output in the element inputs, and then transfer to results:*/
					for(j=0;j<elements->Size();j++){
						element=(Element*)elements->GetObjectByOffset(j);
						element->RequestedOutput(output_enum,step,time);
					}
					break;
			}
		}
	}
}
