/*! \file  ContourToMeshx.c
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif


#include "./ContourToMeshx.h"

int ContourToMeshx( Vec* pin_nod,Vec* pin_elem, double* index, double* x, double* y,Contour** contours,int numcontours,char* interptype,int nel,int nods, int edgevalue) {

	int noerr=1;
	int i;
	int m,n;

	/*Contour:*/
	double*  in_nod_serial;
	double   value;

	/*threading: */
	ContourToMeshxThreadStruct gate;
	int num=1;
	#ifdef _MULTITHREADING_
	num=_NUMTHREADS_;
	#endif


	/*output: */
	Vec in_nod=NULL;
	Vec in_elem=NULL;

	in_nod=NewVec(nods);
	in_elem=NewVec(nel);

	/*initialize thread parameters: */
	gate.numcontours=numcontours;
	gate.contours=contours;
	gate.nods=nods;
	gate.edgevalue=edgevalue;
	gate.in_nod=in_nod;
	gate.x=x;
	gate.y=y;

	/*launch the thread manager with ContourToMeshxt as a core: */
	LaunchThread(ContourToMeshxt,(void*)&gate,num);

	/*Assemble in_nod: */
	VecAssemblyBegin(in_nod);
	VecAssemblyEnd(in_nod);

	/*Get in_nod serialised for next operation: */
	VecToMPISerial(&in_nod_serial,in_nod);

	/*Take care of the case where an element interpolation has been requested: */
	if ((strcmp(interptype,"element")==0) || (strcmp(interptype,"element and node")==0)){
		for (n=0;n<nel;n++){
			if ( (in_nod_serial[ (int)*(index+3*n+0) -1] == 1) && (in_nod_serial[ (int)*(index+3*n+1) -1] == 1) && (in_nod_serial[ (int)*(index+3*n+2) -1] == 1) ){
				value=1; VecSetValues(in_elem,1,&n,&value,INSERT_VALUES);
			}
		}
	}

	/*Assemble vectors: */
	VecAssemblyBegin(in_elem);
	VecAssemblyEnd(in_elem);

	/*Assign output pointers: */
	*pin_nod=in_nod;
	*pin_elem=in_elem;

	/*Free ressources:*/
	xfree((void**)&in_nod_serial);

	return noerr;
}
