#!/bin/bash

#get number of CPUS
NUMCPUS=$1;

#version of xerces-c-tools
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/xerces-c-//g'`
echo $version

#Some cleanup
rm -rf install xerces-c-$version src

#Create install directories
mkdir install src

#Untar 
tar -zxvf  xerces-c-$version.tar.gz

#Move xerces-c-tools into install directory
mv xerces-c-$version/* src
rm -rf xerces-c-$version

#Apply patches
cd src/src/xercesc/

#Configure
./runConfigure -plinux -cgcc -xg++ -minmem -nsocket -tnative -rnone -s 

#Compile xerces-c-tools
if [ -z $NUMCPUS ];
then
	make
else
	make -j $NUMCPUS
fi
