#!/bin/bash

#get number of CPUS
NUMCPUS=$1;

#version of cmake
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/cmake-//g'`

#Some cleanup
rm -rf install cmake-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  cmake-$version.tar.gz

#Move cmake into install directory
mv cmake-$version/* install
rm -rf cmake-$version


#Compile cmake
cd install 
./bootstrap --prefix=$ISSM_TIER/externalpackages/cmake/install
if [ -z $NUMCPUS ];
then
	make 
else
	make -j $NUMCPUS 
fi
make install
