#!/bin/bash

#get number of CPUS
NUMCPUS=$1;

#version of boost
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/boost_//g'`
echo $version

#Some cleanup
rm -rf install boost_$version src

#Create install directories
mkdir install src

#Untar 
tar -zxvf  boost_$version.tar.gz

#Move boost into install directory
mv boost_$version/* src
rm -rf boost_$version

#Apply patches
cd src 

#Configure
./bootstrap.sh --prefix=$ISSM_TIER/externalpackages/boost/install

#Compile boost
if [ -z $NUMCPUS ];
then
	./bjam install
else
	./bjam -j$NUMCPUS install
fi
