/* \file

  \brief Pairs CallContext with a DataFlowSet for ICFGCSDFSolver

  \authors Michelle Strout, Barbara Kreaseck
  
  \version $Id: CCDFSPair.hpp, mstrout Exp $

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef CCDFSPair_hpp
#define CCDFSPair_hpp

#include <cassert>
#include <iostream>
#include <OpenAnalysis/Utils/OA_ptr.hpp>
#include <OpenAnalysis/DataFlow/DataFlowSet.hpp>
#include <OpenAnalysis/Alias/CallContext.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>

namespace OA {
  namespace DataFlow {

//! =================================================================================
//! Context-Sensitive-Data-Flow(CSDF) is represented by CCDFSPair i.e. 
//! 2-tuple: CCDFSPair(CallContext ptr, DataFlowSet ptr)
//!  
//!
//! ===============================================================================

class CCDFSPair  : public virtual Annotation{

public:

  //! === constructors ===

  // these three just copy, they do not clone ==> send clones in if needed
  CCDFSPair(OA_ptr<Alias::CallContext> cc, OA_ptr<DataFlowSet> dfs);
  CCDFSPair(const CCDFSPair& other);
  CCDFSPair& operator= (const CCDFSPair& other);


  OA_ptr<CCDFSPair> clone();


  ~CCDFSPair();


  //! ===== Access Methods =====
  OA_ptr<Alias::CallContext> getContextPtr() const;
  OA_ptr<DataFlowSet> getDFSetPtr() const;


  //! ===== Full Comparison =====
  bool operator< (const CCDFSPair &other) const;
  bool operator== (const CCDFSPair &other) const;
  bool operator!= (const CCDFSPair &other) const;


  //! =================== Output and debugging ========================

  //! ===== Annotation Output =====
  void output(IRHandlesIRInterface& pIR) const;
  void dump(std::ostream &os, OA_ptr<IRHandlesIRInterface> pIR);


  //! ===== CCDFSPair Output =====
  void output(IRHandlesIRInterface& pIR, Alias::Interface &alias) const;

private:

  //! ===== Members =====
  OA_ptr<Alias::CallContext> mCCPtr;
  OA_ptr<DataFlowSet> mDFSetPtr;

};


  } // end of DataFlow namespace
} // end of OA namespace



#endif // CCDFSPair_hpp
