/* LivenessBV.hpp
   NOTE: This file was automatically generated by DFAGen.  It is the interface
         for the LivenessBV analysis results.
*/

#ifndef LivenessBV_hpp
#define LivenessBV_hpp

#include <cassert>
#include <iostream>
#include <map>
#include <set>
#include <vector>
#include <OpenAnalysis/Utils/OA_ptr.hpp>
#include <OpenAnalysis/IRInterface/IRHandles.hpp>
#include <OpenAnalysis/IRInterface/auto_LivenessBVIRInterface.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/GenOutputTool.hpp>
#include <OpenAnalysis/Alias/AliasTag.hpp>
#include <OpenAnalysis/ExprTree/ExprTree.hpp>
#include <OpenAnalysis/DataFlow/DataFlowSetImpl.hpp>
#include <OpenAnalysis/DataFlow/DFSetBitImpl.hpp>
#include <OpenAnalysis/DataFlow/IRHandleDataFlowSet.hpp>
#include <OpenAnalysis/Utils/Util.hpp>

namespace OA {
  namespace LivenessBV {

typedef DataFlow::DFSetBitImpl<Alias::AliasTag >  LivenessBVDFSet;

class LivenessBV : public virtual Annotation {
  public:
    //*****************************************************************
    // Construction methods
    //*****************************************************************
    LivenessBV(ProcHandle p, OA_ptr<LivenessBVIRInterface> _ir) {
        mIR = _ir;
        mExitLivenessBV = new LivenessBVDFSet();
    }
    ~LivenessBV() {}


    //*****************************************************************
    // Query methods
    //*****************************************************************
    OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag > > getLivenessBVIterator(StmtHandle s) const;

    OA_ptr<DataFlow::DFSetBitImplIterator<Alias::AliasTag > > getExitLivenessBVIterator() const;

    OA_ptr<LivenessBVDFSet> getLivenessBVSet(StmtHandle s) {
        map<StmtHandle, OA_ptr<LivenessBVDFSet> >::iterator element =
            mLivenessBV.find(s);

        if(element == mLivenessBV.end()) {
            mLivenessBV[s] = new LivenessBVDFSet();
            element = mLivenessBV.find(s);
        }

        return (*element).second;
    }


    //*****************************************************************
    // Modifier methods
    //*****************************************************************
    void insert(StmtHandle s, Alias::AliasTag  val) {
        if(mLivenessBV[s].ptrEqual(0)) {
            mLivenessBV[s] = new LivenessBVDFSet();
        }
        mLivenessBV[s]->insert(val);
    }

    void insertExit(Alias::AliasTag  val) {
        mExitLivenessBV->insert(val);
    }


    //*****************************************************************
    // Output
    //*****************************************************************
    void output(IRHandlesIRInterface& pIR) const;

    void dump(std::ostream& os,
        OA_ptr<IRHandlesIRInterface> ir,
        Alias::Interface& aliasResults) const;



  private:
    map<StmtHandle, OA_ptr<LivenessBVDFSet> > mLivenessBV;
    OA_ptr<LivenessBVDFSet>  mExitLivenessBV;
    OA_ptr<LivenessBVIRInterface> mIR;
};

  } // end of Liveness namespace
} // end of OA namespace

#endif

