/*! \file
  
  \brief Declarations of the AnnotationManager that determines
         CallContextSets and generates a CCSetPerProc object.

  \authors Barbara Kreaseck

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef ManagerCallContexts_h
#define ManagerCallContexts_h

//--------------------------------------------------------------------
// OpenAnalysis headers

#include "CCSetPerProc.hpp"
#include <OpenAnalysis/CallGraph/CallGraphInterface.hpp>
#include <OpenAnalysis/IRInterface/IRHandles.hpp>

namespace OA {
  namespace Alias {


/*! 
   Generates CCSetsPerProc
*/
class ManagerCallContexts {
public:
    
  ManagerCallContexts(OA_ptr<IRHandlesIRInterface> _ir);
  ~ManagerCallContexts () {}

  //! Construct CCSetPerProc for given program.
  OA_ptr<CCSetPerProc> 
      performAnalysis( OA_ptr<CallGraph::CallGraphInterface> callGraph );

private: 
  
  //! member variables
  OA_ptr<IRHandlesIRInterface> mIR;
  std::map<OA_ptr<CallGraph::NodeInterface>, OA_ptr<CallContextSet> > mNodeToSetMap;
};

  } // end of Alias namespace
} // end of OA namespace

#endif
