/*! \file
  
  \brief Represents a wrapper for MemRefExpr + CallContext

  \authors Barbara Kreaseck
  \version $Id$

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef MREwContext_H
#define MREwContext_H

#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/OutputBuilder.hpp>
#include <OpenAnalysis/MemRefExpr/MemRefExpr.hpp>
#include "CallContext.hpp"

namespace OA {
  namespace Alias {

class MREwContext : public Annotation {
public:
  MREwContext(OA_ptr<MemRefExpr> mre, OA_ptr<CallContext> cc);
  MREwContext(OA_ptr<MREwContext> other);
  ~MREwContext();

  OA_ptr<MemRefExpr> getMRE();
  OA_ptr<CallContext> getCallContext();

  bool operator ==(const MREwContext& other) const;

  bool operator <(const MREwContext& other) const;
  
  OA_ptr<MREwContext> clone();

  MREwContext& operator=( MREwContext& other);

  // ************************************************************
  //  Output
  // ************************************************************
  virtual void output(OA::IRHandlesIRInterface& ir) const;

  virtual void output(OA::IRHandlesIRInterface& ir,
		      const Alias::Interface& aliasResults) const;

  void dump(std::ostream& os,
	    IRHandlesIRInterface& ir,
	    Interface& aliasResults);

private:
  OA_ptr<MemRefExpr> mMRE;
  OA_ptr<CallContext> mCallContext;

}; // end of MREwContext


  }
}

#endif
