/*! \file
  
  \brief Represents a wrapper for CallHandle + CallContext

  \authors Barbara Kreaseck
  \version $Id$

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef CallHwContext_H
#define CallHwContext_H

#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/OutputBuilder.hpp>
#include <OpenAnalysis/Alias/CallContext.hpp>
#include <OpenAnalysis/Alias/Interface.hpp>

namespace OA {
  namespace Alias {

class CallHwContext : public Annotation {
public:
  CallHwContext(CallHandle call, OA_ptr<CallContext> cc);
  CallHwContext(OA_ptr<CallHwContext> other);
  ~CallHwContext();

  CallHandle getCall();
  OA_ptr<CallContext> getCallContext();

  bool operator ==(const CallHwContext& other) const;

  bool operator <(const CallHwContext& other) const;
  
  OA_ptr<CallHwContext> clone();

  CallHwContext& operator=( CallHwContext& other);

  // ************************************************************
  //  Output
  // ************************************************************
  virtual void output(OA::IRHandlesIRInterface& ir) const;

  virtual void output(OA::IRHandlesIRInterface& ir,
		      const Alias::Interface& aliasResults) const;

  void dump(std::ostream& os,
	    IRHandlesIRInterface& ir);

private:
  CallHandle mCallH;
  OA_ptr<CallContext> mCallContext;

}; // end of CallHwContext


  } // end of Alias namespace
} // end of OA namespace

#endif
