/*! \file
  
  \brief Class that maps context-augmented MREs and MemRefHandles to sets of 
         AliasTags.  Essentially, it stores the results of the CSFI alias
         analysis.

  \authors Michelle Strout, Barbara Kreaseck

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef CSFIAliasTagResults_H
#define CSFIAliasTagResults_H

#include <OpenAnalysis/Alias/Interface.hpp>
#include <OpenAnalysis/Alias/InterAliasInterface.hpp>
#include <map>
#include <set>

#include <OpenAnalysis/Utils/OA_ptr.hpp>
#include <OpenAnalysis/IRInterface/IRHandles.hpp>
#include <OpenAnalysis/MemRefExpr/MemRefExpr.hpp>
#include <OpenAnalysis/Alias/AliasTagSet.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <OpenAnalysis/Utils/GenOutputTool.hpp>
#include <OpenAnalysis/Alias/CallContextSet.hpp>
#include <OpenAnalysis/Alias/MREwContext.hpp>
#include <OpenAnalysis/Alias/MRHwContext.hpp>

namespace OA {
  namespace Alias {


class CSFIAliasTagResults : public virtual Interface,
			    public virtual Annotation
{
  public:
    CSFIAliasTagResults();
    ~CSFIAliasTagResults() {};

    //***********************************************************
    // 
    //***********************************************************

    AliasResultType alias(MemRefHandle ref1, MemRefHandle ref2);
       
    OA_ptr<AliasTagSet> getAliasTags( OA_ptr<MemRefExpr> mre );

    OA_ptr<AliasTagSet> getAliasTags( MemRefHandle memref );

    OA_ptr<MemRefExprIterator>
        getMemRefExprIterator(AliasTag tag) const;

    AliasTag getMaxAliasTag();

    OA_ptr<AliasTagSet> getAliasTags( OA_ptr<MemRefExpr> mre, 
                                      OA_ptr<CallContext> context);

    OA_ptr<AliasTagSet> getAliasTags( MemRefHandle memref,
                                      OA_ptr<CallContext> context);

    OA_ptr<CallContextSetIterator> getCallContextSet(OA_ptr<MemRefExpr> mre);

    //***********************************************************
    // Construction methods 
    //***********************************************************
   
    //! Associate an MRE with given alias tag set
    void mapMemRefToAliasTagSet( OA_ptr<MemRefExpr> mre,
                                 OA_ptr<AliasTagSet> alias_tag_set);

    //! Associate a MemRefHandle with given alias tag
    void mapMemRefToAliasTagSet( MemRefHandle ref,
                                 OA_ptr<AliasTagSet> alias_tag_set);

    //! Associate an MRE + Context with given alias tag set
    void mapMemRefToAliasTagSet( OA_ptr<MemRefExpr> mre,
				 OA_ptr<CallContext> context,
				 OA_ptr<AliasTagSet> alias_tag_set);

    //! Associate a MemRefHandle with given alias tag
    void mapMemRefToAliasTagSet( MemRefHandle ref,
				 OA_ptr<CallContext> context,
				 OA_ptr<AliasTagSet> alias_tag_set);

    // FIXME: 4/22/08, MMS, would liked to deprecate these
    //! Associate an MRE with given alias tag
//    void mapMemRefToAliasTag( OA_ptr<MemRefExpr> mre,
//                              AliasTag alias_tag,
//                              bool isMust );

    //! Associate a MemRefHandle with given alias tag
//    void mapMemRefToAliasTag( MemRefHandle ref,
//                              AliasTag alias_tag,
//                              bool isMust );
 
    //***********************************************************
    // Output Functionalities
    //***********************************************************
    void output(OA::IRHandlesIRInterface& ir) const;
    
    //***********************************************************
    // Member variables
    //***********************************************************
  private:

    OUTPUT

    // data members
    //GENOUT std::map<OA_ptr<MemRefExpr>, OA_ptr<std::set<AliasTag> > >
    //    mMREToTags;
    GENOUT std::map<MREwContext, OA_ptr<AliasTagSet> >
        mMREwCToTags;
    GENOUT std::map<AliasTag, OA_ptr<std::set<MREwContext> > >
        mTagToMREwCs; 

    //GENOUT std::map<MemRefHandle, OA_ptr<std::set<AliasTag> > > mMemRefToTags;
    GENOUT std::map<MRHwContext, OA_ptr<AliasTagSet> > mMemRefwCToTags;
    GENOUT std::map<AliasTag, OA_ptr<std::set<MRHwContext> > > mTagToMemRefwCs;

    GENOUT std::map<MREwContext,bool> mMREwCToMustFlag;
    GENOUT std::map<MRHwContext,bool > mMemRefwCToMustFlag;

    GENOUT std::map<OA_ptr<MemRefExpr>, 
                    OA_ptr<CallContextSet> > mMREToCCSet;

}; // end of CSFIAliasTagResults class



  } // end of Alias namespace
} // end of OA namespace

#endif

