/*! \file
  
  \brief Declarations for the UsefulStandard/CSUseful implementation 
         of interprocedural Useful results.

  \authors Michelle Strout, Barbara Kreaseck
  \version $Id: InterUseful.hpp,v 1.2 2005/06/10 02:32:02 mstrout Exp $

  Copyright (c) 2002-2005, Rice University <br>
  Copyright (c) 2004-2005, University of Chicago <br>
  Copyright (c) 2006, Contributors <br>
  All rights reserved. <br>
  See ../../../Copyright.txt for details. <br>
*/

#ifndef InterUseful_H
#define InterUseful_H

#include <OpenAnalysis/Activity/UsefulStandard.hpp>
#include <OpenAnalysis/Activity/CSUseful.hpp>
#include <OpenAnalysis/OABase/Annotation.hpp>
#include <map>

namespace OA {
  namespace Activity {

class InterUseful : public virtual Annotation {
  public:
  InterUseful();
  virtual ~InterUseful() {}

  //! Query whether CSUseful results are present
  bool hasCSUseful();

  //! Returns useful results for the given procedure
  OA_ptr<Activity::UsefulStandard> getUsefulResults(ProcHandle proc);

  //! Returns CSUseful results for the given procedure
  OA_ptr<Activity::CSUseful> getCSUsefulResults(ProcHandle proc);

  //! Returns number of iterations over all node
  int getNumIter();

  //*****************************************************************
  // Output
  //*****************************************************************
  //! debugging output
  void dump(std::ostream& os, OA_ptr<IRHandlesIRInterface> ir);
    

  //*****************************************************************
  // Annotation Interface
  //*****************************************************************
  void output(IRHandlesIRInterface &ir) const;


  //*****************************************************************
  // Construction methods 
  //*****************************************************************

  //! attach UsefulStandard to procedure
  void mapProcToUseful(ProcHandle proc, OA_ptr<UsefulStandard> useful);

  //! attach CSUseful to procedure
  void mapProcToCSUseful(ProcHandle proc, OA_ptr<CSUseful> useful);

  //! set number of iterations over all nodes
  void setNumIter(int n);

  private:

  std::map<ProcHandle,OA_ptr<UsefulStandard> > mProcToUsefulMap;
  std::map<ProcHandle,OA_ptr<CSUseful> > mProcToCSUsefulMap;
  int mNumIter;
  bool mHasCSResults;


};

  } // end of Activity namespace
} // end of OA namespace

#endif

