#if 0
Hi Dan,
Attached is the C++ input file which produces the bug and the file generated by rose (the error comes from gcc because it can not compile that file).
The problem seems to be that rose can not deduce the second template parameter and therefor fails to unparse the AST.
The commented lines show how the code could be written differently to avoid that bug.

Greetings Thomas.

The problem is unparsed as:
template < typename U, typename T >
U f2 ( T t )
{
    return static_cast < U > ( t );
}

int main()
{
// problem is the extra comma
  f2 < int ,  > (3.5);

// quick solution
//f2<int, double>( 3.5 );

  return 0;
}

#endif


template< typename U, typename T >
U f2( T t )
{
    return static_cast<U>( t );
}


int main()
{
    // problem
    f2<int>( 3.5 );
    // quick solution
    //f2<int, double>( 3.5 );

    return 0;
}
