//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "sage3basic.h"
#include "AssemblerX86.h"

/* Generated by ./IntelAssemblyBuilder from 
 * x86-InstructionSetReference-AM.pdf 
 * x86-InstructionSetReference-NZ.pdf 
 * ExtraInstructions.txt */
void AssemblerX86::initAssemblyRules_part7() {
    AssemblerX86::InsnDefn *defn = NULL;
    defn = new InsnDefn("rol",    x86_rol,     0x03, 0xc1, od_e0|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  C1 /0 ib         ROL r/m64,        Valid        N.E.         Rotate 64 bits r/m64 left imm8
    //                   imm8                                        times. Uses a 6 bit count.
    defn = new InsnDefn("rol",    x86_rol,     0x02, 0xc1, od_rexw|od_e0|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  D0 /1            ROR r/m8, 1       Valid        Valid        Rotate 8 bits r/m8 right once.
    defn = new InsnDefn("ror",    x86_ror,     0x03, 0xd0, od_e1, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  REX + D0 /1      ROR r/m8*, 1      Valid        N.E.         Rotate 8 bits r/m8 right once.
    defn = new InsnDefn("ror",    x86_ror,     0x02, 0xd0, od_rex|od_e1, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  D2 /1            ROR r/m8, CL      Valid        Valid        Rotate 8 bits r/m8 right CL times.
    defn = new InsnDefn("ror",    x86_ror,     0x03, 0xd2, od_e1, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  REX + D2 /1      ROR r/m8*, CL     Valid        N.E.         Rotate 8 bits r/m8 right CL times.
    defn = new InsnDefn("ror",    x86_ror,     0x02, 0xd2, od_rex|od_e1, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  C0 /1 ib         ROR r/m8,         Valid        Valid        Rotate 8 bits r/m16 right imm8
    //                   imm8                                        times.
    defn = new InsnDefn("ror",    x86_ror,     0x03, 0xc0, od_e1|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  REX + C0 /1 ib   ROR r/m8*,        Valid        N.E.         Rotate 8 bits r/m16 right imm8
    //                   imm8                                        times.
    defn = new InsnDefn("ror",    x86_ror,     0x02, 0xc0, od_rex|od_e1|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  D1 /1            ROR r/m16, 1      Valid        Valid        Rotate 16 bits r/m16 right once.
    defn = new InsnDefn("ror",    x86_ror,     0x03, 0xd1, od_e1, od_r_m16, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  D3 /1            ROR r/m16, CL     Valid        Valid        Rotate 16 bits r/m16 right CL times.
    defn = new InsnDefn("ror",    x86_ror,     0x03, 0xd3, od_e1, od_r_m16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  C1 /1 ib         ROR r/m16,        Valid        Valid        Rotate 16 bits r/m16 right imm8
    //                   imm8                                        times.
    defn = new InsnDefn("ror",    x86_ror,     0x03, 0xc1, od_e1|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  D1 /1            ROR r/m32, 1      Valid        Valid        Rotate 32 bits r/m32 right once.
    defn = new InsnDefn("ror",    x86_ror,     0x03, 0xd1, od_e1, od_r_m32, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  REX.W + D1 /1    ROR r/m64, 1      Valid        N.E.         Rotate 64 bits r/m64 right once. Uses
    //                                                               a 6 bit count.
    defn = new InsnDefn("ror",    x86_ror,     0x02, 0xd1, od_rexw|od_e1, od_r_m64, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  D3 /1            ROR r/m32, CL     Valid        Valid        Rotate 32 bits r/m32 right CL times.
    defn = new InsnDefn("ror",    x86_ror,     0x03, 0xd3, od_e1, od_r_m32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  REX.W + D3 /1    ROR r/m64, CL     Valid        N.E.         Rotate 64 bits r/m64 right CL times.
    //                                                               Uses a 6 bit count.
    defn = new InsnDefn("ror",    x86_ror,     0x02, 0xd3, od_rexw|od_e1, od_r_m64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  C1 /1 ib         ROR r/m32,        Valid        Valid        Rotate 32 bits r/m32 right imm8
    //                   imm8                                        times.
    defn = new InsnDefn("ror",    x86_ror,     0x03, 0xc1, od_e1|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-311");
    define(defn);
    //  REX.W + C1 /1    ROR r/m64,        Valid        N.E.         Rotate 64 bits r/m64 right imm8
    //  ib               imm8                                        times. Uses a 6 bit count.
    defn = new InsnDefn("ror",    x86_ror,     0x02, 0xc1, od_rexw|od_e1|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-316");
    define(defn);

    //--- page 4-316 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 53 /r        RCPPS xmm1,        Valid    Valid           Computes the approximate reciprocals
    //                 xmm2/m128                                   of the packed single-precision floating-
    //                                                             point values in xmm2/m128 and stores
    //                                                             the results in xmm1.
    defn = new InsnDefn("rcpps",  x86_rcpps,   0x03, 0x0f53, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-319");
    define(defn);

    //--- page 4-319 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  F3 0F 53 RCPSS xmm1,               Valid        Valid         Computes the approximate reciprocal of
    //  /r       xmm2/m32                                             the scalar single-precision floating-point
    //                                                                value in xmm2/m32 and stores the result
    //                                                                in xmm1.
    defn = new InsnDefn("rcpss",  x86_rcpss,   0x03, 0xf30f53, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-322");
    define(defn);

    //--- page 4-322 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 32             RDMSR            Valid      Valid      Read MSR specified by ECX into
    //                                                          EDX:EAX.
    defn = new InsnDefn("rdmsr",  x86_rdmsr,   0x03, 0x0f32, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-324");
    define(defn);

    //--- page 4-324 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 0F 33           RDPMC            Valid    Valid         Read performance-monitoring
    //                                                         counter specified by ECX into
    //                                                         EDX:EAX.
    defn = new InsnDefn("rdpmc",  x86_rdpmc,   0x03, 0x0f33, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-329");
    define(defn);

    //--- page 4-329 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 31            RDTSC             Valid       Valid              Read time-stamp counter into
    //                                                                    EDX:EAX.
    defn = new InsnDefn("rdtsc",  x86_rdtsc,   0x03, 0x0f31, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-331");
    define(defn);

    //--- page 4-331 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 01 F9          RDTSCP           Valid         Valid            Read 64-bit time-stamp counter
    //                                                                    and 32-bit IA32_TSC_AUX value
    //                                                                    into EDX:EAX and ECX.
    defn = new InsnDefn("rdtscp", x86_rdtscp,  0x03, 0x0f01f9, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);

    //--- page 4-333 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  F3 6C              REP INS m8, DX       Valid      Valid        Input (E)CX bytes from port DX
    //                                                                  into ES:[(E)DI].
    defn = new InsnDefn("rep_insb", x86_rep_insb, 0x03, 0xf36c, od_none, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 6C              REP INS m8, DX       Valid      N.E.         Input RCX bytes from port DX
    //                                                                  into [RDI].
    defn = new InsnDefn("rep_insb", x86_rep_insb, 0x02, 0xf36c, od_none, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 6D              REP INS m16, DX      Valid      Valid        Input (E)CX words from port DX
    //                                                                  into ES:[(E)DI.]
    defn = new InsnDefn("rep_insw", x86_rep_insw, 0x03, 0xf36d, od_none, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 6D              REP INS m32, DX      Valid      Valid        Input (E)CX doublewords from
    //                                                                  port DX into ES:[(E)DI].
    defn = new InsnDefn("rep_insd", x86_rep_insd, 0x03, 0xf36d, od_none, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 6D              REP INS r/m32, DX    Valid      N.E.         Input RCX default size from port
    //                                                                  DX into [RDI].
    defn = new InsnDefn("rep_insd", x86_rep_insd, 0x02, 0xf36d, od_none, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 A4              REP MOVS m8, m8      Valid      Valid        Move (E)CX bytes from
    //                                                                  DS:[(E)SI] to ES:[(E)DI].
    defn = new InsnDefn("rep_movsb", x86_rep_movsb, 0x03, 0xf3a4, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 REX.W A4        REP MOVS m8, m8      Valid      N.E.         Move RCX bytes from [RSI] to
    //                                                                  [RDI].
    defn = new InsnDefn("rep_movsb", x86_rep_movsb, 0x02, 0xf3a4, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 A5              REP MOVS m16,        Valid      Valid        Move (E)CX words from
    //                     m16                                          DS:[(E)SI] to ES:[(E)DI].
    defn = new InsnDefn("rep_movsw", x86_rep_movsw, 0x03, 0xf3a5, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 A5              REP MOVS m32,        Valid      Valid        Move (E)CX doublewords from
    //                     m32                                          DS:[(E)SI] to ES:[(E)DI].
    defn = new InsnDefn("rep_movsd", x86_rep_movsd, 0x03, 0xf3a5, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 REX.W A5        REP MOVS m64,        Valid      N.E.         Move RCX quadwords from [RSI]
    //                     m64                                          to [RDI].
    defn = new InsnDefn("rep_movsq", x86_rep_movsq, 0x02, 0xf3a5, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 6E              REP OUTS DX, r/m8 Valid         Valid        Output (E)CX bytes from
    //                                                                  DS:[(E)SI] to port DX.
    defn = new InsnDefn("rep_outsb", x86_rep_outsb, 0x03, 0xf36e, od_none, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 REX.W 6E        REP OUTS DX,         Valid      N.E.         Output RCX bytes from [RSI] to
    //                     r/m8*                                        port DX.
    defn = new InsnDefn("rep_outsb", x86_rep_outsb, 0x02, 0xf36e, od_rexw, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 6F              REP OUTS DX,         Valid      Valid        Output (E)CX words from
    //                     r/m16                                        DS:[(E)SI] to port DX.
    defn = new InsnDefn("rep_outsw", x86_rep_outsw, 0x03, 0xf36f, od_none, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 6F              REP OUTS DX,         Valid      Valid        Output (E)CX doublewords from
    //                     r/m32                                        DS:[(E)SI] to port DX.
    defn = new InsnDefn("rep_outsd", x86_rep_outsd, 0x03, 0xf36f, od_none, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 REX.W 6F        REP OUTS DX,         Valid      N.E.         Output RCX default size from
    //                     r/m32                                        [RSI] to port DX.
    defn = new InsnDefn("rep_outsd", x86_rep_outsd, 0x02, 0xf36f, od_rexw, od_DX);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 AC              REP LODS AL          Valid      Valid        Load (E)CX bytes from DS:[(E)SI]
    //                                                                  to AL.
    defn = new InsnDefn("rep_lodsb", x86_rep_lodsb, 0x03, 0xf3ac, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 REX.W AC        REP LODS AL          Valid      N.E.         Load RCX bytes from [RSI] to
    //                                                                  AL.
    defn = new InsnDefn("rep_lodsb", x86_rep_lodsb, 0x02, 0xf3ac, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-333");
    define(defn);
    //  F3 AD              REP LODS AX          Valid      Valid        Load (E)CX words from DS:[(E)SI]
    //                                                                  to AX.
    defn = new InsnDefn("rep_lodsw", x86_rep_lodsw, 0x03, 0xf3ad, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 AD           REP LODS EAX      Valid     Valid         Load (E)CX doublewords from
    //                                                           DS:[(E)SI] to EAX.
    defn = new InsnDefn("rep_lodsd", x86_rep_lodsd, 0x03, 0xf3ad, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 REX.W AD     REP LODS RAX      Valid     N.E.          Load RCX quadwords from [RSI]
    //                                                           to RAX.
    defn = new InsnDefn("rep_lodsq", x86_rep_lodsq, 0x02, 0xf3ad, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 AA           REP STOS m8       Valid     Valid         Fill (E)CX bytes at ES:[(E)DI] with
    //                                                           AL.
    defn = new InsnDefn("rep_stosb", x86_rep_stosb, 0x03, 0xf3aa, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 REX.W AA     REP STOS m8       Valid     N.E.          Fill RCX bytes at [RDI] with AL.
    defn = new InsnDefn("rep_stosb", x86_rep_stosb, 0x02, 0xf3aa, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 AB           REP STOS m16      Valid     Valid         Fill (E)CX words at ES:[(E)DI]
    //                                                           with AX.
    defn = new InsnDefn("rep_stosw", x86_rep_stosw, 0x03, 0xf3ab, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 AB           REP STOS m32      Valid     Valid         Fill (E)CX doublewords at
    //                                                           ES:[(E)DI] with EAX.
    defn = new InsnDefn("rep_stosd", x86_rep_stosd, 0x03, 0xf3ab, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 REX.W AB     REP STOS m64      Valid     N.E.          Fill RCX quadwords at [RDI] with
    //                                                           RAX.
    defn = new InsnDefn("rep_stosq", x86_rep_stosq, 0x02, 0xf3ab, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 A6           REPE CMPS m8, m8 Valid      Valid         Find nonmatching bytes in
    //                                                           ES:[(E)DI] and DS:[(E)SI].
    defn = new InsnDefn("repe_cmpsb", x86_repe_cmpsb, 0x03, 0xf3a6, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 REX.W A6     REPE CMPS m8, m8 Valid      N.E.          Find non-matching bytes in
    //                                                           [RDI] and [RSI].
    defn = new InsnDefn("repe_cmpsb", x86_repe_cmpsb, 0x02, 0xf3a6, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 A7           REPE CMPS m16,    Valid     Valid         Find nonmatching words in
    //                 m16                                       ES:[(E)DI] and DS:[(E)SI].
    defn = new InsnDefn("repe_cmpsw", x86_repe_cmpsw, 0x03, 0xf3a7, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 A7           REPE CMPS m32,    Valid     Valid         Find nonmatching doublewords
    //                 m32                                       in ES:[(E)DI] and DS:[(E)SI].
    defn = new InsnDefn("repe_cmpsd", x86_repe_cmpsd, 0x03, 0xf3a7, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 REX.W A7     REPE CMPS m64,    Valid     N.E.          Find non-matching quadwords
    //                 m64                                       in [RDI] and [RSI].
    defn = new InsnDefn("repe_cmpsq", x86_repe_cmpsq, 0x02, 0xf3a7, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 AE           REPE SCAS m8      Valid     Valid         Find non-AL byte starting at
    //                                                           ES:[(E)DI].
    defn = new InsnDefn("repe_scasb", x86_repe_scasb, 0x03, 0xf3ae, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 REX.W AE     REPE SCAS m8      Valid     N.E.          Find non-AL byte starting at
    //                                                           [RDI].
    defn = new InsnDefn("repe_scasb", x86_repe_scasb, 0x02, 0xf3ae, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 AF           REPE SCAS m16     Valid     Valid         Find non-AX word starting at
    //                                                           ES:[(E)DI].
    defn = new InsnDefn("repe_scasw", x86_repe_scasw, 0x03, 0xf3af, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 AF           REPE SCAS m32     Valid     Valid         Find non-EAX doubleword
    //                                                           starting at ES:[(E)DI].
    defn = new InsnDefn("repe_scasd", x86_repe_scasd, 0x03, 0xf3af, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F3 REX.W AF     REPE SCAS m64     Valid     N.E.          Find non-RAX quadword
    //                                                           starting at [RDI].
    defn = new InsnDefn("repe_scasq", x86_repe_scasq, 0x02, 0xf3af, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F2 A6           REPNE CMPS m8,    Valid     Valid         Find matching bytes in ES:[(E)DI]
    //                 m8                                        and DS:[(E)SI].
    defn = new InsnDefn("repne_cmpsb", x86_repne_cmpsb, 0x03, 0xf2a6, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-334");
    define(defn);
    // F2 REX.W A6     REPNE CMPS m8,    Valid     N.E.          Find matching bytes in [RDI] and
    //                 m8                                        [RSI].
    defn = new InsnDefn("repne_cmpsb", x86_repne_cmpsb, 0x02, 0xf2a6, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-335");
    define(defn);
    //  F2 A7              REPNE CMPS m16,       Valid      Valid          Find matching words in
    //                     m16                                             ES:[(E)DI] and DS:[(E)SI].
    defn = new InsnDefn("repne_cmpsw", x86_repne_cmpsw, 0x03, 0xf2a7, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-335");
    define(defn);
    //  F2 A7              REPNE CMPS m32,       Valid      Valid          Find matching doublewords in
    //                     m32                                             ES:[(E)DI] and DS:[(E)SI].
    defn = new InsnDefn("repne_cmpsd", x86_repne_cmpsd, 0x03, 0xf2a7, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-335");
    define(defn);
    //  F2 REX.W A7        REPNE CMPS m64,       Valid      N.E.           Find matching doublewords in
    //                     m64                                             [RDI] and [RSI].
    defn = new InsnDefn("repne_cmpsq", x86_repne_cmpsq, 0x02, 0xf2a7, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-335");
    define(defn);
    //  F2 AE              REPNE SCAS m8         Valid      Valid          Find AL, starting at ES:[(E)DI].
    defn = new InsnDefn("repne_scasb", x86_repne_scasb, 0x03, 0xf2ae, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-335");
    define(defn);
    //  F2 REX.W AE        REPNE SCAS m8         Valid      N.E.           Find AL, starting at [RDI].
    defn = new InsnDefn("repne_scasb", x86_repne_scasb, 0x02, 0xf2ae, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-335");
    define(defn);
    //  F2 AF              REPNE SCAS m16        Valid      Valid          Find AX, starting at ES:[(E)DI].
    defn = new InsnDefn("repne_scasw", x86_repne_scasw, 0x03, 0xf2af, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-335");
    define(defn);
    //  F2 AF              REPNE SCAS m32        Valid      Valid          Find EAX, starting at ES:[(E)DI].
    defn = new InsnDefn("repne_scasd", x86_repne_scasd, 0x03, 0xf2af, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-335");
    define(defn);
    //  F2 REX.W AF        REPNE SCAS m64        Valid      N.E.           Find RAX, starting at [RDI].
    defn = new InsnDefn("repne_scasq", x86_repne_scasq, 0x02, 0xf2af, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-338");
    define(defn);

    //--- page 4-338 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // C3              RET           Valid    Valid       Near return to calling procedure.
    defn = new InsnDefn("ret",    x86_ret,     0x03, 0xc3, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-338");
    define(defn);
    // CB              RET           Valid    Valid       Far return to calling procedure.
    defn = new InsnDefn("ret",    x86_retf,    0x03, 0xcb, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-338");
    define(defn);
    // C2 iw           RET imm16     Valid    Valid       Near return to calling procedure and pop
    //                                                    imm16 bytes from stack.
    defn = new InsnDefn("ret",    x86_ret,     0x03, 0xc2, od_iw, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-338");
    define(defn);
    // CA iw           RET imm16     Valid    Valid       Far return to calling procedure and pop
    //                                                    imm16 bytes from stack.
    defn = new InsnDefn("ret",    x86_retf,    0x03, 0xca, od_iw, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-350");
    define(defn);

    //--- page 4-350 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 3A        ROUNDPD xmm1,          Valid    Valid          Round packed double precision
    // 09 /r ib        xmm2/m128, imm8                                floating-point values in
    //                                                                xmm2/m128 and place the result in
    //                                                                xmm1. The rounding mode is
    //                                                                determined by imm8.
    defn = new InsnDefn("roundpd", x86_roundpd, 0x03, 0x660f3a09, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-354");
    define(defn);

    //--- page 4-354 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 3A 08     ROUNDPS xmm1,       Valid     Valid          Round packed single precision
    // /r ib           xmm2/m128, imm8                              floating-point values in
    //                                                              xmm2/m128 and place the result
    //                                                              in xmm1. The rounding mode is
    //                                                              determined by imm8.
    defn = new InsnDefn("roundps", x86_roundps, 0x03, 0x660f3a08, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-357");
    define(defn);

    //--- page 4-357 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  66 0F 3A 0B      ROUNDSD xmm1, Valid              Valid        Round the low packed double
    //  /r ib            xmm2/m64, imm8                                precision floating-point value in
    //                                                                 xmm2/m64 and place the result in
    //                                                                 xmm1. The rounding mode is
    //                                                                 determined by imm8.
    defn = new InsnDefn("roundsd", x86_roundsd, 0x03, 0x660f3a0b, od_modrm|od_ib, od_xmm, od_xmm_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-360");
    define(defn);

    //--- page 4-360 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 66 0F 3A 0A /r   ROUNDSS xmm1,          Valid     Valid           Round the low packed single
    // ib               xmm2/m32, imm8                                   precision floating-point value
    //                                                                   in xmm2/m32 and place the
    //                                                                   result in xmm1. The rounding
    //                                                                   mode is determined by imm8.
    defn = new InsnDefn("roundss", x86_roundss, 0x03, 0x660f3a0a, od_modrm|od_ib, od_xmm, od_xmm_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-363");
    define(defn);

    //--- page 4-363 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F AA             RSM           Invalid   Valid           Resume operation of interrupted
    //                                                            program.
    defn = new InsnDefn("rsm",    x86_rsm,     0x01, 0x0faa, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-365");
    define(defn);

    //--- page 4-365 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 52 /r      RSQRTPS xmm1,          Valid       Valid          Computes the approximate reciprocals
    //                xmm2/m128                                         of the square roots of the packed
    //                                                                  single-precision floating-point values
    //                                                                  in xmm2/m128 and stores the results
    //                                                                  in xmm1.
    defn = new InsnDefn("rsqrtps", x86_rsqrtps, 0x03, 0x0f52, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-368");
    define(defn);

    //--- page 4-368 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // F3 0F 52 /r RSQRTSS xmm1,           Valid      Valid          Computes the approximate reciprocal of
    //             xmm2/m32                                          the square root of the low single-
    //                                                               precision floating-point value in
    //                                                               xmm2/m32 and stores the results in
    //                                                               xmm1.
    defn = new InsnDefn("rsqrtss", x86_rsqrtss, 0x03, 0xf30f52, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-371");
    define(defn);

    //--- page 4-371 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  9E            SAHF            Invalid*      Valid         Loads SF, ZF, AF, PF, and CF from AH
    //                                                            into EFLAGS register.
    defn = new InsnDefn("sahf",   x86_sahf,    0x01, 0x9e, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);

    //--- page 4-373 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  D0 /4                  SAL r/m8, 1        Valid    Valid       Multiply r/m8 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd0, od_e4, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  REX + D0 /4            SAL r/m8**, 1      Valid    N.E.        Multiply r/m8 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xd0, od_rex|od_e4, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  D2 /4                  SAL r/m8, CL       Valid    Valid       Multiply r/m8 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd2, od_e4, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  REX + D2 /4            SAL r/m8**, CL     Valid    N.E.        Multiply r/m8 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xd2, od_rex|od_e4, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  C0 /4 ib               SAL r/m8, imm8     Valid    Valid       Multiply r/m8 by 2, imm8
    //                                                                 times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xc0, od_e4|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  REX + C0 /4 ib         SAL r/m8**, imm8   Valid    N.E.        Multiply r/m8 by 2, imm8
    //                                                                 times.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xc0, od_rex|od_e4|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  D1 /4                  SAL r/m16, 1       Valid    Valid       Multiply r/m16 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd1, od_e4, od_r_m16, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  D3 /4                  SAL r/m16, CL      Valid    Valid       Multiply r/m16 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd3, od_e4, od_r_m16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  C1 /4 ib               SAL r/m16, imm8    Valid    Valid       Multiply r/m16 by 2, imm8
    //                                                                 times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xc1, od_e4|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  D1 /4                  SAL r/m32, 1       Valid    Valid       Multiply r/m32 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd1, od_e4, od_r_m32, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  REX.W + D1 /4          SAL r/m64, 1       Valid    N.E.        Multiply r/m64 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xd1, od_rexw|od_e4, od_r_m64, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  D3 /4                  SAL r/m32, CL      Valid    Valid       Multiply r/m32 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd3, od_e4, od_r_m32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  REX.W + D3 /4          SAL r/m64, CL      Valid    N.E.        Multiply r/m64 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xd3, od_rexw|od_e4, od_r_m64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  C1 /4 ib               SAL r/m32, imm8    Valid    Valid       Multiply r/m32 by 2, imm8
    //                                                                 times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xc1, od_e4|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  REX.W + C1 /4 ib       SAL r/m64, imm8    Valid    N.E.        Multiply r/m64 by 2, imm8
    //                                                                 times.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xc1, od_rexw|od_e4|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  D0 /7                  SAR r/m8, 1        Valid    Valid       Signed divide* r/m8 by 2,
    //                                                                 once.
    defn = new InsnDefn("sar",    x86_sar,     0x03, 0xd0, od_e7, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  REX + D0 /7            SAR r/m8**, 1      Valid    N.E.        Signed divide* r/m8 by 2,
    //                                                                 once.
    defn = new InsnDefn("sar",    x86_sar,     0x02, 0xd0, od_rex|od_e7, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  D2 /7                  SAR r/m8, CL       Valid    Valid       Signed divide* r/m8 by 2, CL
    //                                                                 times.
    defn = new InsnDefn("sar",    x86_sar,     0x03, 0xd2, od_e7, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  REX + D2 /7            SAR r/m8**, CL     Valid    N.E.        Signed divide* r/m8 by 2, CL
    //                                                                 times.
    defn = new InsnDefn("sar",    x86_sar,     0x02, 0xd2, od_rex|od_e7, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  C0 /7 ib               SAR r/m8, imm8     Valid    Valid       Signed divide* r/m8 by 2,
    //                                                                 imm8 time.
    defn = new InsnDefn("sar",    x86_sar,     0x03, 0xc0, od_e7|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  REX + C0 /7 ib         SAR r/m8**, imm8   Valid    N.E.        Signed divide* r/m8 by 2,
    //                                                                 imm8 times.
    defn = new InsnDefn("sar",    x86_sar,     0x02, 0xc0, od_rex|od_e7|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-373");
    define(defn);
    //  D1 /7                  SAR r/m16,1        Valid    Valid       Signed divide* r/m16 by 2,
    //                                                                 once.
    defn = new InsnDefn("sar",    x86_sar,     0x03, 0xd1, od_e7, od_r_m16, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // D3 /7              SAR r/m16, CL      Valid    Valid      Signed divide* r/m16 by 2, CL
    //                                                           times.
    defn = new InsnDefn("sar",    x86_sar,     0x03, 0xd3, od_e7, od_r_m16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // C1 /7 ib           SAR r/m16, imm8    Valid    Valid      Signed divide* r/m16 by 2,
    //                                                           imm8 times.
    defn = new InsnDefn("sar",    x86_sar,     0x03, 0xc1, od_e7|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // D1 /7              SAR r/m32, 1       Valid    Valid      Signed divide* r/m32 by 2,
    //                                                           once.
    defn = new InsnDefn("sar",    x86_sar,     0x03, 0xd1, od_e7, od_r_m32, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // REX.W + D1 /7      SAR r/m64, 1       Valid    N.E.       Signed divide* r/m64 by 2,
    //                                                           once.
    defn = new InsnDefn("sar",    x86_sar,     0x02, 0xd1, od_rexw|od_e7, od_r_m64, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // D3 /7              SAR r/m32, CL      Valid    Valid      Signed divide* r/m32 by 2, CL
    //                                                           times.
    defn = new InsnDefn("sar",    x86_sar,     0x03, 0xd3, od_e7, od_r_m32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // REX.W + D3 /7      SAR r/m64, CL      Valid    N.E.       Signed divide* r/m64 by 2, CL
    //                                                           times.
    defn = new InsnDefn("sar",    x86_sar,     0x02, 0xd3, od_rexw|od_e7, od_r_m64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // C1 /7 ib           SAR r/m32, imm8    Valid    Valid      Signed divide* r/m32 by 2,
    //                                                           imm8 times.
    defn = new InsnDefn("sar",    x86_sar,     0x03, 0xc1, od_e7|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // REX.W + C1 /7 ib   SAR r/m64, imm8    Valid    N.E.       Signed divide* r/m64 by 2,
    //                                                           imm8 times
    defn = new InsnDefn("sar",    x86_sar,     0x02, 0xc1, od_rexw|od_e7|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // D0 /4              SHL r/m8, 1        Valid    Valid      Multiply r/m8 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd0, od_e4, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // REX + D0 /4        SHL r/m8**, 1      Valid    N.E.       Multiply r/m8 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xd0, od_rex|od_e4, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // D2 /4              SHL r/m8, CL       Valid    Valid      Multiply r/m8 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd2, od_e4, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // REX + D2 /4        SHL r/m8**, CL     Valid    N.E.       Multiply r/m8 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xd2, od_rex|od_e4, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // C0 /4 ib           SHL r/m8, imm8     Valid    Valid      Multiply r/m8 by 2, imm8
    //                                                           times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xc0, od_e4|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // REX + C0 /4 ib     SHL r/m8**, imm8   Valid    N.E.       Multiply r/m8 by 2, imm8
    //                                                           times.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xc0, od_rex|od_e4|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // D1 /4              SHL r/m16,1        Valid    Valid      Multiply r/m16 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd1, od_e4, od_r_m16, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // D3 /4              SHL r/m16, CL      Valid    Valid      Multiply r/m16 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd3, od_e4, od_r_m16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // C1 /4 ib           SHL r/m16, imm8    Valid    Valid      Multiply r/m16 by 2, imm8
    //                                                           times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xc1, od_e4|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // D1 /4              SHL r/m32,1        Valid    Valid      Multiply r/m32 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd1, od_e4, od_r_m32, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // REX.W + D1 /4      SHL r/m64,1        Valid    N.E.       Multiply r/m64 by 2, once.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xd1, od_rexw|od_e4, od_r_m64, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // D3 /4              SHL r/m32, CL      Valid    Valid      Multiply r/m32 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xd3, od_e4, od_r_m32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // REX.W + D3 /4      SHL r/m64, CL      Valid    N.E.       Multiply r/m64 by 2, CL times.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xd3, od_rexw|od_e4, od_r_m64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // C1 /4 ib           SHL r/m32, imm8    Valid    Valid      Multiply r/m32 by 2, imm8
    //                                                           times.
    defn = new InsnDefn("shl",    x86_shl,     0x03, 0xc1, od_e4|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-374");
    define(defn);
    // REX.W + C1 /4 ib   SHL r/m64, imm8    Valid    N.E.       Multiply r/m64 by 2, imm8
    //                                                           times.
    defn = new InsnDefn("shl",    x86_shl,     0x02, 0xc1, od_rexw|od_e4|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  D0 /5                  SHR r/m8,1          Valid       Valid          Unsigned divide r/m8 by 2,
    //                                                                        once.
    defn = new InsnDefn("shr",    x86_shr,     0x03, 0xd0, od_e5, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  REX + D0 /5            SHR r/m8**, 1       Valid       N.E.           Unsigned divide r/m8 by 2,
    //                                                                        once.
    defn = new InsnDefn("shr",    x86_shr,     0x02, 0xd0, od_rex|od_e5, od_r_m8, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  D2 /5                  SHR r/m8, CL        Valid       Valid          Unsigned divide r/m8 by 2, CL
    //                                                                        times.
    defn = new InsnDefn("shr",    x86_shr,     0x03, 0xd2, od_e5, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  REX + D2 /5            SHR r/m8**, CL      Valid       N.E.           Unsigned divide r/m8 by 2, CL
    //                                                                        times.
    defn = new InsnDefn("shr",    x86_shr,     0x02, 0xd2, od_rex|od_e5, od_r_m8, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  C0 /5 ib               SHR r/m8, imm8      Valid       Valid          Unsigned divide r/m8 by 2,
    //                                                                        imm8 times.
    defn = new InsnDefn("shr",    x86_shr,     0x03, 0xc0, od_e5|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  REX + C0 /5 ib         SHR r/m8**, imm8    Valid       N.E.           Unsigned divide r/m8 by 2,
    //                                                                        imm8 times.
    defn = new InsnDefn("shr",    x86_shr,     0x02, 0xc0, od_rex|od_e5|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  D1 /5                  SHR r/m16, 1        Valid       Valid          Unsigned divide r/m16 by 2,
    //                                                                        once.
    defn = new InsnDefn("shr",    x86_shr,     0x03, 0xd1, od_e5, od_r_m16, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  D3 /5                  SHR r/m16, CL       Valid       Valid          Unsigned divide r/m16 by 2,
    //                                                                        CL times
    defn = new InsnDefn("shr",    x86_shr,     0x03, 0xd3, od_e5, od_r_m16, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  C1 /5 ib               SHR r/m16, imm8     Valid       Valid          Unsigned divide r/m16 by 2,
    //                                                                        imm8 times.
    defn = new InsnDefn("shr",    x86_shr,     0x03, 0xc1, od_e5|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  D1 /5                  SHR r/m32, 1        Valid       Valid          Unsigned divide r/m32 by 2,
    //                                                                        once.
    defn = new InsnDefn("shr",    x86_shr,     0x03, 0xd1, od_e5, od_r_m32, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  REX.W + D1 /5          SHR r/m64, 1        Valid       N.E.           Unsigned divide r/m64 by 2,
    //                                                                        once.
    defn = new InsnDefn("shr",    x86_shr,     0x02, 0xd1, od_rexw|od_e5, od_r_m64, od_1);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  D3 /5                  SHR r/m32, CL       Valid       Valid          Unsigned divide r/m32 by 2,
    //                                                                        CL times.
    defn = new InsnDefn("shr",    x86_shr,     0x03, 0xd3, od_e5, od_r_m32, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  REX.W + D3 /5          SHR r/m64, CL       Valid       N.E.           Unsigned divide r/m64 by 2,
    //                                                                        CL times.
    defn = new InsnDefn("shr",    x86_shr,     0x02, 0xd3, od_rexw|od_e5, od_r_m64, od_CL);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  C1 /5 ib               SHR r/m32, imm8     Valid       Valid          Unsigned divide r/m32 by 2,
    //                                                                        imm8 times.
    defn = new InsnDefn("shr",    x86_shr,     0x03, 0xc1, od_e5|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-375");
    define(defn);
    //  REX.W + C1 /5 ib       SHR r/m64, imm8     Valid       N.E.           Unsigned divide r/m64 by 2,
    //                                                                        imm8 times.
    defn = new InsnDefn("shr",    x86_shr,     0x02, 0xc1, od_rexw|od_e5|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);

    //--- page 4-380 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // 1C ib              SBB AL, imm8      Valid    Valid          Subtract with borrow imm8
    //                                                              from AL.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x1c, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 1D iw              SBB AX, imm16     Valid    Valid          Subtract with borrow imm16
    //                                                              from AX.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x1d, od_iw, od_AX, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 1D id              SBB EAX, imm32    Valid    Valid          Subtract with borrow imm32
    //                                                              from EAX.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x1d, od_id, od_EAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // REX.W + 1D id      SBB RAX, imm32    Valid    N.E.           Subtract with borrow sign-
    //                                                              extended imm.32 to 64-bits
    //                                                              from RAX.
    defn = new InsnDefn("sbb",    x86_sbb,     0x02, 0x1d, od_rexw|od_id, od_RAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 80 /3 ib           SBB r/m8, imm8    Valid    Valid          Subtract with borrow imm8
    //                                                              from r/m8.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x80, od_e3|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // REX + 80 /3 ib     SBB r/m8*, imm8   Valid    N.E.           Subtract with borrow imm8
    //                                                              from r/m8.
    defn = new InsnDefn("sbb",    x86_sbb,     0x02, 0x80, od_rex|od_e3|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 81 /3 iw           SBB r/m16, imm16 Valid     Valid          Subtract with borrow imm16
    //                                                              from r/m16.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x81, od_e3|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 81 /3 id           SBB r/m32, imm32 Valid     Valid          Subtract with borrow imm32
    //                                                              from r/m32.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x81, od_e3|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // REX.W + 81 /3 id   SBB r/m64, imm32 Valid     N.E.           Subtract with borrow sign-
    //                                                              extended imm32 to 64-bits
    //                                                              from r/m64.
    defn = new InsnDefn("sbb",    x86_sbb,     0x02, 0x81, od_rexw|od_e3|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 83 /3 ib           SBB r/m16, imm8   Valid    Valid          Subtract with borrow sign-
    //                                                              extended imm8 from r/m16.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x83, od_e3|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 83 /3 ib           SBB r/m32, imm8   Valid    Valid          Subtract with borrow sign-
    //                                                              extended imm8 from r/m32.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x83, od_e3|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // REX.W + 83 /3 ib   SBB r/m64, imm8   Valid    N.E.           Subtract with borrow sign-
    //                                                              extended imm8 from r/m64.
    defn = new InsnDefn("sbb",    x86_sbb,     0x02, 0x83, od_rexw|od_e3|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 18 /r              SBB r/m8, r8      Valid    Valid          Subtract with borrow r8
    //                                                              from r/m8.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x18, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // REX + 18 /r        SBB r/m8*, r8     Valid    N.E.           Subtract with borrow r8
    //                                                              from r/m8.
    defn = new InsnDefn("sbb",    x86_sbb,     0x02, 0x18, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 19 /r              SBB r/m16, r16    Valid    Valid          Subtract with borrow r16
    //                                                              from r/m16.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x19, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // 19 /r              SBB r/m32, r32    Valid    Valid          Subtract with borrow r32
    //                                                              from r/m32.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x19, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-380");
    define(defn);
    // REX.W + 19 /r      SBB r/m64, r64    Valid    N.E.           Subtract with borrow r64
    //                                                              from r/m64.
    defn = new InsnDefn("sbb",    x86_sbb,     0x02, 0x19, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-381");
    define(defn);
    //  1A /r                 SBB r8, r/m8         Valid       Valid          Subtract with borrow r/m8
    //                                                                        from r8.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x1a, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-381");
    define(defn);
    //  REX + 1A /r           SBB r8*, r/m8*       Valid       N.E.           Subtract with borrow r/m8
    //                                                                        from r8.
    defn = new InsnDefn("sbb",    x86_sbb,     0x02, 0x1a, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-381");
    define(defn);
    //  1B /r                 SBB r16, r/m16       Valid       Valid          Subtract with borrow r/m16
    //                                                                        from r16.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x1b, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-381");
    define(defn);
    //  1B /r                 SBB r32, r/m32       Valid       Valid          Subtract with borrow r/m32
    //                                                                        from r32.
    defn = new InsnDefn("sbb",    x86_sbb,     0x03, 0x1b, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-381");
    define(defn);
    //  REX.W + 1B /r         SBB r64, r/m64       Valid       N.E.           Subtract with borrow r/m64
    //                                                                        from r64.
    defn = new InsnDefn("sbb",    x86_sbb,     0x02, 0x1b, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-384");
    define(defn);

    //--- page 4-384 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    // AE              SCAS m8          Valid       Valid          Compare AL with byte at ES:(E)DI or RDI,
    //                                                             then set status flags.*
    // See SCASB, SCASW, SCASD, or SCASQ instead.
    // defn = new InsnDefn("scas",   x86_scas,    0x03, 0xae, od_none, od_m8);
    // defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-384");
    // define(defn);
    // AF              SCAS m16         Valid       Valid          Compare AX with word at ES:(E)DI or
    //                                                             RDI, then set status flags.*
    // See SCASB, SCASW, SCASD, or SCASQ instead.
    // defn = new InsnDefn("scas",   x86_scas,    0x03, 0xaf, od_none, od_m16);
    // defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-384");
    // define(defn);
    // AF              SCAS m32         Valid       Valid          Compare EAX with doubleword at
    //                                                             ES(E)DI or RDI then set status flags.*
    // See SCASB, SCASW, SCASD, or SCASQ instead.
    // defn = new InsnDefn("scas",   x86_scas,    0x03, 0xaf, od_none, od_m32);
    // defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-384");
    // define(defn);
    // REX.W + AF      SCAS m64         Valid       N.E.           Compare RAX with quadword at RDI or
    //                                                             EDI then set status flags.
    // See SCASB, SCASW, SCASD, or SCASQ instead.
    // defn = new InsnDefn("scas",   x86_scas,    0x02, 0xaf, od_rexw, od_m64);
    // defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-384");
    // define(defn);
    // AE              SCASB            Valid       Valid          Compare AL with byte at ES:(E)DI or RDI
    //                                                             then set status flags.*
    defn = new InsnDefn("scasb",  x86_scasb,   0x03, 0xae, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-384");
    define(defn);
    // AF              SCASW            Valid       Valid          Compare AX with word at ES:(E)DI or RDI
    //                                                             then set status flags.*
    defn = new InsnDefn("scasw",  x86_scasw,   0x03, 0xaf, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-384");
    define(defn);
    // AF              SCASD            Valid       Valid          Compare EAX with doubleword at
    //                                                             ES:(E)DI or RDI then set status flags.*
    defn = new InsnDefn("scasd",  x86_scasd,   0x03, 0xaf, od_none);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-384");
    define(defn);
    // REX.W + AF      SCASQ            Valid       N.E.           Compare RAX with quadword at RDI or
    //                                                             EDI then set status flags.
    defn = new InsnDefn("scasq",  x86_scasq,   0x02, 0xaf, od_rexw);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);

    //--- page 4-389 of x86-InstructionSetReference-NZ.pdf -------------------------------------------------------------
    //  0F 97              SETA r/m8     Valid    Valid      Set byte if above (CF=0 and
    //                                                       ZF=0).
    defn = new InsnDefn("seta",   x86_seta,    0x03, 0x0f97, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 97        SETA r/m8*    Valid    N.E.       Set byte if above (CF=0 and
    //                                                       ZF=0).
    defn = new InsnDefn("seta",   x86_seta,    0x02, 0x0f97, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 93              SETAE r/m8    Valid    Valid      Set byte if above or equal (CF=0).
    defn = new InsnDefn("setae",  x86_setae,   0x03, 0x0f93, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 93        SETAE r/m8*   Valid    N.E.       Set byte if above or equal (CF=0).
    defn = new InsnDefn("setae",  x86_setae,   0x02, 0x0f93, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 92              SETB r/m8     Valid    Valid      Set byte if below (CF=1).
    defn = new InsnDefn("setb",   x86_setb,    0x03, 0x0f92, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 92        SETB r/m8*    Valid    N.E.       Set byte if below (CF=1).
    defn = new InsnDefn("setb",   x86_setb,    0x02, 0x0f92, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 96              SETBE r/m8    Valid    Valid      Set byte if below or equal (CF=1
    //                                                       or ZF=1).
    defn = new InsnDefn("setbe",  x86_setbe,   0x03, 0x0f96, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 96        SETBE r/m8*   Valid    N.E.       Set byte if below or equal (CF=1
    //                                                       or ZF=1).
    defn = new InsnDefn("setbe",  x86_setbe,   0x02, 0x0f96, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 92              SETC r/m8     Valid    Valid      Set byte if carry (CF=1).
    defn = new InsnDefn("setb",   x86_setb,    0x03, 0x0f92, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 92        SETC r/m8*    Valid    N.E.       Set byte if carry (CF=1).
    defn = new InsnDefn("setb",   x86_setb,    0x02, 0x0f92, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 94              SETE r/m8     Valid    Valid      Set byte if equal (ZF=1).
    defn = new InsnDefn("sete",   x86_sete,    0x03, 0x0f94, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 94        SETE r/m8*    Valid    N.E.       Set byte if equal (ZF=1).
    defn = new InsnDefn("sete",   x86_sete,    0x02, 0x0f94, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 9F              SETG r/m8     Valid    Valid      Set byte if greater (ZF=0 and
    //                                                       SF=OF).
    defn = new InsnDefn("setg",   x86_setg,    0x03, 0x0f9f, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 9F        SETG r/m8*    Valid    N.E.       Set byte if greater (ZF=0 and
    //                                                       SF=OF).
    defn = new InsnDefn("setg",   x86_setg,    0x02, 0x0f9f, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 9D              SETGE r/m8    Valid    Valid      Set byte if greater or equal
    //                                                       (SF=OF).
    defn = new InsnDefn("setge",  x86_setge,   0x03, 0x0f9d, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 9D        SETGE r/m8*   Valid    N.E.       Set byte if greater or equal
    //                                                       (SF=OF).
    defn = new InsnDefn("setge",  x86_setge,   0x02, 0x0f9d, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 9C              SETL r/m8     Valid    Valid      Set byte if less (SF OF).
    defn = new InsnDefn("setl",   x86_setl,    0x03, 0x0f9c, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 9C        SETL r/m8*    Valid    N.E.       Set byte if less (SF OF).
    defn = new InsnDefn("setl",   x86_setl,    0x02, 0x0f9c, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 9E              SETLE r/m8    Valid    Valid      Set byte if less or equal (ZF=1 or
    //                                                       SF OF).
    defn = new InsnDefn("setle",  x86_setle,   0x03, 0x0f9e, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 9E        SETLE r/m8*   Valid    N.E.       Set byte if less or equal (ZF=1 or
    //                                                       SF OF).
    defn = new InsnDefn("setle",  x86_setle,   0x02, 0x0f9e, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  0F 96              SETNA r/m8    Valid    Valid      Set byte if not above (CF=1 or
    //                                                       ZF=1).
    defn = new InsnDefn("setbe",  x86_setbe,   0x03, 0x0f96, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-389");
    define(defn);
    //  REX + 0F 96        SETNA r/m8*   Valid    N.E.       Set byte if not above (CF=1 or
    //                                                       ZF=1).
    defn = new InsnDefn("setbe",  x86_setbe,   0x02, 0x0f96, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 92           SETNAE r/m8      Valid    Valid      Set byte if not above or equal
    //                                                      (CF=1).
    defn = new InsnDefn("setb",   x86_setb,    0x03, 0x0f92, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 92     SETNAE r/m8*     Valid    N.E.       Set byte if not above or equal
    //                                                      (CF=1).
    defn = new InsnDefn("setb",   x86_setb,    0x02, 0x0f92, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 93           SETNB r/m8       Valid    Valid      Set byte if not below (CF=0).
    defn = new InsnDefn("setae",  x86_setae,   0x03, 0x0f93, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 93     SETNB r/m8*      Valid    N.E.       Set byte if not below (CF=0).
    defn = new InsnDefn("setae",  x86_setae,   0x02, 0x0f93, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 97           SETNBE r/m8      Valid    Valid      Set byte if not below or equal
    //                                                      (CF=0 and ZF=0).
    defn = new InsnDefn("seta",   x86_seta,    0x03, 0x0f97, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 97     SETNBE r/m8*     Valid    N.E.       Set byte if not below or equal
    //                                                      (CF=0 and ZF=0).
    defn = new InsnDefn("seta",   x86_seta,    0x02, 0x0f97, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 93           SETNC r/m8       Valid    Valid      Set byte if not carry (CF=0).
    defn = new InsnDefn("setae",  x86_setae,   0x03, 0x0f93, od_none, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // REX + 0F 93     SETNC r/m8*      Valid    N.E.       Set byte if not carry (CF=0).
    defn = new InsnDefn("setae",  x86_setae,   0x02, 0x0f93, od_rex, od_r_m8);
    defn->set_location("x86-InstructionSetReference-NZ.pdf, page 4-390");
    define(defn);
    // 0F 95           SETNE r/m8       Valid    Valid      Set byte if not equal (ZF=0).
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
