//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "sage3basic.h"
#include "AssemblerX86.h"

/* Generated by ./IntelAssemblyBuilder from 
 * x86-InstructionSetReference-AM.pdf 
 * x86-InstructionSetReference-NZ.pdf 
 * ExtraInstructions.txt */
void AssemblerX86::initAssemblyRules_part2() {
    AssemblerX86::InsnDefn *defn = NULL;
    defn = new InsnDefn("cmovno", x86_cmovno,  0x03, 0x0f41, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 41 /r           CMOVNO r32, r/m32    Valid    Valid      Move if not overflow
    //                                                             (OF=0).
    defn = new InsnDefn("cmovno", x86_cmovno,  0x03, 0x0f41, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // REX.W + 0F 41 /r   CMOVNO r64, r/m64    Valid    N.E.       Move if not overflow
    //                                                             (OF=0).
    defn = new InsnDefn("cmovno", x86_cmovno,  0x02, 0x0f41, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4B /r           CMOVNP r16, r/m16    Valid    Valid      Move if not parity
    //                                                             (PF=0).
    defn = new InsnDefn("cmovpo", x86_cmovpo,  0x03, 0x0f4b, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-136");
    define(defn);
    // 0F 4B /r           CMOVNP r32, r/m32    Valid    Valid      Move if not parity
    //                                                             (PF=0).
    defn = new InsnDefn("cmovpo", x86_cmovpo,  0x03, 0x0f4b, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  REX.W + 0F 4B /r    CMOVNP r64, r/m64   Valid    N.E.            Move if not parity
    //                                                                   (PF=0).
    defn = new InsnDefn("cmovpo", x86_cmovpo,  0x02, 0x0f4b, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 49 /r            CMOVNS r16, r/m16   Valid    Valid           Move if not sign (SF=0).
    defn = new InsnDefn("cmovns", x86_cmovns,  0x03, 0x0f49, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 49 /r            CMOVNS r32, r/m32   Valid    Valid           Move if not sign (SF=0).
    defn = new InsnDefn("cmovns", x86_cmovns,  0x03, 0x0f49, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  REX.W + 0F 49 /r    CMOVNS r64, r/m64   Valid    N.E.            Move if not sign (SF=0).
    defn = new InsnDefn("cmovns", x86_cmovns,  0x02, 0x0f49, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 45 /r            CMOVNZ r16, r/m16   Valid    Valid           Move if not zero (ZF=0).
    defn = new InsnDefn("cmovne", x86_cmovne,  0x03, 0x0f45, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 45 /r            CMOVNZ r32, r/m32   Valid    Valid           Move if not zero (ZF=0).
    defn = new InsnDefn("cmovne", x86_cmovne,  0x03, 0x0f45, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  REX.W + 0F 45 /r    CMOVNZ r64, r/m64   Valid    N.E.            Move if not zero (ZF=0).
    defn = new InsnDefn("cmovne", x86_cmovne,  0x02, 0x0f45, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 40 /r            CMOVO r16, r/m16    Valid    Valid           Move if overflow (OF=0).
    defn = new InsnDefn("cmovo",  x86_cmovo,   0x03, 0x0f40, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 40 /r            CMOVO r32, r/m32    Valid    Valid           Move if overflow (OF=0).
    defn = new InsnDefn("cmovo",  x86_cmovo,   0x03, 0x0f40, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  REX.W + 0F 40 /r    CMOVO r64, r/m64    Valid    N.E.            Move if overflow (OF=0).
    defn = new InsnDefn("cmovo",  x86_cmovo,   0x02, 0x0f40, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 4A /r            CMOVP r16, r/m16    Valid    Valid           Move if parity (PF=1).
    defn = new InsnDefn("cmovpe", x86_cmovpe,  0x03, 0x0f4a, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 4A /r            CMOVP r32, r/m32    Valid    Valid           Move if parity (PF=1).
    defn = new InsnDefn("cmovpe", x86_cmovpe,  0x03, 0x0f4a, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  REX.W + 0F 4A /r    CMOVP r64, r/m64    Valid    N.E.            Move if parity (PF=1).
    defn = new InsnDefn("cmovpe", x86_cmovpe,  0x02, 0x0f4a, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 4A /r            CMOVPE r16, r/m16   Valid    Valid           Move if parity even
    //                                                                   (PF=1).
    defn = new InsnDefn("cmovpe", x86_cmovpe,  0x03, 0x0f4a, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 4A /r            CMOVPE r32, r/m32   Valid    Valid           Move if parity even
    //                                                                   (PF=1).
    defn = new InsnDefn("cmovpe", x86_cmovpe,  0x03, 0x0f4a, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  REX.W + 0F 4A /r    CMOVPE r64, r/m64   Valid    N.E.            Move if parity even
    //                                                                   (PF=1).
    defn = new InsnDefn("cmovpe", x86_cmovpe,  0x02, 0x0f4a, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 4B /r            CMOVPO r16, r/m16   Valid    Valid           Move if parity odd
    //                                                                   (PF=0).
    defn = new InsnDefn("cmovpo", x86_cmovpo,  0x03, 0x0f4b, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 4B /r            CMOVPO r32, r/m32   Valid    Valid           Move if parity odd
    //                                                                   (PF=0).
    defn = new InsnDefn("cmovpo", x86_cmovpo,  0x03, 0x0f4b, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  REX.W + 0F 4B /r    CMOVPO r64, r/m64   Valid    N.E.            Move if parity odd
    //                                                                   (PF=0).
    defn = new InsnDefn("cmovpo", x86_cmovpo,  0x02, 0x0f4b, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 48 /r            CMOVS r16, r/m16    Valid    Valid           Move if sign (SF=1).
    defn = new InsnDefn("cmovs",  x86_cmovs,   0x03, 0x0f48, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 48 /r            CMOVS r32, r/m32    Valid    Valid           Move if sign (SF=1).
    defn = new InsnDefn("cmovs",  x86_cmovs,   0x03, 0x0f48, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  REX.W + 0F 48 /r    CMOVS r64, r/m64    Valid    N.E.            Move if sign (SF=1).
    defn = new InsnDefn("cmovs",  x86_cmovs,   0x02, 0x0f48, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 44 /r            CMOVZ r16, r/m16    Valid    Valid           Move if zero (ZF=1).
    defn = new InsnDefn("cmove",  x86_cmove,   0x03, 0x0f44, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  0F 44 /r            CMOVZ r32, r/m32    Valid    Valid           Move if zero (ZF=1).
    defn = new InsnDefn("cmove",  x86_cmove,   0x03, 0x0f44, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-137");
    define(defn);
    //  REX.W + 0F 44 /r    CMOVZ r64, r/m64    Valid    N.E.            Move if zero (ZF=1).
    defn = new InsnDefn("cmove",  x86_cmove,   0x02, 0x0f44, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);

    //--- page 3-141 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  3C ib               CMP AL, imm8        Valid          Valid          Compare imm8 with AL.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x3c, od_ib, od_AL, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  3D iw               CMP AX, imm16       Valid          Valid          Compare imm16 with AX.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x3d, od_iw, od_AX, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  3D id               CMP EAX, imm32 Valid               Valid          Compare imm32 with EAX.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x3d, od_id, od_EAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  REX.W + 3D id       CMP RAX, imm32 Valid               N.E.           Compare imm32 sign-
    //                                                                        extended to 64-bits with
    //                                                                        RAX.
    defn = new InsnDefn("cmp",    x86_cmp,     0x02, 0x3d, od_rexw|od_id, od_RAX, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  80 /7 ib            CMP r/m8, imm8      Valid          Valid          Compare imm8 with r/m8.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x80, od_e7|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  REX + 80 /7 ib      CMP r/m8*, imm8 Valid              N.E.           Compare imm8 with r/m8.
    defn = new InsnDefn("cmp",    x86_cmp,     0x02, 0x80, od_rex|od_e7|od_ib, od_r_m8, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  81 /7 iw            CMP r/m16,          Valid          Valid          Compare imm16 with
    //                      imm16                                             r/m16.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x81, od_e7|od_iw, od_r_m16, od_imm16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  81 /7 id            CMP r/m32,          Valid          Valid          Compare imm32 with
    //                      imm32                                             r/m32.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x81, od_e7|od_id, od_r_m32, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  REX.W + 81 /7 id    CMP r/m64,          Valid          N.E.           Compare imm32 sign-
    //                      imm32                                             extended to 64-bits with
    //                                                                        r/m64.
    defn = new InsnDefn("cmp",    x86_cmp,     0x02, 0x81, od_rexw|od_e7|od_id, od_r_m64, od_imm32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  83 /7 ib            CMP r/m16, imm8 Valid              Valid          Compare imm8 with r/m16.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x83, od_e7|od_ib, od_r_m16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  83 /7 ib            CMP r/m32, imm8 Valid              Valid          Compare imm8 with r/m32.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x83, od_e7|od_ib, od_r_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  REX.W + 83 /7 ib    CMP r/m64, imm8 Valid              N.E.           Compare imm8 with r/m64.
    defn = new InsnDefn("cmp",    x86_cmp,     0x02, 0x83, od_rexw|od_e7|od_ib, od_r_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  38 /r               CMP r/m8, r8        Valid          Valid          Compare r8 with r/m8.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x38, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  REX + 38 /r         CMP r/m8*, r8*      Valid          N.E.           Compare r8 with r/m8.
    defn = new InsnDefn("cmp",    x86_cmp,     0x02, 0x38, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  39 /r               CMP r/m16, r16      Valid          Valid          Compare r16 with r/m16.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x39, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  39 /r               CMP r/m32, r32      Valid          Valid          Compare r32 with r/m32.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x39, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  REX.W + 39 /r       CMP r/m64,r64       Valid          N.E.           Compare r64 with r/m64.
    defn = new InsnDefn("cmp",    x86_cmp,     0x02, 0x39, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  3A /r               CMP r8, r/m8        Valid          Valid          Compare r/m8 with r8.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x3a, od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  REX + 3A /r         CMP r8*, r/m8*      Valid          N.E.           Compare r/m8 with r8.
    defn = new InsnDefn("cmp",    x86_cmp,     0x02, 0x3a, od_rex|od_modrm, od_r8, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  3B /r               CMP r16, r/m16      Valid          Valid          Compare r/m16 with r16.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x3b, od_modrm, od_r16, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  3B /r               CMP r32, r/m32      Valid          Valid          Compare r/m32 with r32.
    defn = new InsnDefn("cmp",    x86_cmp,     0x03, 0x3b, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-141");
    define(defn);
    //  REX.W + 3B /r       CMP r64, r/m64      Valid          N.E.           Compare r/m64 with r64.
    defn = new InsnDefn("cmp",    x86_cmp,     0x02, 0x3b, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-144");
    define(defn);

    //--- page 3-144 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F C2 /r ib   CMPPD xmm1,               Valid       Valid           Compare packed double-
    //                  xmm2/m128, imm8                                       precision floating-point
    //                                                                        values in xmm2/m128 and
    //                                                                        xmm1 using imm8 as
    //                                                                        comparison predicate.
    defn = new InsnDefn("cmppd",  x86_cmppd,   0x03, 0x660fc2, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-149");
    define(defn);

    //--- page 3-149 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F C2 /r ib    CMPPS xmm1,               Valid         Valid          Compare packed single-
    //                 xmm2/m128, imm8                                        precision floating-point
    //                                                                        values in xmm2/mem and
    //                                                                        xmm1 using imm8 as
    //                                                                        comparison predicate.
    defn = new InsnDefn("cmpps",  x86_cmpps,   0x03, 0x0fc2, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-154");
    define(defn);

    //--- page 3-154 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // A6              CMPS m8, m8   Valid        Valid          For legacy mode, compare byte at
    //                                                           address DS:(E)SI with byte at
    //                                                           address ES:(E)DI; For 64-bit mode
    //                                                           compare byte at address (R|E)SI to
    //                                                           byte at address (R|E)DI. The status
    //                                                           flags are set accordingly.
    // See CMPSB, CMPSW, CMPSD, or CMPSQ instead.
    // defn = new InsnDefn("cmps",   x86_cmps,    0x03, 0xa6, od_none, od_m8, od_m8);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-154");
    // define(defn);
    // A7              CMPS m16, m16 Valid        Valid          For legacy mode, compare word at
    //                                                           address DS:(E)SI with word at
    //                                                           address ES:(E)DI; For 64-bit mode
    //                                                           compare word at address (R|E)SI
    //                                                           with word at address (R|E)DI. The
    //                                                           status flags are set accordingly.
    // See CMPSB, CMPSW, CMPSD, or CMPSQ instead.
    // defn = new InsnDefn("cmps",   x86_cmps,    0x03, 0xa7, od_none, od_m16, od_m16);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-154");
    // define(defn);
    // A7              CMPS m32, m32 Valid        Valid          For legacy mode, compare dword
    //                                                           at address DS:(E)SI at dword at
    //                                                           address ES:(E)DI; For 64-bit mode
    //                                                           compare dword at address (R|E)SI
    //                                                           at dword at address (R|E)DI. The
    //                                                           status flags are set accordingly.
    // See CMPSB, CMPSW, CMPSD, or CMPSQ instead.
    // defn = new InsnDefn("cmps",   x86_cmps,    0x03, 0xa7, od_none, od_m32, od_m32);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-154");
    // define(defn);
    // REX.W + A7      CMPS m64, m64 Valid        N.E.           Compares quadword at address
    //                                                           (R|E)SI with quadword at address
    //                                                           (R|E)DI and sets the status flags
    //                                                           accordingly.
    // See CMPSB, CMPSW, CMPSD, or CMPSQ instead.
    // defn = new InsnDefn("cmps",   x86_cmps,    0x02, 0xa7, od_rexw, od_m64, od_m64);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-154");
    // define(defn);
    // A6              CMPSB         Valid        Valid          For legacy mode, compare byte at
    //                                                           address DS:(E)SI with byte at
    //                                                           address ES:(E)DI; For 64-bit mode
    //                                                           compare byte at address (R|E)SI
    //                                                           with byte at address (R|E)DI. The
    //                                                           status flags are set accordingly.
    defn = new InsnDefn("cmpsb",  x86_cmpsb,   0x03, 0xa6, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-155");
    define(defn);
    //  A7            CMPSW           Valid       Valid       For legacy mode, compare word at
    //                                                        address DS:(E)SI with word at
    //                                                        address ES:(E)DI; For 64-bit mode
    //                                                        compare word at address (R|E)SI
    //                                                        with word at address (R|E)DI. The
    //                                                        status flags are set accordingly.
    defn = new InsnDefn("cmpsw",  x86_cmpsw,   0x03, 0xa7, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-155");
    define(defn);
    //  A7            CMPSD           Valid       Valid       For legacy mode, compare dword
    //                                                        at address DS:(E)SI with dword at
    //                                                        address ES:(E)DI; For 64-bit mode
    //                                                        compare dword at address (R|E)SI
    //                                                        with dword at address (R|E)DI. The
    //                                                        status flags are set accordingly.
    defn = new InsnDefn("cmpsd",  x86_cmpsd,   0x03, 0xa7, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-155");
    define(defn);
    //  REX.W + A7    CMPSQ           Valid       N.E.        Compares quadword at address
    //                                                        (R|E)SI with quadword at address
    //                                                        (R|E)DI and sets the status flags
    //                                                        accordingly.
    defn = new InsnDefn("cmpsq",  x86_cmpsq,   0x02, 0xa7, od_rexw);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-160");
    define(defn);

    //--- page 3-160 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F2 0F C2 /r ib   CMPSD xmm1,           Valid        Valid             Compare low double-
    //                  xmm2/m64, imm8                                       precision floating-point
    //                                                                       value in xmm2/m64 and
    //                                                                       xmm1 using imm8 as
    //                                                                       comparison predicate.
    defn = new InsnDefn("cmpsd",  x86_cmpsd,   0x03, 0xf20fc2, od_modrm|od_ib, od_xmm, od_xmm_m64, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-164");
    define(defn);

    //--- page 3-164 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F3 0F C2 /r ib   CMPSS xmm1,     Valid           Valid             Compare low single-precision
    //                  xmm2/m32,                                         floating-point value in
    //                  imm8                                              xmm2/m32 and xmm1 using
    //                                                                    imm8 as comparison
    //                                                                    predicate.
    defn = new InsnDefn("cmpss",  x86_cmpss,   0x03, 0xf30fc2, od_modrm|od_ib, od_xmm, od_xmm_m32, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-168");
    define(defn);

    //--- page 3-168 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F B0/r             CMPXCHG r/m8, r8 Valid             Valid*           Compare AL with r/m8. If
    //                                                                         equal, ZF is set and r8 is
    //                                                                         loaded into r/m8. Else, clear
    //                                                                         ZF and load r/m8 into AL.
    defn = new InsnDefn("cmpxchg", x86_cmpxchg, 0x03, 0x0fb0, od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-168");
    define(defn);
    // REX + 0F B0/r       CMPXCHG              Valid         N.E.             Compare AL with r/m8. If
    //                     r/m8**,r8                                           equal, ZF is set and r8 is
    //                                                                         loaded into r/m8. Else, clear
    //                                                                         ZF and load r/m8 into AL.
    defn = new InsnDefn("cmpxchg", x86_cmpxchg, 0x02, 0x0fb0, od_rex|od_modrm, od_r_m8, od_r8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-168");
    define(defn);
    // 0F B1/r             CMPXCHG r/m16,       Valid         Valid*           Compare AX with r/m16. If
    //                     r16                                                 equal, ZF is set and r16 is
    //                                                                         loaded into r/m16. Else,
    //                                                                         clear ZF and load r/m16
    //                                                                         into AX.
    defn = new InsnDefn("cmpxchg", x86_cmpxchg, 0x03, 0x0fb1, od_modrm, od_r_m16, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-168");
    define(defn);
    // 0F B1/r             CMPXCHG r/m32,       Valid         Valid*           Compare EAX with r/m32.
    //                     r32                                                 If equal, ZF is set and r32 is
    //                                                                         loaded into r/m32. Else,
    //                                                                         clear ZF and load r/m32
    //                                                                         into EAX.
    defn = new InsnDefn("cmpxchg", x86_cmpxchg, 0x03, 0x0fb1, od_modrm, od_r_m32, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-168");
    define(defn);
    // REX.W + 0F B1/r     CMPXCHG r/m64,       Valid         N.E.             Compare RAX with r/m64.
    //                     r64                                                 If equal, ZF is set and r64 is
    //                                                                         loaded into r/m64. Else,
    //                                                                         clear ZF and load r/m64
    //                                                                         into RAX.
    defn = new InsnDefn("cmpxchg", x86_cmpxchg, 0x02, 0x0fb1, od_rexw|od_modrm, od_r_m64, od_r64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-171");
    define(defn);

    //--- page 3-171 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F C7 /1            CMPXCHG8B m64         Valid         Valid*         Compare EDX:EAX with
    //                                                                         m64. If equal, set ZF and
    //                                                                         load ECX:EBX into m64.
    //                                                                         Else, clear ZF and load m64
    //                                                                         into EDX:EAX.
    defn = new InsnDefn("cmpxchg8b", x86_cmpxchg8b, 0x03, 0x0fc7, od_e1, od_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-171");
    define(defn);
    //  REX.W + 0F C7 /1    CMPXCHG16B            Valid         N.E.           Compare RDX:RAX with
    //  m128                m128                                               m128. If equal, set ZF and
    //                                                                         load RCX:RBX into m128.
    //                                                                         Else, clear ZF and load
    //                                                                         m128 into RDX:RAX.
    defn = new InsnDefn("cmpxchg16b", x86_cmpxchg16b, 0x02, 0x0fc7, od_rexw|od_e1, od_m128, od_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-174");
    define(defn);

    //--- page 3-174 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 2F /r COMISD xmm1,              Valid             Valid            Compare low double-
    //             xmm2/m64                                                     precision floating-point
    //                                                                          values in xmm1 and
    //                                                                          xmm2/mem64 and set the
    //                                                                          EFLAGS flags accordingly.
    defn = new InsnDefn("comisd", x86_comisd,  0x03, 0x660f2f, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-177");
    define(defn);

    //--- page 3-177 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 2F /r    COMISS xmm1,              Valid        Valid            Compare low single-precision
    //              xmm2/m32                                                floating-point values in xmm1 and
    //                                                                      xmm2/mem32 and set the EFLAGS
    //                                                                      flags accordingly.
    defn = new InsnDefn("comiss", x86_comiss,  0x03, 0x0f2f, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-180");
    define(defn);

    //--- page 3-180 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F A2           CPUID           Valid          Valid           Returns processor identification
    //                                                                and feature information to the
    //                                                                EAX, EBX, ECX, and EDX registers,
    //                                                                as determined by input entered in
    //                                                                EAX (in some cases, ECX as well).
    defn = new InsnDefn("cpuid",  x86_cpuid,   0x03, 0x0fa2, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-214");
    define(defn);

    //--- page 3-214 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //   F2 0F 38 F0 /r         CRC32 r32, r/m8       Valid    Valid        Accumulate CRC32 on
    //                                                                      r/m8.
    defn = new InsnDefn("crc32",  x86_crc32,   0x03, 0xf20f38f0, od_modrm, od_r32, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-214");
    define(defn);
    //   F2 REX 0F 38 F0 /r     CRC32 r32, r/m8*      Valid    N.E.         Accumulate CRC32 on
    //                                                                      r/m8.
    //                                                                      Accumulate CRC32 on
    defn = new InsnDefn("crc32",  x86_crc32,   0x02, 0xf20f38f0, od_rex|od_modrm, od_r32, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-214");
    define(defn);
    //   F2 0F 38 F1 /r         CRC32 r32, r/m16      Valid    Valid
    //                                                                      r/m16.
    //                                                                      Accumulate CRC32 on
    defn = new InsnDefn("crc32",  x86_crc32,   0x03, 0xf20f38f1, od_modrm, od_r32, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-214");
    define(defn);
    //   F2 0F 38 F1 /r         CRC32 r32, r/m32      Valid    Valid        r/m32.
    //                                                                      Accumulate CRC32 on
    defn = new InsnDefn("crc32",  x86_crc32,   0x03, 0xf20f38f1, od_modrm, od_r32, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-214");
    define(defn);
    //   F2 REX.W 0F 38 F0      CRC32 r64, r/m8       Valid    N.E.         r/m8.
    //   /r                                                                 Accumulate CRC32 on
    defn = new InsnDefn("crc32",  x86_crc32,   0x02, 0xf20f38f0, od_rexw|od_modrm, od_r64, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-214");
    define(defn);
    //   F2 REX.W 0F 38 F1      CRC32 r64, r/m64      Valid    N.E.         r/m64.
    //   /r
    defn = new InsnDefn("crc32",  x86_crc32,   0x02, 0xf20f38f1, od_rexw|od_modrm, od_r64, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-218");
    define(defn);

    //--- page 3-218 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F3 0F E6        CVTDQ2PD xmm1,           Valid       Valid             Convert two packed signed
    //                 xmm2/m64                                               doubleword integers from
    //                                                                        xmm2/m128 to two packed
    //                                                                        double-precision floating-point
    //                                                                        values in xmm1.
    defn = new InsnDefn("cvtdq2pd", x86_cvtdq2pd, 0x03, 0xf30fe6, od_none, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-220");
    define(defn);

    //--- page 3-220 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 5B /r        CVTDQ2PS xmm1,             Valid        Valid            Convert four packed signed
    //                 xmm2/m128                                                doubleword integers from
    //                                                                          xmm2/m128 to four packed
    //                                                                          single-precision floating-
    //                                                                          point values in xmm1.
    defn = new InsnDefn("cvtdq2ps", x86_cvtdq2ps, 0x03, 0x0f5b, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-223");
    define(defn);

    //--- page 3-223 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F2 0F E6     CVTPD2DQ xmm1,           Valid       Valid            Convert two packed double-
    //               xmm2/m128                                             precision floating-point values
    //                                                                     from xmm2/m128 to two
    //                                                                     packed signed doubleword
    //                                                                     integers in xmm1.
    defn = new InsnDefn("cvtpd2dq", x86_cvtpd2dq, 0x03, 0xf20fe6, od_none, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-226");
    define(defn);

    //--- page 3-226 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 2D /r     CVTPD2PI mm,           Valid            Valid            Convert two packed double-
    //                 xmm/m128                                                 precision floating-point
    //                                                                          values from xmm/m128 to
    //                                                                          two packed signed
    //                                                                          doubleword integers in mm.
    defn = new InsnDefn("cvtpd2pi", x86_cvtpd2pi, 0x03, 0x660f2d, od_modrm, od_mm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-229");
    define(defn);

    //--- page 3-229 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 5A /r     CVTPD2PS xmm1,         Valid      Valid           Convert two packed double-
    //                  xmm2/m128                                         precision floating-point values in
    //                                                                    xmm2/m128 to two packed single-
    //                                                                    precision floating-point values in
    //                                                                    xmm1.
    defn = new InsnDefn("cvtpd2ps", x86_cvtpd2ps, 0x03, 0x660f5a, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-232");
    define(defn);

    //--- page 3-232 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 2A /r     CVTPI2PD            Valid       Valid           Convert two packed signed
    //                 xmm,                                            doubleword integers from
    //                 mm/m64*                                         mm/mem64 to two packed double-
    //                                                                 precision floating-point values in
    //                                                                 xmm.
    defn = new InsnDefn("cvtpi2pd", x86_cvtpi2pd, 0x03, 0x660f2a, od_modrm, od_xmm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-235");
    define(defn);

    //--- page 3-235 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 2A /r      CVTPI2PS xmm,         Valid     Valid           Convert two signed doubleword
    //                mm/m64                                          integers from mm/m64 to two single-
    //                                                                precision floating-point values in xmm.
    defn = new InsnDefn("cvtpi2ps", x86_cvtpi2ps, 0x03, 0x0f2a, od_modrm, od_xmm, od_mm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-238");
    define(defn);

    //--- page 3-238 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 5B /r      CVTPS2DQ xmm1,         Valid       Valid          Convert four packed single-precision
    //                  xmm2/m128                                         floating-point values from
    //                                                                    xmm2/m128 to four packed signed
    //                                                                    doubleword integers in xmm1.
    defn = new InsnDefn("cvtps2dq", x86_cvtps2dq, 0x03, 0x660f5b, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-241");
    define(defn);

    //--- page 3-241 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 5A /r      CVTPS2PD xmm1,         Valid      Valid           Convert two packed single-precision
    //                xmm2/m64                                          floating-point values in xmm2/m64
    //                                                                  to two packed double-precision
    //                                                                  floating-point values in xmm1.
    defn = new InsnDefn("cvtps2pd", x86_cvtps2pd, 0x03, 0x0f5a, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-244");
    define(defn);

    //--- page 3-244 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 2D /r    CVTPS2PI mm,      Valid      Valid          Convert two packed single-precision
    //             xmm/m64                                     floating-point values from xmm/m64 to
    //                                                         two packed signed doubleword integers in
    //                                                         mm.
    defn = new InsnDefn("cvtps2pi", x86_cvtps2pi, 0x03, 0x0f2d, od_modrm, od_mm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-247");
    define(defn);

    //--- page 3-247 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F2 0F 2D /r               CVTSD2SI r32,     Valid       Valid         Convert one double-precision
    //                            xmm/m64                                     floating-point value from
    //                                                                        xmm/m64 to one signed
    //                                                                        doubleword integer r32.
    defn = new InsnDefn("cvtsd2si", x86_cvtsd2si, 0x03, 0xf20f2d, od_modrm, od_r32, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-247");
    define(defn);
    //   F2 REX.W 0F 2D /r        CVTSD2SI r64,     Valid       N.E.          Convert one double-precision
    //                            xmm/m64                                     floating-point value from
    //                                                                        xmm/m64 to one signed
    //                                                                        quadword integer sign-
    //                                                                        extended into r64.
    defn = new InsnDefn("cvtsd2si", x86_cvtsd2si, 0x02, 0xf20f2d, od_rexw|od_modrm, od_r64, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-250");
    define(defn);

    //--- page 3-250 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F2 0F 5A /r     CVTSD2SS xmm1,        Valid     Valid          Convert one double-precision floating-
    //                 xmm2/m64                                       point value in xmm2/m64 to one
    //                                                                single-precision floating-point value in
    //                                                                xmm1.
    defn = new InsnDefn("cvtsd2ss", x86_cvtsd2ss, 0x03, 0xf20f5a, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-253");
    define(defn);

    //--- page 3-253 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F2 0F 2A /r             CVTSI2SD xmm,        Valid    Valid          Convert one signed doubleword
    //                          r/m32                                        integer from r/m32 to one
    //                                                                       double-precision floating-point
    //                                                                       value in xmm.
    defn = new InsnDefn("cvtsi2sd", x86_cvtsi2sd, 0x03, 0xf20f2a, od_modrm, od_xmm, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-253");
    define(defn);
    //  F2 REX.W 0F 2A /r       CVTSI2SD xmm,        Valid    N.E.           Convert one signed quadword
    //                          r/m64                                        integer from r/m64 to one
    //                                                                       double-precision floating-point
    //                                                                       value in xmm.
    defn = new InsnDefn("cvtsi2sd", x86_cvtsi2sd, 0x02, 0xf20f2a, od_rexw|od_modrm, od_xmm, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-256");
    define(defn);

    //--- page 3-256 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F3 0F 2A /r           CVTSI2SS        Valid      Valid          Convert one signed doubleword
    //                       xmm, r/m32                                integer from r/m32 to one single-
    //                                                                 precision floating-point value in
    //                                                                 xmm.
    defn = new InsnDefn("cvtsi2ss", x86_cvtsi2ss, 0x03, 0xf30f2a, od_modrm, od_xmm, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-256");
    define(defn);
    // F3 REX.W 0F 2A /r     CVTSI2SS        Valid      N.E.           Convert one signed quadword
    //                       xmm, r/m64                                integer from r/m64 to one single-
    //                                                                 precision floating-point value in
    //                                                                 xmm.
    defn = new InsnDefn("cvtsi2ss", x86_cvtsi2ss, 0x02, 0xf30f2a, od_rexw|od_modrm, od_xmm, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-259");
    define(defn);

    //--- page 3-259 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F3 0F 5A /r     CVTSS2SD xmm1,          Valid     Valid          Convert one single-precision floating-
    //                  xmm2/m32                                         point value in xmm2/m32 to one
    //                                                                   double-precision floating-point value
    //                                                                   in xmm1.
    defn = new InsnDefn("cvtss2sd", x86_cvtss2sd, 0x03, 0xf30f5a, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-262");
    define(defn);

    //--- page 3-262 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F3 0F 2D /r           CVTSS2SI r32,      Valid      Valid         Convert one single-precision
    //                       xmm/m32                                     floating-point value from
    //                                                                   xmm/m32 to one signed
    //                                                                   doubleword integer in r32.
    defn = new InsnDefn("cvtss2si", x86_cvtss2si, 0x03, 0xf30f2d, od_modrm, od_r32, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-262");
    define(defn);
    // F3 REX.W 0F 2D /r     CVTSS2SI r64,      Valid      N.E.          Convert one single-precision
    //                       xmm/m32                                     floating-point value from
    //                                                                   xmm/m32 to one signed
    //                                                                   quadword integer in r64.
    defn = new InsnDefn("cvtss2si", x86_cvtss2si, 0x02, 0xf30f2d, od_rexw|od_modrm, od_r64, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-265");
    define(defn);

    //--- page 3-265 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F E6      CVTTPD2DQ xmm1,         Valid      Valid           Convert two packed double-
    //                xmm2/m128                                          precision floating-point values
    //                                                                   from xmm2/m128 to two packed
    //                                                                   signed doubleword integers in
    //                                                                   xmm1 using truncation.
    defn = new InsnDefn("cvttpd2dq", x86_cvttpd2dq, 0x03, 0x660fe6, od_none, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-268");
    define(defn);

    //--- page 3-268 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 2C /r     CVTTPD2PI mm,     Valid      Valid          Convert two packer double-precision
    //                 xmm/m128                                    floating-point values from xmm/m128
    //                                                             to two packed signed doubleword
    //                                                             integers in mm using truncation.
    defn = new InsnDefn("cvttpd2pi", x86_cvttpd2pi, 0x03, 0x660f2c, od_modrm, od_mm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-271");
    define(defn);

    //--- page 3-271 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F3 0F 5B /r   CVTTPS2DQ xmm1,          Valid      Valid          Convert four single-precision
    //                xmm2/m128                                          floating-point values from
    //                                                                   xmm2/m128 to four signed
    //                                                                   doubleword integers in xmm1 using
    //                                                                   truncation.
    defn = new InsnDefn("cvttps2dq", x86_cvttps2dq, 0x03, 0xf30f5b, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-274");
    define(defn);

    //--- page 3-274 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 0F 2C /r    CVTTPS2PI mm,        Valid      Valid         Convert two single-precision floating-
    //             xmm/m64                                       point values from xmm/m64 to two
    //                                                           signed doubleword signed integers in mm
    //                                                           using truncation.
    defn = new InsnDefn("cvttps2pi", x86_cvttps2pi, 0x03, 0x0f2c, od_modrm, od_mm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-277");
    define(defn);

    //--- page 3-277 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  F2 0F 2C /r              CVTTSD2SI r32, Valid          Valid          Convert one double-precision
    //                           xmm/m64                                      floating-point value from
    //                                                                        xmm/m64 to one signed
    //                                                                        doubleword integer in r32 using
    //                                                                        truncation.
    defn = new InsnDefn("cvttsd2si", x86_cvttsd2si, 0x03, 0xf20f2c, od_modrm, od_r32, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-277");
    define(defn);
    //  F2 REX.W 0F 2C /r        CVTTSD2SI r64, Valid          N.E.           Convert one double precision
    //                           xmm/m64                                      floating-point value from
    //                                                                        xmm/m64 to one
    //                                                                        signedquadword integer in r64
    //                                                                        using truncation.
    defn = new InsnDefn("cvttsd2si", x86_cvttsd2si, 0x02, 0xf20f2c, od_rexw|od_modrm, od_r64, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-280");
    define(defn);

    //--- page 3-280 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F3 0F 2C /r           CVTTSS2SI r32,       Valid      Valid          Convert one single-precision
    //                       xmm/m32                                        floating-point value from
    //                                                                      xmm/m32 to one signed
    //                                                                      doubleword integer in r32
    //                                                                      using truncation.
    defn = new InsnDefn("cvttss2si", x86_cvttss2si, 0x03, 0xf30f2c, od_modrm, od_r32, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-280");
    define(defn);
    // F3 REX.W 0F 2C /r     CVTTSS2SI r64,       Valid      N.E.           Convert one single-precision
    //                       xmm/m32                                        floating-point value from
    //                                                                      xmm/m32 to one signed
    //                                                                      quadword integer in r64 using
    //                                                                      truncation.
    defn = new InsnDefn("cvttss2si", x86_cvttss2si, 0x02, 0xf30f2c, od_rexw|od_modrm, od_r64, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-283");
    define(defn);

    //--- page 3-283 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  99               CWD               Valid       Valid           DX:AX  sign-extend of AX.
    defn = new InsnDefn("cwd",    x86_cwd,     0x03, 0x99, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-283");
    define(defn);
    //  99               CDQ               Valid       Valid           EDX:EAX  sign-extend of EAX.
    defn = new InsnDefn("cdq",    x86_cdq,     0x03, 0x99, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-283");
    define(defn);
    //  REX.W + 99       CQO               Valid       N.E.            RDX:RAX sign-extend of RAX.
    defn = new InsnDefn("cqo",    x86_cqo,     0x02, 0x99, od_rexw);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-285");
    define(defn);

    //--- page 3-285 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  27              DAA                   Invalid   Valid         Decimal adjust AL after addition.
    defn = new InsnDefn("daa",    x86_daa,     0x01, 0x27, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-287");
    define(defn);

    //--- page 3-287 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  2F               DAS               Invalid   Valid            Decimal adjust AL after
    //                                                                subtraction.
    defn = new InsnDefn("das",    x86_das,     0x01, 0x2f, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-289");
    define(defn);

    //--- page 3-289 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  FE /1               DEC r/m8           Valid       Valid           Decrement r/m8 by 1.
    defn = new InsnDefn("dec",    x86_dec,     0x03, 0xfe, od_e1, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-289");
    define(defn);
    //  REX + FE /1         DEC r/m8*          Valid       N.E.            Decrement r/m8 by 1.
    defn = new InsnDefn("dec",    x86_dec,     0x02, 0xfe, od_rex|od_e1, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-289");
    define(defn);
    //  FF /1               DEC r/m16          Valid       Valid           Decrement r/m16 by 1.
    defn = new InsnDefn("dec",    x86_dec,     0x03, 0xff, od_e1, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-289");
    define(defn);
    //  FF /1               DEC r/m32          Valid       Valid           Decrement r/m32 by 1.
    defn = new InsnDefn("dec",    x86_dec,     0x03, 0xff, od_e1, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-289");
    define(defn);
    //  REX.W + FF /1       DEC r/m64          Valid       N.E.            Decrement r/m64 by 1.
    defn = new InsnDefn("dec",    x86_dec,     0x02, 0xff, od_rexw|od_e1, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-289");
    define(defn);
    //  48+rw               DEC r16            N.E.        Valid           Decrement r16 by 1.
    defn = new InsnDefn("dec",    x86_dec,     0x01, 0x48, od_rw, od_r16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-289");
    define(defn);
    //  48+rd               DEC r32            N.E.        Valid           Decrement r32 by 1.
    defn = new InsnDefn("dec",    x86_dec,     0x01, 0x48, od_rd, od_r32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-292");
    define(defn);

    //--- page 3-292 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F6 /6             DIV r/m8       Valid      Valid           Unsigned divide AX by r/m8, with
    //                                                             result stored in AL  Quotient, AH
    //                                                             Remainder.
    defn = new InsnDefn("div",    x86_div,     0x03, 0xf6, od_e6, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-292");
    define(defn);
    // REX + F6 /6       DIV r/m8*      Valid      N.E.            Unsigned divide AX by r/m8, with
    //                                                             result stored in AL  Quotient, AH
    //                                                             Remainder.
    defn = new InsnDefn("div",    x86_div,     0x02, 0xf6, od_rex|od_e6, od_r_m8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-292");
    define(defn);
    // F7 /6             DIV r/m16      Valid      Valid           Unsigned divide DX:AX by r/m16, with
    //                                                             result stored in AX  Quotient, DX
    //                                                             Remainder.
    defn = new InsnDefn("div",    x86_div,     0x03, 0xf7, od_e6, od_r_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-292");
    define(defn);
    // F7 /6             DIV r/m32      Valid      Valid           Unsigned divide EDX:EAX by r/m32,
    //                                                             with result stored in EAX  Quotient,
    //                                                             EDX  Remainder.
    defn = new InsnDefn("div",    x86_div,     0x03, 0xf7, od_e6, od_r_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-292");
    define(defn);
    // REX.W + F7 /6     DIV r/m64      Valid      N.E.            Unsigned divide RDX:RAX by r/m64,
    //                                                             with result stored in RAX  Quotient,
    //                                                             RDX  Remainder.
    defn = new InsnDefn("div",    x86_div,     0x02, 0xf7, od_rexw|od_e6, od_r_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-296");
    define(defn);

    //--- page 3-296 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 5E /r     DIVPD xmm1,      Valid      Valid        Divide packed double-precision floating-
    //                 xmm2/m128                                point values in xmm1 by packed double-
    //                                                          precision floating-point values
    //                                                          xmm2/m128.
    defn = new InsnDefn("divpd",  x86_divpd,   0x03, 0x660f5e, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-299");
    define(defn);

    //--- page 3-299 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 5E /r     DIVPS xmm1,         Valid       Valid          Divide packed single-precision floating-
    //               xmm2/m128                                      point values in xmm1 by packed single-
    //                                                              precision floating-point values
    //                                                              xmm2/m128.
    defn = new InsnDefn("divps",  x86_divps,   0x03, 0x0f5e, od_modrm, od_xmm, od_xmm_m128);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-302");
    define(defn);

    //--- page 3-302 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // F2 0F 5E /r     DIVSD xmm1,    Valid       Valid          Divide low double-precision floating-
    //                 xmm2/m64                                  point value n xmm1 by low double-
    //                                                           precision floating-point value in
    //                                                           xmm2/mem64.
    defn = new InsnDefn("divsd",  x86_divsd,   0x03, 0xf20f5e, od_modrm, od_xmm, od_xmm_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-305");
    define(defn);

    //--- page 3-305 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //   F3 0F 5E /r      DIVSS xmm1,         Valid       Valid     Divide low single-precision floating-
    //                    xmm2/m32                                  point value in xmm1 by low single-
    //                                                              precision floating-point value in
    //                                                              xmm2/m32.
    defn = new InsnDefn("divss",  x86_divss,   0x03, 0xf30f5e, od_modrm, od_xmm, od_xmm_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-308");
    define(defn);

    //--- page 3-308 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 66 0F 3A    DPPD xmm1,        Valid    Valid         Selectively multiply packed DP floating-
    // 41 /r ib    xmm2/m128,                               point values from xmm1 with packed DP
    //             imm8                                     floating-point values from xmm2, add
    //                                                      and selectively store the packed DP
    //                                                      floating-point values to xmm1.
    defn = new InsnDefn("dppd",   x86_dppd,    0x03, 0x660f3a41, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-311");
    define(defn);

    //--- page 3-311 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 3A DPPS xmm1,                Valid     Valid         Selectively multiply packed SP floating-
    //  40 /r ib xmm2/m128,                                        point values from xmm1 with packed SP
    //           imm8                                              floating-point values from xmm2, add
    //                                                             and selectively store the packed SP
    //                                                             floating-point values or zero values to
    //                                                             xmm1.
    defn = new InsnDefn("dpps",   x86_dpps,    0x03, 0x660f3a40, od_modrm|od_ib, od_xmm, od_xmm_m128, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-315");
    define(defn);

    //--- page 3-315 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  0F 77           EMMS             Valid    Valid       Set the x87 FPU tag word to empty.
    defn = new InsnDefn("emms",   x86_emms,    0x03, 0x0f77, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-317");
    define(defn);

    //--- page 3-317 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  C8 iw 00      ENTER imm16, 0         Valid       Valid      Create a stack frame for a
    //                                                              procedure.
    defn = new InsnDefn("enter",  x86_enter,   0x03, 0xc800, od_iw, od_imm16, od_0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-317");
    define(defn);
    //  C8 iw 01      ENTER imm16,1          Valid       Valid      Create a nested stack frame for a
    //                                                              procedure.
    defn = new InsnDefn("enter",  x86_enter,   0x03, 0xc801, od_iw, od_imm16, od_1);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-317");
    define(defn);
    //  C8 iw ib      ENTER imm16, imm8 Valid            Valid      Create a nested stack frame for a
    //                                                              procedure.
    defn = new InsnDefn("enter",  x86_enter,   0x03, 0xc8, od_iw|od_ib, od_imm16, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-321");
    define(defn);

    //--- page 3-321 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  66 0F 3A 17      EXTRACTPS reg/m32,         Valid     Valid       Extract a single-precision
    //  /r ib            xmm2, imm8                                       floating-point value from xmm2
    //                                                                    at the source offset specified by
    //                                                                    imm8 and store the result to reg
    //                                                                    or m32. The upper 32 bits of r64
    //                                                                    is zeroed if reg is r64.
    defn = new InsnDefn("extractps", x86_extractps, 0x03, 0x660f3a17, od_modrm|od_ib, od_r_m32, od_xmm, od_imm8);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-324");
    define(defn);

    //--- page 3-324 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 F0              F2XM1              Valid       Valid         Replace ST(0) with (2ST(0)  1).
    defn = new InsnDefn("f2xm1",  x86_f2xm1,   0x03, 0xd9f0, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-326");
    define(defn);

    //--- page 3-326 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 E1              FABS                  Valid    Valid      Replace ST with its absolute value.
    defn = new InsnDefn("fabs",   x86_fabs,    0x03, 0xd9e1, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-328");
    define(defn);

    //--- page 3-328 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D8 /0           FADD m32fp           Valid    Valid      Add m32fp to ST(0) and store result
    //                                                          in ST(0).
    defn = new InsnDefn("fadd",   x86_fadd,    0x03, 0xd8, od_e0, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-328");
    define(defn);
    // DC /0           FADD m64fp           Valid    Valid      Add m64fp to ST(0) and store result
    //                                                          in ST(0).
    defn = new InsnDefn("fadd",   x86_fadd,    0x03, 0xdc, od_e0, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-328");
    define(defn);
    // D8 C0+i         FADD ST(0), ST(i)    Valid    Valid      Add ST(0) to ST(i) and store result in
    //                                                          ST(0).
    defn = new InsnDefn("fadd",   x86_fadd,    0x03, 0xd8c0, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-328");
    define(defn);
    // DC C0+i         FADD ST(i), ST(0)    Valid    Valid      Add ST(i) to ST(0) and store result in
    //                                                          ST(i).
    defn = new InsnDefn("fadd",   x86_fadd,    0x03, 0xdcc0, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-328");
    define(defn);
    // DE C0+i         FADDP ST(i), ST(0)   Valid    Valid      Add ST(0) to ST(i), store result in
    //                                                          ST(i), and pop the register stack.
    defn = new InsnDefn("faddp",  x86_faddp,   0x03, 0xdec0, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-328");
    define(defn);
    // DE C1           FADDP                Valid    Valid      Add ST(0) to ST(1), store result in
    //                                                          ST(1), and pop the register stack.
    defn = new InsnDefn("faddp",  x86_faddp,   0x03, 0xdec1, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-328");
    define(defn);
    // DA /0           FIADD m32int         Valid    Valid      Add m32int to ST(0) and store
    //                                                          result in ST(0).
    defn = new InsnDefn("fiadd",  x86_fiadd,   0x03, 0xda, od_e0, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-328");
    define(defn);
    // DE /0           FIADD m16int         Valid    Valid      Add m16int to ST(0) and store
    //                                                          result in ST(0).
    defn = new InsnDefn("fiadd",  x86_fiadd,   0x03, 0xde, od_e0, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-332");
    define(defn);

    //--- page 3-332 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // DF /4           FBLD m80 dec     Valid    Valid       Convert BCD value to floating-point and
    //                                                       push onto the FPU stack.
    defn = new InsnDefn("fbld",   x86_fbld,    0x03, 0xdf, od_e4, od_m80, od_dec);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-334");
    define(defn);

    //--- page 3-334 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // DF /6       FBSTP m80bcd         Valid     Valid          Store ST(0) in m80bcd and pop ST(0).
    defn = new InsnDefn("fbstp",  x86_fbstp,   0x03, 0xdf, od_e6, od_m80bcd);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-337");
    define(defn);

    //--- page 3-337 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D9 E0          FCHS               Valid    Valid      Complements sign of ST(0).
    defn = new InsnDefn("fchs",   x86_fchs,    0x03, 0xd9e0, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-339");
    define(defn);

    //--- page 3-339 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  9B DB E2       FCLEX           Valid     Valid          Clear floating-point exception flags after
    //                                                          checking for pending unmasked floating-
    //                                                          point exceptions.
    // See WAIT instead.
    // defn = new InsnDefn("fclex",  x86_fclex,   0x03, 0x9bdbe2, od_none);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-339");
    // define(defn);
    //  DB E2          FNCLEX*         Valid     Valid          Clear floating-point exception flags
    //                                                          without checking for pending unmasked
    //                                                          floating-point exceptions.
    defn = new InsnDefn("fnclex", x86_fnclex,  0x03, 0xdbe2, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-341");
    define(defn);

    //--- page 3-341 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  DA C0+i       FCMOVB ST(0), ST(i)        Valid    Valid       Move if below (CF=1).
    defn = new InsnDefn("fcmovb", x86_fcmovb,  0x03, 0xdac0, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-341");
    define(defn);
    //  DA C8+i       FCMOVE ST(0), ST(i)        Valid    Valid       Move if equal (ZF=1).
    defn = new InsnDefn("fcmove", x86_fcmove,  0x03, 0xdac8, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-341");
    define(defn);
    //  DA D0+i       FCMOVBE ST(0), ST(i)       Valid    Valid       Move if below or equal (CF=1 or
    //                                                                ZF=1).
    defn = new InsnDefn("fcmovbe", x86_fcmovbe, 0x03, 0xdad0, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-341");
    define(defn);
    //  DA D8+i       FCMOVU ST(0), ST(i)        Valid    Valid       Move if unordered (PF=1).
    defn = new InsnDefn("fcmovu", x86_fcmovu,  0x03, 0xdad8, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-341");
    define(defn);
    //  DB C0+i       FCMOVNB ST(0), ST(i)       Valid    Valid       Move if not below (CF=0).
    defn = new InsnDefn("fcmovnb", x86_fcmovnb, 0x03, 0xdbc0, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-341");
    define(defn);
    //  DB C8+i       FCMOVNE ST(0), ST(i)       Valid    Valid       Move if not equal (ZF=0).
    defn = new InsnDefn("fcmovne", x86_fcmovne, 0x03, 0xdbc8, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-341");
    define(defn);
    //  DB D0+i       FCMOVNBE ST(0), ST(i)      Valid    Valid       Move if not below or equal (CF=0
    //                                                                and ZF=0).
    defn = new InsnDefn("fcmovnbe", x86_fcmovnbe, 0x03, 0xdbd0, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-341");
    define(defn);
    //  DB D8+i       FCMOVNU ST(0), ST(i)       Valid    Valid       Move if not unordered (PF=0).
    defn = new InsnDefn("fcmovnu", x86_fcmovnu, 0x03, 0xdbd8, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-343");
    define(defn);

    //--- page 3-343 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  D8 /2           FCOM m32fp               Valid        Valid      Compare ST(0) with m32fp.
    defn = new InsnDefn("fcom",   x86_fcom,    0x03, 0xd8, od_e2, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-343");
    define(defn);
    //  DC /2           FCOM m64fp               Valid        Valid      Compare ST(0) with m64fp.
    defn = new InsnDefn("fcom",   x86_fcom,    0x03, 0xdc, od_e2, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-343");
    define(defn);
    //  D8 D0+i         FCOM ST(i)               Valid        Valid      Compare ST(0) with ST(i).
    defn = new InsnDefn("fcom",   x86_fcom,    0x03, 0xd8d0, od_i, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-343");
    define(defn);
    //  D8 D1           FCOM                     Valid        Valid      Compare ST(0) with ST(1).
    defn = new InsnDefn("fcom",   x86_fcom,    0x03, 0xd8d1, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-343");
    define(defn);
    //  D8 /3           FCOMP m32fp              Valid        Valid      Compare ST(0) with m32fp and
    //                                                                   pop register stack.
    defn = new InsnDefn("fcomp",  x86_fcomp,   0x03, 0xd8, od_e3, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-343");
    define(defn);
    //  DC /3           FCOMP m64fp              Valid        Valid      Compare ST(0) with m64fp and
    //                                                                   pop register stack.
    defn = new InsnDefn("fcomp",  x86_fcomp,   0x03, 0xdc, od_e3, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-343");
    define(defn);
    //  D8 D8+i         FCOMP ST(i)              Valid        Valid      Compare ST(0) with ST(i) and pop
    //                                                                   register stack.
    defn = new InsnDefn("fcomp",  x86_fcomp,   0x03, 0xd8d8, od_i, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-343");
    define(defn);
    //  D8 D9           FCOMP                    Valid        Valid      Compare ST(0) with ST(1) and pop
    //                                                                   register stack.
    defn = new InsnDefn("fcomp",  x86_fcomp,   0x03, 0xd8d9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-343");
    define(defn);
    //  DE D9           FCOMPP                   Valid        Valid      Compare ST(0) with ST(1) and pop
    //                                                                   register stack twice.
    defn = new InsnDefn("fcompp", x86_fcompp,  0x03, 0xded9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-347");
    define(defn);

    //--- page 3-347 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  DB F0+i      FCOMI ST, ST(i)     Valid      Valid        Compare ST(0) with ST(i) and set status
    //                                                           flags accordingly.
    defn = new InsnDefn("fcomi",  x86_fcomi,   0x03, 0xdbf0, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-347");
    define(defn);
    //  DF F0+i      FCOMIP ST, ST(i)    Valid      Valid        Compare ST(0) with ST(i), set status flags
    //                                                           accordingly, and pop register stack.
    defn = new InsnDefn("fcomip", x86_fcomip,  0x03, 0xdff0, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-347");
    define(defn);
    //  DB E8+i      FUCOMI ST, ST(i)    Valid      Valid        Compare ST(0) with ST(i), check for
    //                                                           ordered values, and set status flags
    //                                                           accordingly.
    defn = new InsnDefn("fucomi", x86_fucomi,  0x03, 0xdbe8, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-347");
    define(defn);
    //  DF E8+i      FUCOMIP ST, ST(i) Valid        Valid        Compare ST(0) with ST(i), check for
    //                                                           ordered values, set status flags
    //                                                           accordingly, and pop register stack.
    defn = new InsnDefn("fucomip", x86_fucomip, 0x03, 0xdfe8, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-350");
    define(defn);

    //--- page 3-350 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 FF              FCOS           Valid    Valid            Replace ST(0) with its cosine.
    defn = new InsnDefn("fcos",   x86_fcos,    0x03, 0xd9ff, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-352");
    define(defn);

    //--- page 3-352 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 F6           FDECSTP         Valid        Valid         Decrement TOP field in FPU status
    //                                                            word.
    defn = new InsnDefn("fdecstp", x86_fdecstp, 0x03, 0xd9f6, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-354");
    define(defn);

    //--- page 3-354 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D8 /6           FDIV m32fp           Valid    Valid      Divide ST(0) by m32fp and store
    //                                                          result in ST(0).
    defn = new InsnDefn("fdiv",   x86_fdiv,    0x03, 0xd8, od_e6, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-354");
    define(defn);
    // DC /6           FDIV m64fp           Valid    Valid      Divide ST(0) by m64fp and store
    //                                                          result in ST(0).
    defn = new InsnDefn("fdiv",   x86_fdiv,    0x03, 0xdc, od_e6, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-354");
    define(defn);
    // D8 F0+i         FDIV ST(0), ST(i)    Valid    Valid      Divide ST(0) by ST(i) and store result
    //                                                          in ST(0).
    defn = new InsnDefn("fdiv",   x86_fdiv,    0x03, 0xd8f0, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-354");
    define(defn);
    // DC F8+i         FDIV ST(i), ST(0)    Valid    Valid      Divide ST(i) by ST(0) and store result
    //                                                          in ST(i).
    defn = new InsnDefn("fdiv",   x86_fdiv,    0x03, 0xdcf8, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-354");
    define(defn);
    // DE F8+i         FDIVP ST(i), ST(0)   Valid    Valid      Divide ST(i) by ST(0), store result in
    //                                                          ST(i), and pop the register stack.
    defn = new InsnDefn("fdivp",  x86_fdivp,   0x03, 0xdef8, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-354");
    define(defn);
    // DE F9           FDIVP                Valid    Valid      Divide ST(1) by ST(0), store result in
    //                                                          ST(1), and pop the register stack.
    defn = new InsnDefn("fdivp",  x86_fdivp,   0x03, 0xdef9, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-354");
    define(defn);
    // DA /6           FIDIV m32int         Valid    Valid      Divide ST(0) by m32int and store
    //                                                          result in ST(0).
    defn = new InsnDefn("fidiv",  x86_fidiv,   0x03, 0xda, od_e6, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-354");
    define(defn);
    // DE /6           FIDIV m16int         Valid    Valid      Divide ST(0) by m64int and store
    //                                                          result in ST(0).
    defn = new InsnDefn("fidiv",  x86_fidiv,   0x03, 0xde, od_e6, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-358");
    define(defn);

    //--- page 3-358 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D8 /7           FDIVR m32fp          Valid    Valid      Divide m32fp by ST(0) and store result
    //                                                          in ST(0).
    defn = new InsnDefn("fdivr",  x86_fdivr,   0x03, 0xd8, od_e7, od_m32fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-358");
    define(defn);
    // DC /7           FDIVR m64fp          Valid    Valid      Divide m64fp by ST(0) and store result
    //                                                          in ST(0).
    defn = new InsnDefn("fdivr",  x86_fdivr,   0x03, 0xdc, od_e7, od_m64fp);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-358");
    define(defn);
    // D8 F8+i         FDIVR ST(0), ST(i)   Valid    Valid      Divide ST(i) by ST(0) and store result in
    //                                                          ST(0).
    defn = new InsnDefn("fdivr",  x86_fdivr,   0x03, 0xd8f8, od_i, od_st0, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-358");
    define(defn);
    // DC F0+i         FDIVR ST(i), ST(0)   Valid    Valid      Divide ST(0) by ST(i) and store result in
    //                                                          ST(i).
    defn = new InsnDefn("fdivr",  x86_fdivr,   0x03, 0xdcf0, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-358");
    define(defn);
    // DE F0+i         FDIVRP ST(i), ST(0) Valid     Valid      Divide ST(0) by ST(i), store result in
    //                                                          ST(i), and pop the register stack.
    defn = new InsnDefn("fdivrp", x86_fdivrp,  0x03, 0xdef0, od_i, od_sti, od_st0);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-358");
    define(defn);
    // DE F1           FDIVRP               Valid    Valid      Divide ST(0) by ST(1), store result in
    //                                                          ST(1), and pop the register stack.
    defn = new InsnDefn("fdivrp", x86_fdivrp,  0x03, 0xdef1, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-358");
    define(defn);
    // DA /7           FIDIVR m32int        Valid    Valid      Divide m32int by ST(0) and store result
    //                                                          in ST(0).
    defn = new InsnDefn("fidivr", x86_fidivr,  0x03, 0xda, od_e7, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-358");
    define(defn);
    // DE /7           FIDIVR m16int        Valid    Valid      Divide m16int by ST(0) and store result
    //                                                          in ST(0).
    defn = new InsnDefn("fidivr", x86_fidivr,  0x03, 0xde, od_e7, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-362");
    define(defn);

    //--- page 3-362 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // DD C0+i         FFREE ST(i)     Valid     Valid        Sets tag for ST(i) to empty.
    defn = new InsnDefn("ffree",  x86_ffree,   0x03, 0xddc0, od_i, od_sti);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-363");
    define(defn);

    //--- page 3-363 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    //  DE /2          FICOM m16int         Valid    Valid      Compare ST(0) with m16int.
    defn = new InsnDefn("ficom",  x86_ficom,   0x03, 0xde, od_e2, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-363");
    define(defn);
    //  DA /2          FICOM m32int         Valid    Valid      Compare ST(0) with m32int.
    defn = new InsnDefn("ficom",  x86_ficom,   0x03, 0xda, od_e2, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-363");
    define(defn);
    //  DE /3          FICOMP m16int        Valid    Valid      Compare ST(0) with m16int and pop
    //                                                          stack register.
    defn = new InsnDefn("ficomp", x86_ficomp,  0x03, 0xde, od_e3, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-363");
    define(defn);
    //  DA /3          FICOMP m32int        Valid    Valid      Compare ST(0) with m32int and pop
    //                                                          stack register.
    defn = new InsnDefn("ficomp", x86_ficomp,  0x03, 0xda, od_e3, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-366");
    define(defn);

    //--- page 3-366 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // DF /0           FILD m16int   Valid     Valid        Push m16int onto the FPU register
    //                                                      stack.
    defn = new InsnDefn("fild",   x86_fild,    0x03, 0xdf, od_e0, od_m16);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-366");
    define(defn);
    // DB /0           FILD m32int   Valid     Valid        Push m32int onto the FPU register
    //                                                      stack.
    defn = new InsnDefn("fild",   x86_fild,    0x03, 0xdb, od_e0, od_m32);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-366");
    define(defn);
    // DF /5           FILD m64int   Valid     Valid        Push m64int onto the FPU register
    //                                                      stack.
    defn = new InsnDefn("fild",   x86_fild,    0x03, 0xdf, od_e5, od_m64);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-368");
    define(defn);

    //--- page 3-368 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // D9 F7           FINCSTP       Valid     Valid          Increment the TOP field in the FPU
    //                                                        status register.
    defn = new InsnDefn("fincstp", x86_fincstp, 0x03, 0xd9f7, od_none);
    defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-370");
    define(defn);

    //--- page 3-370 of x86-InstructionSetReference-AM.pdf -------------------------------------------------------------
    // 9B DB E3        FINIT         Valid     Valid           Initialize FPU after checking for pending
    //                                                         unmasked floating-point exceptions.
    // See WAIT instead.
    // defn = new InsnDefn("finit",  x86_finit,   0x03, 0x9bdbe3, od_none);
    // defn->set_location("x86-InstructionSetReference-AM.pdf, page 3-370");
    // define(defn);
    // DB E3           FNINIT*       Valid     Valid           Initialize FPU without checking for
    //                                                         pending unmasked floating-point
    //                                                         exceptions.
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//                                       D O   N O T   E D I T                                                      //
//------------------------------------------------------------------------------------------------------------------//
//                                                                                                                  //
// This file was generated automatically from Intel PDF documentation. Its purpose is to intialize the ROSE x86     //
// assembler with information about how to encode each x86 instruction.                                             //
//                                                                                                                  //
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
