:- template "compass".
:- include "rose.P".

:- declare ancNoSwitchEndingAtDefault(node, node).
ancNoSwitchEndingAtDefault(A, C) :-
  defaultStatement(C, _), parent(A, C), \+switchStatement(A, _, _).
ancNoSwitchEndingAtDefault(A, C) :-
  ancNoSwitchEndingAtDefault(B, C),
  parent(A, B),
  \+switchStatement(A, _, _).

:- declare switchWithDefault(node).
switchWithDefault(S) :-
    switchStatement(S, _, C), ancNoSwitchEndingAtDefault(C, _).

:- declare switchWithoutDefault(node).
switchWithoutDefault(S) :-
    switchStatement(S, _, _),
    \+switchWithDefault(S).

?- switchWithoutDefault(S),
   % compassParameter("SwitchWithoutDefault.errorString", ErrString),
   ErrString = """This switch statement does not have a default case""",
   compassError(S, "SwitchWithoutDefault", ErrString).
