// No Rand
// Author: Gary M. Yuan
// Date: 27-August-2007

#include "rose.h"
#include "compass.h"

#ifndef COMPASS_NO_RAND_H
#define COMPASS_NO_RAND_H

namespace CompassAnalyses
   { 
     namespace NoRand
        { 
        /*! \brief No Rand: Add your description here 
         */

          extern const std::string checkerName;
          extern const std::string shortDescription;
          extern const std::string longDescription;

       // Specification of Checker Output Implementation
          class CheckerOutput: public Compass::OutputViolationBase
             { 
               public:
                    CheckerOutput(SgNode* node);
             };

       // Specification of Checker Traversal Implementation

          class Traversal
             : public Compass::AstSimpleProcessingWithRunFunction
             {
            // Checker specific parameters should be allocated here.
               Compass::OutputObject* output;

               public:
                    Traversal(Compass::Parameters inputParameters, Compass::OutputObject* output);

                 // The implementation of the run function has to match the traversal being called.
                    void run(SgNode* n){ this->traverse(n, preorder); };

                    void visit(SgNode* n);
             };
        }
   }

// COMPASS_NO_RAND_H
#endif 

// -*- mode: C++; c-basic-offset: 2; indent-tabs-mode: nil -*-
// vim: expandtab:shiftwidth=2:tabstop=2

// No Rand Analysis
// Author: Gary M. Yuan
// Date: 27-August-2007

#include "compass.h"
// #include "noRand.h"

namespace CompassAnalyses
   { 
     namespace NoRand
        { 
          const std::string checkerName      = "NoRand";

       // Descriptions should not include the newline character "\n".
          const std::string shortDescription = "This checker checks that rand() is not used.";
          const std::string longDescription  = "The C Standard function rand (available in stdlib.h) does not have good random number properties. The numbers generated by rand have a comparatively short cycle, and the numbers may be predictable. To achieve the best random numbers possible, an implementation-specific function needs to be used.";
        } //End of namespace NoRand.
   } //End of namespace CompassAnalyses.

CompassAnalyses::NoRand::
CheckerOutput::CheckerOutput ( SgNode* node )
   : OutputViolationBase(node,checkerName,shortDescription)
   {}

CompassAnalyses::NoRand::Traversal::
Traversal(Compass::Parameters inputParameters, Compass::OutputObject* output)
   : output(output)
   {
  // Initalize checker specific parameters here, for example: 
  // YourParameter = Compass::parseInteger(inputParameters["NoRand.YourParameter"]);


   }

void
CompassAnalyses::NoRand::Traversal::
visit(SgNode* node)
   {
     const int STRING_LEN_RAND = 4;

     SgFunctionRefExp *sgFuncRef = isSgFunctionRefExp( node );

     if( sgFuncRef != NULL )
     {
       std::string fncName = sgFuncRef->get_symbol()->get_name().getString();

       if( fncName.find( "rand", 0, STRING_LEN_RAND ) != std::string::npos )
       {
         output->addOutput( new CheckerOutput( node ) );
       } //if( fncName.find("vfork", 0, STRING_LEN_RAND) != std::string::npos )
     } //if( sgFuncRef != NULL )

     return;
   } //End of the visit function.
   

static void run(Compass::Parameters params, Compass::OutputObject* output) {
  CompassAnalyses::NoRand::Traversal(params, output).run(Compass::projectPrerequisite.getProject());
}

static Compass::AstSimpleProcessingWithRunFunction* createTraversal(Compass::Parameters params, Compass::OutputObject* output) {
  return new CompassAnalyses::NoRand::Traversal(params, output);
}

extern const Compass::Checker* const noRandChecker =
  new Compass::CheckerUsingAstSimpleProcessing(
        CompassAnalyses::NoRand::checkerName,
        CompassAnalyses::NoRand::shortDescription,
        CompassAnalyses::NoRand::longDescription,
        Compass::C | Compass::Cpp,
        Compass::PrerequisiteList(1, &Compass::projectPrerequisite),
        run,
        createTraversal);
