#!/bin/csh -f

# for DAKOTA 4.2

# After running configure, gmake, and install, these operations will finish 
# copying files and creating links in the installed DAKOTA directories in $prefix
# Appropriate permissions will also be set in the bin and lib directories.
# (These steps were previously inside extract_bin.csh.)

echo "Run this script from within Dakota to operate on prefix=$prefix"

foreach f ( INSTALL \
            LICENSE \
            COPYRIGHT \
            README \
            test )
  cp -rf $f $prefix
end
 
# handle applications separately since need subdirs
set at_pre = "examples/script_interfaces"
foreach f ( examples/linked_interfaces \
            examples/methods \
            examples/parallelism \
            examples/platforms \
            examples/README \
            $at_pre/Abaqus \
            $at_pre/Cask/filters \
            $at_pre/Nastran/cylinder \
            $at_pre/Qtran/scripts \
            $at_pre/Salinas/aff_all_fns.C \
            $at_pre/Salinas/dakota_aff_lhs.in \
            $at_pre/Salinas/salinas_script_asv \
            $at_pre/Rsmas \
            $at_pre/generic \
            examples/tutorial )
  tar cf - $f | (cd $prefix; tar xf -)
end
 
# removals from test and examples directories
cd $prefix
foreach d ( test examples )
  # TODO: this doesn't seem to work correctly on Solaris (sass9000), nor AIX
  #foreach f ( Makefile\* config\* \*.\[Cc\] \*.\[Ff\] \*.m4 \*.o )
  #  find $d -name "$f" -exec rm -f '{}' \;
  #end
  find $d -name 'Makefile*' -exec rm -f '{}' \;
  find $d -name 'config*' -exec rm -f '{}' \;
  find $d -name '*.[Cc]' -exec rm -f '{}' \;
  find $d -name '*.[Ff]' -exec rm -f '{}' \;
  find $d -name '*.m4' -exec rm -f '{}' \;
  find $d -name '*.o' -exec rm -f '{}' \;
end
 
# repair soft links broken by moving src to bin during make install
# TODO: use $EXEEXT for Cygwin where appropriate
set ln = /bin/ln
 
cd $prefix/test
rm -rf .deps .libs
rm -f plxtnd5.fnt dakota dakota_library_mode dakota_restart_util
if ( -e  ../share/plplot5.5.2/plxtnd5.fnt ) then
  $ln -s ../share/plplot5.5.2/plxtnd5.fnt plxtnd5.fnt
endif
$ln -s ../bin/dakota dakota
$ln -s ../bin/dakota_restart_util dakota_restart_util
# dakota_library_mode only built in int_full for now
if ( -e ../bin/dakota_library_mode ) then
  $ln -s ../bin/dakota_library_mode dakota_library_mode
endif
 
# only need to fix dakota and dakota_restart_util below, be cautious for now
cd $prefix/examples/tutorial
rm -rf .deps .libs
rm -f dakota rosenbrock text_book
$ln -s ../../bin/dakota dakota
$ln -s ../../test/rosenbrock rosenbrock
$ln -s ../../test/text_book text_book
 
cd $prefix/examples/methods
rm -rf .deps .libs
rm -f dakota
$ln -s ../../bin/dakota dakota
 
cd $prefix/examples/script_interfaces/generic
rm -rf .deps .libs
rm -f dakota rosenbrock
$ln -s ../../../bin/dakota dakota
$ln -s ../../../test/rosenbrock rosenbrock
 
# Limit read access permissions for certain binaries and libraries
cd $prefix/bin
chmod -f o-r dakota dakota_restart_util lssol nlssol npsol
cd $prefix/lib
chmod -f o-r libdakota.a libdakota.la libdot.a libdot.la libnpsol.a libnpsol.la
 

