/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:	 NonDSampling
//- Description: Wrapper class for Fortran 90 LHS library
//- Owner:       Mike Eldred
//- Checked by:
//- Version:

#ifndef NOND_LHS_SAMPLING_H
#define NOND_LHS_SAMPLING_H

#include "NonDSampling.H"
#include "DataMethod.H"


namespace Dakota {

/// Performs LHS and Monte Carlo sampling for uncertainty quantification.

/** The Latin Hypercube Sampling (LHS) package from Sandia
    Albuquerque's Risk and Reliability organization provides
    comprehensive capabilities for Monte Carlo and Latin Hypercube
    sampling within a broad array of user-specified probabilistic
    parameter distributions.  It enforces user-specified rank
    correlations through use of a mixing routine.  The NonDLHSSampling
    class provides a C++ wrapper for the LHS library and is used for
    performing forward propagations of parameter uncertainties into
    response statistics. */

class NonDLHSSampling: public NonDSampling
{
public:

  //
  //- Heading: Constructors and destructor
  //

  NonDLHSSampling(Model& model); ///< standard constructor

  /// alternate constructor for sample generation and evaluation "on the fly"
  NonDLHSSampling(Model& model, int samples, int seed,
		  short sampling_vars_mode = ACTIVE);

  /// alternate constructor for sample generation "on the fly"
  NonDLHSSampling(int samples, int seed, const RealDenseVector& lower_bnds,
		  const RealDenseVector& upper_bnds);

  ~NonDLHSSampling();            ///< destructor

protected:

  //
  //- Heading: Virtual function redefinitions
  //

  /// performs a forward uncertainty propagation by using LHS to generate a
  /// set of parameter samples, performing function evaluations on these
  /// parameter samples, and computing statistics on the ensemble of results.
  void quantify_uncertainty();

  /// print the final statistics
  void print_results(ostream& s);

private:

  //
  //- Heading: Data
  //

  bool varBasedDecompFlag; ///< flags computation of VBD
};

} // namespace Dakota

#endif
