/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:       AllConstraints
//- Description: Container class of linear constraints and bounds employing
//-              the "all" approach to variables usage.
//- Owner:       Mike Eldred
//- Version: $Id: AllConstraints.H 5793 2009-03-31 03:15:00Z mseldre $

#ifndef ALL_CONSTRAINTS_H
#define ALL_CONSTRAINTS_H

#include "DakotaConstraints.H"


namespace Dakota {

/// Derived class within the Constraints hierarchy which
/// employs the all data view.

/** Derived variable constraints classes take different views of the
    design, uncertain, and state variable types and the continuous and
    discrete domain types.  The AllConstraints derived class
    combines design, uncertain, and state variable types but separates
    continuous and discrete domain types.  The result is combined
    continuous bounds arrays (allContinuousLowerBnds,
    allContinuousUpperBnds) and combined discrete bounds arrays
    (allDiscreteLowerBnds, allDiscreteUpperBnds).  Parameter and DACE
    studies currently use this approach (see
    Variables::get_variables(problem_db) for variables view selection;
    variables view is passed to the Constraints constructor in Model). */

class AllConstraints: public Constraints
{
public:

  //
  //- Heading: Constructor and destructor
  //

  /// default constructor
  AllConstraints();
  /// standard constructor
  AllConstraints(const ProblemDescDB& problem_db,
		 const pair<short,short>& view,
		 const Sizet2DArray& vars_comps);
  /// destructor
  ~AllConstraints();

  //
  //- Heading: Virtual function redefinitions
  //

  void write(ostream& s) const;
  void read(istream& s);

protected:

  //
  //- Heading: Virtual function redefinitions
  //

  void copy_rep(const Constraints* con_rep);
  void reshape_rep();

  void build_active_views();
  void build_inactive_views();

private:

  //
  //- Heading: Convenience functions
  //
};


inline AllConstraints::AllConstraints()
{ }


inline AllConstraints::~AllConstraints()
{ }


inline void AllConstraints::copy_rep(const Constraints* con_rep)
{ build_views(); }


inline void AllConstraints::build_inactive_views()
{
  Cerr << "Error: inactive view must be EMPTY in AllConstraints." << endl;
  abort_handler(-1);
}

} // namespace Dakota

#endif
