// $Id: APPSPACK_Citizen_NAPPSPACK.hpp,v 1.2 2008/05/02 00:57:23 tgkolda Exp $ 
// $Source: /usr/local/cvsroot/hopspack/src/APPSPACK_Citizen_NAPPSPACK.hpp,v $ 

//@HEADER
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
//@HEADER

/*!
  \file APPSPACK_Citizen_NAPPSPACK.hpp
  \brief Class definition for APPSPACK::Citizen_NAPPSPACK
*/

#ifndef APPSPACK_CITIZEN_NAPPSPACK_HPP
#define APPSPACK_CITIZEN_NAPPSPACK_HPP

#include "APPSPACK_Citizen_Interface.hpp"
#include "APPSPACK_Citizen_GSS.hpp"
#include "APPSPACK_Parameter_List.hpp"
#include "APPSPACK_Constraints_Linear.hpp"
#include "APPSPACK_Iterator.hpp"
#include "APPSPACK_List.hpp"
#include "NAPPSPACK_Method_Generic.hpp"
#include "NAPPSPACK_NLSolver.hpp"

namespace APPSPACK
{
namespace Citizen
{

//! Wrapper for an instance of class Iterator. 
/*! Todo add comments. */
class NAPPSPACK : public Interface
{
public:
  //! Constructor 
  NAPPSPACK(Parameter::List& params_in, 
      const Constraints::Linear& constraints_in,
      Combiner::Generic& combiner_in,
      const string name = "");
  
  //! Constructor 
  NAPPSPACK(Parameter::List& params_in,
      const Constraints::Linear& constraints_in,
      const string name = "");

  //! Destructor
  ~NAPPSPACK();

  //! Prints initial information corresponding to solver parameter "Debug".
  virtual void preprocess();

  //! Print final information when solve has completed.
  virtual void postprocess();
  
  //! Exchange points.
  virtual void exchange(const ConveyorList& R, ConveyorList& Wnew, 
                        const map<string, vector<int> >& ownermap);     
  
  //! Vote on point order.
  virtual void vote(const ConveyorList& W, 
		    const map<string, vector<int> >& ownermap,
		    vector<int>& tagOrder);
  
  //! Return citizen's solve state.
  virtual Citizen::State getState();
 
  //! Return citizen's name.
  virtual const string& getName() const;

private:

   //! Solve subproblem using GSS Citizen.
  void updateSubproblem();
  
  //! Copy double parameter from Citizen to parameter Nonlinear
  void copyDoubleParameter(string paramName);

  //! Returns infinity norm of all but first elements of fc
  double infnorm(APPSPACK::Vector fc);

  //! Update current best point found satisfying constraint tolerance.
  /*! Returns true new point is within constraint tolerance,
    or improves feasibility */
  bool updateBest(const APPSPACK::Vector& x, const APPSPACK::Vector& fc);

private:

  //! Parameters
  Parameter::List params;

  //! Constraints
  const Constraints::Linear& constraints;

  //! Method which defines \f$M(x,\rho_k)\f$ and corresponding update strategies.
  ::NAPPSPACK::Method::Generic* method;

  //! Current best point
  APPSPACK::Vector xBest;

  //! Function values corresponding to current best point
  APPSPACK::Vector fcBest;

  //! Sate of linear solver.
  APPSPACK::Solver::State minorState;

  //! State of nonlinear solver.
  ::NAPPSPACK::NLSolver::State majorState;

  //! String storing state string.
  string success;

  //! GSS solver.
  Citizen::GSS* solver;

  //! Optional citizen name.
  string name;

  //! Number of nonlinear equality constraints;
  int nlec; 
  //! Number nonlinear inequality constraints;
  int nlic;

  //! Maximum number of evaluations per major iteration.
  int maxMajorEvaluations;
  //! Maximum number of major (or outer) iterations.
  int maxMajorIterations;
  //! Current iteration count.
  int iterationCount;
  //! Maximum number of evaluations.
  int nEvaluated;
  //! Evaluations count for a given major iteration.
  int evalCount;

  //! Stores x value corresponding to fcBestTol
  APPSPACK::Vector xBestTol;

  //! Stores best objective value satisfying contraint violation tolerance.
  APPSPACK::Vector fcBestTol;

  //! Constraint violation tolerance.
  double etaStar;

  //! Specifies filter on what points are communicated.
  /*! If filter = 0, all points are shared.
      If filter = 1, only improving feasible points are shared
      If filter = 2, no points are shared
  */
  int filterLevel;

  //! Debug level.
  int debug;

  //! If true, penalty method can force everyone to quit.
  bool canForceQuit;

};

}
}
#endif
