//@HEADER
// ************************************************************************
// 
//         HOPSPACK: Hybrid Opitmization Parallel Search Package
//               Copyright (2008) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.                                                                           .
// 
// Questions? Contact Tammy Kolda (tgkolda@sandia.gov) 
// 
// ************************************************************************
//@HEADER

/*!
  \file NAPPSPACK_Method_Smooth.hpp
  \brief Class description for NAPPSPACK::Method::Smooth
*/

#ifndef NAPPSPACK_METHOD_SMOOTH
#define NAPPSPACK_METHOD_SMOOTH

#include "APPSPACK_Common.hpp"
#include "APPSPACK_Combiner_Smooth.hpp"
#include "APPSPACK_Parameter_List.hpp"
#include "NAPPSPACK_Method_Generic.hpp"


namespace NAPPSPACK
{
namespace Method
{

//! This class sets up methods based on exact and smoothed exact merit functions. 
class Smooth : Generic
{
public:
  //! Constructor.
  Smooth(APPSPACK::Parameter::List& params);
  
  //! Derived.
  virtual void update(APPSPACK::Vector& x, APPSPACK::Vector& fc,
		      const APPSPACK::Solver::State& state);
  
  //! Derived.
  virtual bool isOptimal(const APPSPACK::Vector& fc) const;
  
  //! Derived.
  virtual void printMajor(const APPSPACK::Vector& x,
			  const APPSPACK::Vector& fc) const;
  
  //! Derived.
  virtual APPSPACK::Combiner::Smooth& getCombiner();
  
  //! Derived.
  virtual const string& getName();

  //! Derived.
  virtual double infnorm(const APPSPACK::Vector& fc) const;

  //! Update APPSPACK parameters.
  void updateAPPSPACKParams(double tol);

private:

  //! Stores parameter list to be passed to APPSPACK for each subproblem solve
  APPSPACK::Parameter::List& params;

  //! Combiner for exact and smoothed-exact merit functions.
  APPSPACK::Combiner::Smooth combiner;
  
  //! Name of method.
  const string methodName;

  //! Desired optimality.
  double etaStar;

  //! Final stopping step size;
  double deltaStar;

  //! Current step size.
  double deltak;

  //! Minimum step size.
  double deltaMin;

  //! Minimum value for epsilon.
  double alphaMin;

  //! Maximum value of penalty term.
  double rhoMax;

  //! Debug level.
  int debug;

  //! Amount by which delta is reduced after each major.
  double deltaDecrease;

  //! Amount by which smoothing parameter is reduced after each major.
  double alphaDecrease;

  //! Amount by which penalty parameter is increased after each major.
  double rhoIncrease;

};


}
}
#endif
