/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Copyright: Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia, 2005
*******************************************************************/
///////////////////////////////////////////////////////////////////

#include "population.h"


population::population()
{
	pop_size=0;
	individuals=NULL;
	//rank=NULL;
}
population::population(int size)
{
	individuals=NULL;
	//rank=NULL;
	set_pop_size(size);
}

population::~population()
{
	
	if (individuals) {	delete [] individuals;	individuals=NULL;}
	
	
	//if (rank) {	delete [] rank;	rank=NULL;}
	
}
int  population::check_dominationN(individual &id1, individual &id2)
{
	int i;
	int check1=TRUE,check2=FALSE;
	for(i=0;i<id1.InumberofObjs;i++)
	{
		if (id1.DfitnessN[i]>id2.DfitnessN[i])
		{
			check1=FALSE;
			break;
		}
	}
	for(i=0;i<id1.InumberofObjs;i++)
	{
		if (id1.DfitnessN[i]<id2.DfitnessN[i])
		{
			check2=TRUE;
			break;
		}
	}
	return check1&&check2;
}
int  population::check_dominationC(individual &id1, individual &id2)
{
	int i;
	int check1=TRUE,check2=FALSE;
	for(i=0;i<id1.InumberofObjs;i++)
	{
		if (id1.DfitnessC[i]>id2.DfitnessC[i])
		{
			check1=FALSE;
			break;
		}
	}
	for(i=0;i<id1.InumberofObjs;i++)
	{
		if (id1.DfitnessC[i]<id2.DfitnessC[i])
		{
			check2=TRUE;
			break;
		}
	}
	return check1&&check2;
}

int  population::check_ParetoOptimalN(individual &id1,int level)
{
	int i,check=TRUE;
	for(i=0;i<pop_size;i++)
	{
		if ((individuals[i].rank==-1)||(individuals[i].rank==level))
			if (check_dominationN(individuals[i],id1))
			{
				check=FALSE;
				break;
			}
	}
	return check;
}
int  population::check_ParetoOptimalC(individual &id1,int level)
{
	int i,check=TRUE;
	for(i=0;i<pop_size;i++)
	{
		if ((individuals[i].rank==-1)||(individuals[i].rank==level))
			if (check_dominationC(individuals[i],id1))
			{
				check=FALSE;
				break;
			}
	}
	return check;
}
void population::statistic(int g,ofstream &f)
{
	cal_averagefitness();
	cal_standarddeviation();
	//population
	print(g,f);
	//print_ParetoOptimal(f);
}

void population::rankingC()
{
	int i,check=TRUE,level=0;
	
	for (i=0;i<pop_size;i++)
		individuals[i].rank=-1;
	while (1)
	{
		check=TRUE;
		for (i=0;i<pop_size;i++)
		{
			
			if (individuals[i].rank==-1)
			{
				if (check_ParetoOptimalC(individuals[i],level))
				{
					individuals[i].rank=level;
				}
				check=FALSE;
			}
		}
		
		if (check) break;
		level++;
	}
	
	//rank store
	rank_level=level;
	
}
void population::rankingN()
{
	int i,check=TRUE,level=0;
	
	for (i=0;i<pop_size;i++)
		individuals[i].rank=-1;
	while (1)
	{
		check=TRUE;
		for (i=0;i<pop_size;i++)
		{
			
			if (individuals[i].rank==-1)
			{
				if (check_ParetoOptimalN(individuals[i],level))
				{
					individuals[i].rank=level;
				}
				check=FALSE;
			}
		}
		
		if (check) break;
		level++;
	}
	
	//rank store
	rank_level=level;
	
}

void population::cal_averagefitness()
{
	average_fitness=0;
	for (int i=0;i<pop_size;i++)
		average_fitness +=individuals[i].DglobalFitness;
	average_fitness=average_fitness/pop_size;
}

void population::cal_standarddeviation()
{
	double s1=0,s2=0,temp=0;
	for (int i=0;i<pop_size;i++)
	{
		temp=individuals[i].DglobalFitness;
		s1+=temp*temp;
		s2+=temp;
	}
	standard_deviation=(pop_size*s1-s2*s2)/(pop_size*(pop_size-1));
}

void population::set_pop_size(int s)
{
	if (s!=pop_size)
	{
		
		pop_size=s;
		if (individuals) {delete [] individuals; individuals=NULL;}
		individuals= new individual[s];
		
		//if (rank) {delete [] rank;rank=NULL;}
		//rank=new int[s];
		
		for (int i=0;i<pop_size;i++)
			individuals[i].rank=-1;
	}
}


void population::print(int g, ofstream &f)
{
	int i;
	f<< "-----------GENERATION: " << g << " pop size: "<< pop_size << "--------------------------------------------------------" << endl;	
	for (i=0;i<pop_size;i++)
		individuals[i].print_fn(f); 
}

void population::print_ParetoOptimal(int g, ofstream &f)
{
	//int c=0;
	n_nondominated_set=0;
	//	f << g << endl;
	for (int i=0;i<pop_size;i++)
		if (individuals[i].rank==0)
		{
			individuals[i].print(f);
			n_nondominated_set++;
		}
		//f << "number of pareto set: " << n_nondominated_set << endl;
}

void population::print_ParetoOptimal_fn(int g, ofstream &f)
{
	//int c=0;
	n_nondominated_set=0;
	//	f << g << endl;
	for (int i=0;i<pop_size;i++)
		if (individuals[i].rank==0)
		{
			individuals[i].print_fn(f);
			n_nondominated_set++;
		}
		//f << "number of pareto set: " << n_nondominated_set << endl;
}
void population::print_ParetoOptimal_x(int g, ofstream &f)
{
	//f << g << endl;
	for (int i=0;i<pop_size;i++)
		if (individuals[i].rank==0)
		{
			individuals[i].print_x(f);
		}
}
population &population::operator=(const population &pop)
{
	int i;
	
	set_pop_size(pop.pop_size);
	
	rank_level			=	pop.rank_level;  
	n_nondominated_set	=	pop.n_nondominated_set;
	
	if (pop.individuals) 
	{
		for (i=0;i<pop_size;i++)
			individuals[i] = pop.individuals[i]; 
	}
	//if (pop.rank) 
	//{
	for (i=0;i<pop_size;i++)
		individuals[i].rank=pop.individuals[i].rank; 
	//}
	return *this;	
	// add more statistical variables, but not now
	
}
