/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

//
// PEAreal.cpp
//

#include <acro_config.h>
#include <coliny/PEAreal.h>

using namespace utilib;
using namespace std;

namespace coliny {


PEAreal::PEAreal() 
  : 
    EAbase<EApoint_real, NumArray<double> >(),
    PEAbase<EApoint_real, NumArray<double> >(),
    EAops_real()
{ }


void PEAreal::write(ostream& os) const
{
PEAbase<EApoint_real, NumArray<double> >::write(os);
EAops_real::write(os);
}


void PEAreal::reset() 
{
if (popsize() == 0)
   init_population(100);
PEAbase<EApoint_real, NumArray<double> >::reset(); 
EAops_real::reset(); 
}

} // namespace coliny
