/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

/**
 * \file PEAreal.h
 *
 * Defines the coliny::PEreal class.
 */

#ifndef coliny_PEAreal_h
#define coliny_PEAreal_h

#include <acro_config.h>
#include <coliny/PEAbase.h>
#include <coliny/EAops_real.h>

namespace coliny {


/** An evolutionary algorithm with genotype=RealVector and phenotype=RealVector */

class PEAreal : virtual public PEAbase<EApoint_real, NumArray<double> >, 
		virtual public EAops_real {

public:

  ///
  PEAreal();

  ///
  void reset();

  ///
  void write(std::ostream& os) const;

protected:

  ///
  void initialize_best_point()
	{
	if ((best().point.size() > 0) &&
	    (best().point.size() != problem.num_real_params()))
	   EXCEPTION_MNGR(std::runtime_error, "initialize_best_point - user-provided best point has length " << best().point.size() << " but the problem size is " << problem.num_real_params() << std::endl);
	best().point.resize(problem.num_real_params());
	}
};

} // namespace coliny

#endif
