/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:       DakotaPsuade
//- Description: This class provides necessary interface for DAKOTA with PSUADE
//- Owner:       Brian M. Adams, Sandia National Laboratories

#ifndef DAKOTA_PSUADE_H
#define DAKOTA_PSUADE_H

#include "gsl/gsl_rng.h"

#define PSUADE_UNDEFINED -DBL_MAX

class DakotaPsuade
{
public:

  DakotaPsuade();
  DakotaPsuade(int seed);
  ~DakotaPsuade();

  // for safety for now, only allowing element-wise access to sampleMatrix
  /// return the i,j entry of the sample matrix
  double sample_matrix(int i, int j);

protected:

  //-- Member functions

  /// generate a random number in [0,1)
  double PSUADE_drand();
  /// create a vector with integers [0:num_inputs-1] and permute
  void generateRandomIvector(int num_inputs, int *permute);

  //-- Data

  /// pointer to a GSL random number generator engine
  gsl_rng *randomNumberGenerator;
  /// matrix of samples to evaluate
  double **sampleMatrix_;

};

inline double DakotaPsuade::sample_matrix(int i, int j)
{ return sampleMatrix_[i][j]; }

#endif
