/*  _______________________________________________________________________

    DAKOTA: Design Analysis Kit for Optimization and Terascale Applications
    Copyright (c) 2006, Sandia National Laboratories.
    This software is distributed under the GNU General Public License.
    For more information, see the README file in the top Dakota directory.
    _______________________________________________________________________ */

//- Class:       DakotaPsuade
//- Description: Implementation code for the DakotaPsuade class
//- Owner:       Brian M. Adams, Sandia National Laboratories

#include "DakotaPsuade.H"
#include "gsl/gsl_randist.h"
#include "gsl/gsl_rng.h"

static const char rcsId[]="@(#) $Id$";

/** This constructor allocates the GSL RNG without seed */
DakotaPsuade::DakotaPsuade()
{ randomNumberGenerator = gsl_rng_alloc(gsl_rng_taus2); }

/** This constructor allocates the GSL RNG with DAKOTA-specified seed */
DakotaPsuade::DakotaPsuade(int seed) 
{ 
  randomNumberGenerator = gsl_rng_alloc(gsl_rng_taus2);
  gsl_rng_set(randomNumberGenerator, seed);
}

DakotaPsuade::~DakotaPsuade()
{ gsl_rng_free(randomNumberGenerator); randomNumberGenerator = 0; }
  
double DakotaPsuade::PSUADE_drand()
{ return gsl_rng_uniform(randomNumberGenerator); }

// option to return in [0,1] (fully-closed) since PSUADE expects
// this has a low probability of affecting results.
/*
double DakotaPsuade::PSUADE_drand()
{ 
  return (gsl_rng_get(randomNumberGenerator)-gsl_rng_min(randomNumberGenerator))
	 / gsl_rng_max(randomNumberGenerator);
}
*/

/** emulation of PSUADE's integer vector shuffler generateRandomIvector
    presumes permute has been allocated
    populates with [0:num_inputs-1] and permutes */
void DakotaPsuade::generateRandomIvector(int num_inputs, int *permute)
{
  for (int i=0; i<num_inputs; i++) permute[i]=i;
  gsl_ran_shuffle(randomNumberGenerator, permute, num_inputs, sizeof(int));
}


