/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Inline methods of class MetricTracker.

    NOTES:

        See notes of MetricTracker.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Tue Jul 22 10:29:01 2003 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the inline methods of the MetricTracker class.
 */




/*
================================================================================
Includes
================================================================================
*/








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace Algorithms {







/*
================================================================================
Inline Mutators
================================================================================
*/








/*
================================================================================
Inline Accessors
================================================================================
*/


inline
std::size_t
MetricTracker::GetStackDepth(
    ) const
{
    return _stack.size();
}

inline
std::size_t
MetricTracker::GetStackMaxDepth(
    ) const
{
    return _maxDepth;
}

inline
const DoubleStack&
MetricTracker::GetStack(
    ) const
{
    return _stack;
}






/*
================================================================================
Inline Public Methods
================================================================================
*/


inline
double
MetricTracker::Top(
    ) const
{
    return _stack.back();
}

inline
double
MetricTracker::Bottom(
    ) const
{
    return _stack.front();
}

inline
bool
MetricTracker::IsFull(
    ) const
{
    return _stack.size() == _maxDepth;
}




/*
================================================================================
Inline Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Inline Private Methods
================================================================================
*/








/*
================================================================================
Inline Structors
================================================================================
*/








/*
================================================================================
End Namespace
================================================================================
*/
    } // namespace Algorithms
} // namespace JEGA
