/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA)

    CONTENTS:

        Inline methods of class NullOperatorGroup.

    NOTES:

        See notes of NullOperatorGroup.hpp.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Thu May 29 10:25:04 2003 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the inline methods of the NullOperatorGroup class.
 */


/*
================================================================================
Includes
================================================================================
*/








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace Algorithms {







/*
================================================================================
Inline Mutators
================================================================================
*/








/*
================================================================================
Inline Accessors
================================================================================
*/








/*
================================================================================
Inline Public Methods
================================================================================
*/
inline
const GeneticAlgorithmOperatorGroup&
NullOperatorGroup::Instance(
    )
{
    return FullInstance();
}

inline
const NullOperatorGroup&
NullOperatorGroup::FullInstance(
    )
{
    static const NullOperatorGroup* instance = new NullOperatorGroup();
    return *instance;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::MutatorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::NichePressureApplicatorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::ConvergerRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::CrosserRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::FitnessAssessorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::SelectorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::InitializerRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::EvaluatorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::MainLoopRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}

inline
GeneticAlgorithmOperatorRegistry&
NullOperatorGroup::PostProcessorRegistry(
    )
{
    static GeneticAlgorithmOperatorRegistry* registry =
        new GeneticAlgorithmOperatorRegistry();
    return *registry;
}




/*
================================================================================
Inline Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Inline Private Methods
================================================================================
*/








/*
================================================================================
Inline Structors
================================================================================
*/








/*
================================================================================
End Namespace
================================================================================
*/
    } // namespace Algorithms
} // namespace JEGA
