/* A lexical scanner generated by flex*/

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>
#include <unistd.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* Some routines like yy_flex_realloc() are emitted as static but are
   not called by all lexers. This generates warnings in some compilers,
   notably GCC. Arrange to suppress these. */
#ifdef __GNUC__
#define YY_MAY_BE_UNUSED __attribute__((unused))
#else
#define YY_MAY_BE_UNUSED
#endif

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t )) YY_MAY_BE_UNUSED;
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 41
#define YY_END_OF_BUFFER 42
static yyconst short int yy_accept[117] =
    {   0,
        0,    0,    0,    0,    0,    0,   42,   40,    2,    1,
       40,   32,   33,   40,   40,   15,   25,   23,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   34,   35,   14,
       29,   31,   30,   32,   33,   36,   37,   28,   40,   40,
       27,   26,    2,    0,   38,   39,   21,   24,   22,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   14,   36,
        0,   27,   27,   27,    0,   26,    0,    0,    0,    0,
        0,   20,    0,    0,   17,   27,    0,   27,    0,   16,
        0,    0,    0,   19,   10,    0,    0,   18,    0,    0,
        0,    0,    0,    0,    0,    0,   12,    3,    4,    6,

        0,    0,    3,    0,    0,    7,   11,    0,    0,    8,
        9,    0,    0,   13,    5,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    1,    1,    6,
        7,    8,    9,   10,    9,   11,   12,   13,   14,   15,
       16,   16,   16,   16,   16,   16,   16,   17,   18,   19,
       20,   21,    1,    1,   22,   23,   24,   25,   26,   23,
       27,   23,   28,   23,   29,   30,   23,   31,   32,   33,
       23,   34,   35,   36,   37,   23,   38,   23,   39,   23,
       40,    1,   41,    1,   42,    1,   43,   43,   43,   43,

       44,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   45,   46,   47,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[48] =
    {   0,
        1,    2,    1,    1,    1,    2,    2,    2,    2,    2,
        2,    2,    3,    3,    3,    3,    2,    1,    2,    1,
        2,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    2,
        2,    3,    3,    3,    1,    1,    1
    } ;

static yyconst short int yy_base[120] =
    {   0,
        0,    0,   47,    0,   94,    0,  298,  299,  295,  299,
      293,  299,  299,  287,  274,  299,  273,  272,  261,  264,
      255,  257,  261,  260,  259,  248,  261,  299,  299,  129,
      299,  299,  299,    0,    0,    0,  299,  299,  135,  139,
      148,    0,  280,  278,  299,  299,  299,  299,  299,  252,
      244,  246,  241,  237,  236,  241,  228,  234,  152,    0,
      162,  171,  175,  190,  198,    0,  238,  235,  221,  231,
      218,  241,  224,  225,  299,  207,  211,  215,  217,  299,
      217,  222,  216,  299,  217,  215,  243,  299,  218,  209,
      204,  191,  155,  183,  185,  174,  178,  222,  172,  156,

      164,  165,  226,  155,  167,  165,  299,  144,  125,  299,
      299,  122,  120,  299,  299,  299,  270,  272,  144
    } ;

static yyconst short int yy_def[120] =
    {   0,
      116,    1,  116,    3,  116,    5,  116,  116,  116,  116,
      117,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  118,  118,  118,  116,  116,  116,  116,
      116,  119,  116,  117,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  118,
      116,  116,  116,  116,  116,  119,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,

      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,    0,  116,  116,  116
    } ;

static yyconst short int yy_nxt[347] =
    {   0,
        8,    9,   10,    8,   11,   12,   13,    8,    8,    8,
        8,   14,    8,    8,    8,    8,   15,   16,   17,    8,
       18,   19,    8,    8,   20,    8,   21,   22,   23,   24,
        8,    8,    8,   25,   26,   27,    8,    8,    8,   28,
       29,    8,   30,   30,   31,   32,   33,    8,    9,   10,
        8,   11,   34,   35,    8,    8,    8,    8,   14,   36,
       36,   36,   36,    8,   37,    8,    8,    8,   36,   36,
       36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
       36,   36,   36,   36,   36,   36,   28,   29,   36,   36,
       36,   31,   32,   33,    8,    9,   10,   38,   11,   12,

       13,    8,   39,    8,   40,   14,   41,   41,   41,   41,
        8,    8,    8,    8,    8,   42,   42,   42,   42,   42,
       42,   42,   42,   42,   42,   42,   42,   42,   42,   42,
       42,   42,   42,   28,   29,    8,   42,   42,   31,   32,
       33,   59,   59,   59,   59,   61,   66,   62,   62,   62,
       62,   63,   63,   63,   63,  115,   93,  114,   64,  113,
       62,   62,   62,   62,   59,   59,   59,   59,  105,  106,
       59,   59,   59,   65,   63,   63,   63,   63,  112,  111,
      110,   64,  109,   62,   62,   62,   62,   63,   63,   63,
       63,   65,  108,   59,   59,   59,   65,   98,   98,  107,

       65,  104,   76,   76,   76,   76,   77,  102,  101,  100,
       78,   78,   78,   78,   65,   65,   99,   97,   65,   76,
       76,   76,   76,   78,   78,   78,   78,   78,   78,   78,
       78,   96,   65,   65,  103,  103,  103,  103,  103,  103,
      103,  103,   95,   94,   93,   92,   91,   90,   89,   88,
       65,   87,   86,   85,   84,   83,   82,   81,   80,   79,
       75,   74,   73,  103,  103,  103,   72,  103,  103,  103,
       44,   44,   44,   60,   60,   71,   70,   69,   68,   67,
       45,   43,   58,   57,   56,   55,   54,   53,   52,   51,
       50,   49,   48,   47,   46,   45,   43,  116,    7,  116,

      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116
    } ;

static yyconst short int yy_chk[347] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    5,    5,    5,    5,    5,    5,

        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,   30,   30,   30,   30,   39,  119,   39,   39,   39,
       39,   40,   40,   40,   40,  113,   93,  112,   41,  109,
       41,   41,   41,   41,   59,   59,   59,   59,  100,  100,
       30,   30,   30,   41,   61,   61,   61,   61,  108,  106,
      105,   62,  104,   62,   62,   62,   62,   63,   63,   63,
       63,   41,  102,   59,   59,   59,   62,   93,   93,  101,

       63,   99,   64,   64,   64,   64,   65,   97,   96,   95,
       65,   65,   65,   65,   62,   64,   94,   92,   63,   76,
       76,   76,   76,   77,   77,   77,   77,   78,   78,   78,
       78,   91,   76,   64,   98,   98,   98,   98,  103,  103,
      103,  103,   90,   89,   87,   86,   85,   83,   82,   81,
       76,   79,   74,   73,   72,   71,   70,   69,   68,   67,
       58,   57,   56,   98,   98,   98,   55,  103,  103,  103,
      117,  117,  117,  118,  118,   54,   53,   52,   51,   50,
       44,   43,   27,   26,   25,   24,   23,   22,   21,   20,
       19,   18,   17,   15,   14,   11,    9,    7,  116,  116,

      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
      116,  116,  116,  116,  116,  116
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
/* #line 1 "nidrgen.l" */
#define INITIAL 0
/* #line 2 "nidrgen.l" */
/*********************************************************************
Copyright 2008 Sandia Corporation.  Under the terms of Contract
DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government
retains certain rights in this software.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

* Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

* Neither the name of Sandia Corporation nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
***********************************************************************/

#include <ctype.h>
#include <math.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "nidr.h"	/* for KeyWordKind */

#ifndef DMBLK_GULP
#define DMBLK_GULP 1024
#endif
#ifndef DMLBK_SGULP
#define DMBLK_SGULP 16000
#endif
#ifndef MBLK_GULP
#define MBLK_GULP 8191
#endif
#ifndef KWSTACKLEN
#define KWSTACKLEN 100	/*should be overkill*/
#endif
#ifndef DEFTAGLEN
#define DEFTAGLEN 2048	/* should be overkill*/
#endif

 typedef union
YYSTYPE { char *s; } YYSTYPE;

 enum LastSeen {
	Saw_kwname	= 1,
	Saw_type	= 2,
	Saw_func	= 3,
	Saw_dflt	= 4,
	Saw_dfltname	= 5,
	Saw_lt		= 6,
	Saw_le		= 7,
	Saw_ge		= 8,
	Saw_gt		= 9,
	Saw_desc	= 10,
	Saw_group	= 11,
	Saw_tag		= 12,
	Saw_len		= 13
	};

 static const char *tokname[] = {
	"<bug>",
	"kwname",
	"type",
	"{funcspec}",
	":=",
	"#define name for :=",
	"<",
	"<=",
	">=",
	">",
	"DESC",
	"GROUP",
	"TAG",
	"LEN"
	};

 enum ParState {
	/* parstate values... */
	PPar_emtpy	= 0,
	PPar_starting	= 1,
	PPar_started	= 2,
	PPar_leftpar	= 3,
	Dupchecking	= 4,
	Dupchecked	= 5,
	Printing	= 6,
	KwStacked	= 7,
	Sorted		= 8,
	Leftput		= 9,
	Parchecked	= 10
	};

 /* values for lastseen also include single characters ( [ { } ] ) ; */

 /* enums to make constants visible to debuggers */
 enum {
	DMblk_gulp	= DMBLK_GULP,
	Dmblk_sgulp	= DMBLK_SGULP,
	Mblk_gulp	= MBLK_GULP,
	KW_stacklen	= KWSTACKLEN,
	Br_stacklen	= 2*KW_stacklen,
	DHTlen		= 997,
	DHTfactor	= 43,
	HTlen		= 127,
	KWPlen		= 32,
	KWOUTlen0	= 128 };

 typedef struct Defhash Defhash;
 typedef struct DefhashHead DefhashHead;
 typedef struct DefhashTab DefhashTab;
 typedef struct HashHead HashHead;
 typedef struct KWctx KWctx;
 typedef struct Mblk Mblk;
 typedef struct Taghash Taghash;
 typedef struct StrList StrList;

 struct
DefhashHead {
	DefhashHead *hnext, *thread;
	char *name;
	};

 struct
Defhash {
	DefhashHead hh;
	char *value;
	int qkeep;
	};

 struct
Taghash {
	DefhashHead hh;
	KWctx *kw;
	int uses;
	};

 struct
DefhashTab {
	DefhashHead *Tab[DHTlen];
	DefhashHead *lastdh;
	size_t nalloc;	/* size of new entry allocations in units of sizeof(void*) */
	int nent;
	};

 struct
Mblk {
	Mblk *next;
	void *stuff[Mblk_gulp];
	};

 struct
HashHead { HashHead *hnext, *hprev; };

 struct
StrList {
	HashHead h;
	StrList *next;
	char *val;
	int Lineno;
	int primary;
	};

 struct
KWctx {
	KWctx *next;
	StrList *names;	/* list of name and aliases */
	char *name1;	/* first name (for tagout) */
	KWctx *kw;	/* list of contained keywords */
	KWctx *master;	/* non-null ==> this is an alias; use master's kwkno */
	KWctx *pmaster;	/* used in computing paoff */
	KWctx *pparent;	/* paren parent, for ((...)|(...) ...) */
	KWctx *rparent;	/* "real" parent, for stuff inside ((...)) */
	StrList *funcs;	/* pre- and post order functions and (void*) args */
	char *Br_top;	/* Br_top when this keyword began */
	char *lb;	/* lower bound (if kind & KWKind_Lb is nonzero) */
	char *ub;	/* upper bound (if kind & KWKind_Ub is nonzero) */
	char *init;	/* initial value (if kind & KWKind_init is nonzero) and */
			/* kind & KWKind_Mask is 1 or 2 (KWKind_Int or KWKind_Real) */
	char *cinit;	/* initial value for STRING-valued keyword,	*/
			/* ==> (kind & (KWKind_Mask | KWKind_init))	*/
			/*	== (KWKind_Str | KWKind_init)		*/
	char *defname;	/* name of preprocessor token to be #defined */
	char *desc;
	char *group;
	char *tag;
	KWctx *len;	/* keyword giving array length */
	size_t dtnext;	/* for adjusting deftag when this keyword goes out of scope */
	size_t name1len;
	int alt;	/* alternative group number of this keyword */
	int kind;	/* kind of values for this keyword */
	int kno;	/* number of this keyword, for generating kw_n names */
	int kwkno;	/* number of this keyword's kw array (if any) */
	int kwknop;	/* if this is a pparent and has a pparent, kwkno for this and parents */
	int nalt;	/* number of alternative groups in contained keywords */
	int nfcn;	/* number of function and arg entries in funcs */
	int nkw;	/* number of contained keywords */
	int nreq;	/* number of required elements in contained keywords */
	int req;	/* required group for this keyword (0 if optional) */
	int parstate;	/* state in handling ((...)) */
	int altoffset;	/* for expand */
	int reqoffset;	/* for expand */
	int level;
	int objno;	/* for kwcomp2 */
	int agroup;	/* for GuiKeyWord */ /* deprecated */
	int paoff;	/* offset of primary keyword: replacement (?) for agroup */
	};

 static int lastagroup, lastobjno, nalias;

 Defhash *lastdef;
 DefhashTab DHTab, TagTab;
 FILE *mtagout, *tagin, *tagout;
 HashHead HTab[HTlen];
 KWctx KWbase, *lastkw, *lastkw1;
 KWctx *KWStack[KW_stacklen], **KWtop = KWStack;
 Mblk FirstMblk, *CurMblk = &FirstMblk;
 YYSTYPE yyval;
 char Br_stack[Br_stacklen], *Br_top = Br_stack;
 char deftag[DEFTAGLEN], *dtend = deftag + DEFTAGLEN - 2, *dtnext = deftag;
 char *infname, *lasttag, *progname, *specfile, *tagfname;
 int Lineno = 1, dfltgroup = 1, startwarn = 1, wantfuncs = 1;
 int brace, btype, dupnames, expand, guikeywds, ignoretags;
 int kwmult, lastkno, lastseen, missing, needcomma, nsquawk, or_mode, saweof;
 size_t mbavail = Mblk_gulp;
 void **mbnext = FirstMblk.stuff;
 static void Eat_comment(void);
 static void Keywd(char *);
 static void Saw_quote(void);

 /* Possible values for *Br_top:
 //	 0  ==> empty (for Br_stack[0] only)
 //	'(' ==> open paren seen, awaiting ')'
 //	'[' ==> open square bracket, awaiting ']'
 */

 static void
botch(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	fprintf(stderr, "\n%s:\n\tbotch on line %d", progname, Lineno);
	if (infname)
		fprintf(stderr, " of \"%s\"", infname);
	fprintf(stderr, ":\n\t");
	vfprintf(stderr, fmt, ap);
	fputs(".\n", stderr);
	va_end(ap);
	exit(1);
	}

 static void
squawk(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	fprintf(stderr, "\n%s: line %d", progname, Lineno);
	if (infname)
		fprintf(stderr, " of \"%s\"", infname);
	fprintf(stderr, ":\n\t");
	vfprintf(stderr, fmt, ap);
	fputs(".\n", stderr);
	va_end(ap);
	++nsquawk;
	}

 static void*
Malloc(size_t L, const char *where)
{
	void *rv = malloc(L);
	if (!rv)
		botch("malloc(%lu) failure in %s()", (unsigned long)L);
	return rv;
	}

 void
unexpected(const char *what)
{ botch("unexpected \"%s\"", what); }

 static void *
Alloc(size_t len)
{
	Mblk *mb;
	size_t L;
	void *rv;

	L = (len + sizeof(void*) - 1)/sizeof(void*);
	if (L >= Mblk_gulp)
		botch("Alloc(%lu) failure", (unsigned long)len);
	if (L > mbavail) {
		if (!(mb = CurMblk->next)) {
			mb = (Mblk*)Malloc(sizeof(Mblk), "Alloc");
			CurMblk->next = mb;
			}
		CurMblk = mb;
		mbavail = Mblk_gulp;
		mbnext = mb->stuff;
		mb->next = 0;
		memset(mbnext, 0, sizeof(mb->stuff));
		}
	rv = mbnext;
	mbnext += L;
	mbavail -= L;
	return rv;
	}

#if 0
 static void
Mblk_reset(void)
{
	CurMblk = FirstMblk;
	mbavail = Mblk_gulp;
	mbnext = FirstMblk.stuff;
	memset(mbnext, 0, sizeof(FirstMblk.stuff));
	}
#endif

 StrList *
new_StrList(const char *s, StrList *nxt)
{
	size_t L = strlen(s) + 1;
	StrList *rv = (StrList*)Alloc(sizeof(StrList) + L);
	strcpy(rv->val = (char*)(rv + 1), s);
	rv->next = nxt;
	rv->Lineno = Lineno;
	return rv;
	}

 static void
Alias(char *s)
{
	KWctx *kw;
	if (lastseen != Saw_kwname)
		botch("ALIAS out of place");
	kw = lastkw;
	for(s += 6; *s <= ' '; s++);
	kw->names = new_StrList(s, kw->names);
	++nalias;
	lastseen = Saw_kwname;
	}

 static void
reqchk(const char *a, const char *s)
{
	if (a)
		while(*a)
			if (*a++ == lastseen)
				return;
	botch("\"%s\" out of place", s);
	}

 static void
reqchk1(const char *a, const char *s)
{
	int c;

	if (*Br_top != *s) {
		if ((c = *Br_top)) {
			switch(c) {
			 case '[': c = ']'; break;
			 case '(': c = ')'; break;
			 default:  c = '?';
			 }
			botch("Missing '%c'", c);
			}
		else
			a = 0;
		}
	reqchk(a, s+1);
	}

 static void
Bar(void)
{
	static char allowed[] = { /*(*/ ')', Saw_kwname, Saw_type, 0 };
	reqchk(allowed, "|");
	lastseen = '|';
	lastkw = lastkw1 = 0;
	or_mode = 1;
	}

 static void
Lpar(void)
{
	KWctx *kw;
	int olastseen = lastseen;
	static char allowed[] = { '(', '[', '|', ']', ')', Saw_kwname, Saw_type, 0 };

	reqchk(allowed, "("/*)*/);
	lastseen = '('; /*)*/
	if (KWtop > KWStack) {
		kw = KWtop[0];
		if (or_mode && kw->parstate == PPar_leftpar && !kw->kw) {
			dtnext = deftag + kw->dtnext;
			--KWtop;
			Keywd(0);
			kw->pparent = KWtop[0];
			}
		else if (olastseen == '(' || olastseen == '[' /*])*/)
			Keywd(0);
		lastseen = '(' /*)*/;
		}
	if (++Br_top - Br_stack >= Br_stacklen)
		botch("Br_stack overflow");
	*Br_top = '('; /*)*/
	lastkw = lastkw1 = 0;
	}

 static void
Lsqb(void)
{
	static char allowed[] = { /*([*/ ']', ')', Saw_kwname, Saw_type, 0 };
	reqchk(allowed, "["/*]*/);
	if (++Br_top - Br_stack >= Br_stacklen)
		botch("Br_stack overflow");
	lastseen = *Br_top = '['; /*]*/
	lastkw = lastkw1 = 0;
	}

 static void
Rpar(void)
{
	static char allowed[] =  {/*[(*/ ')', ']', Saw_kwname, Saw_type, 0 };
	reqchk1(allowed, "()");
	if (KWtop <= KWStack)
		botch("bug: KW stack error");
	--Br_top;
	if (!KWtop[0]->kw && KWtop - KWStack > 2
	 && KWtop[-1]->parstate == PPar_starting)
		KWtop[-1]->Br_top = Br_top;
	--KWtop;
	lastseen = /*(*/ ')';
	lastkw = lastkw1 = 0;
	}

 static void
Rsqb(void)
{
	static char allowed[] = {/*(*/')', '[', ']', Saw_kwname, Saw_type, 0 };
	reqchk1(allowed, "[]");
	if (KWtop <= KWStack)
		botch("bug: KW stack error");
	--Br_top;
	--KWtop;
	lastseen = /*[*/ ']';
	lastkw = lastkw1 = 0;
	}

 static void
Lbrace(void)
{
	if (brace++ || (lastseen != Saw_kwname && lastseen != Saw_type))
		unexpected("{");
	lastseen = '{'; /*}}*/
	}

 static void
Rbrace(void)
{
	if (--brace || (lastseen != Saw_func && lastseen != ';'))
		/*{{*/unexpected("}");
	lastseen = Saw_type;
	}

 static void
Type(int n, char *s)
{
	if (lastseen != Saw_kwname || !lastkw)
		botch("type %s out of place", s);
	lastkw->kind |= n;
	lastkw = 0;
	lastseen = Saw_type;
	}

 static char *
def_name(char *s0)
{
	char *s;
	size_t L, L1;
	static char *slast, *snext;

	s = s0;
	while(*s++);
	L = s - s0;
	if (snext + L > slast) {
		snext = (char*)Malloc(L1 = Dmblk_sgulp + L, "def_name");
		slast = snext + L1;
		}
	strcpy(s = snext, s0);
	snext += L;
	return s;
	}

static void **DHHlast, **DHHnext;	/* Could be private to DHHlookup, but here */
					/* to make them visible to debuggers. */
 static DefhashHead *
DHHlookup(char *s0, DefhashTab *Htab, int add)
{
	DefhashHead *h, **hp;
	char *s;
	size_t L;
	unsigned int c, x;

	for(x = 0, s = s0; (c = *(unsigned char*)s); ++s)
		x += DHTfactor*x + c;
	x %= DHTlen;
	for(hp = &Htab->Tab[x]; (h = *hp); hp = &h->hnext) {
		if (!strcmp(s0, h->name))
			return h;
		}
	if (!add)
		return h;
	Htab->nent++;
	if (DHHnext + Htab->nalloc >= DHHlast) {
		DHHnext = (void**)Malloc(L = DMblk_gulp*sizeof(void*), "DHHlookup");
		DHHlast = DHHnext + DMblk_gulp;
		memset(DHHnext, 0, L);
		}
	*hp = h = (DefhashHead*)DHHnext;
	DHHnext += Htab->nalloc;
	h->name = def_name(s0);
	h->thread = Htab->lastdh;
	return Htab->lastdh = h;
	}

 static void
bothplaces(KWctx *kw, const char *name)
{ squawk("For %s, %s appears both in specfile and tagfile", kw->names->val, name); }

 static void
tagimport(KWctx *kw, KWctx *tw)
{
	typedef struct KWimport KWimport;
	struct KWimport { const char *name; size_t off; };
	static KWimport Imp[] = {
		{ "lower bound",	offsetof(KWctx,lb) },
		{ "upper bound",	offsetof(KWctx,ub) },
		{ "default (:= value)",	offsetof(KWctx,init) },
		{ "default (:= value)",	offsetof(KWctx,cinit) },
		{ "defname",		offsetof(KWctx,defname) },
		{ "DESC",		offsetof(KWctx,desc) },
		{ "GROUP",		offsetof(KWctx,group) },
		{ "LEN",		offsetof(KWctx,len) },
		{0}};
	KWimport *ki;
#define field(k,n) *(char**)((char*)k+n)
	for(ki = Imp; ki->name; ++ki) {
		if (field(tw,ki->off)) {
			if (field(kw,ki->off))
				bothplaces(kw, ki->name);
			else
				field(kw,ki->off) = field(tw,ki->off);
			}
		}
#undef field
	}

 static void
Keywd(char *s)
{
	KWctx *kw, *kw0, *kw1, *kw2, *kwm, **kwp;
	StrList *nam;
	Taghash *th;
	char *s1;
	int alt, i, req;
	size_t L, L1;
	static char allowed[] = { '(',')','[',']','|', Saw_kwname, Saw_type, 0 };

	if (tagin)
		botch("Inappropriate text \"%s\" in tagfile \"%s\"", s, tagfname);
	kw0 = kw1 = *KWtop;
	kwm = 0;
	if (!kw1->names && s) {
		switch(kw1->parstate) {
		  case PPar_emtpy:
			do {
				kw1->parstate = PPar_starting;
				kw1 = kw1->pparent;
				}
				while(kw1 && kw1->parstate == PPar_emtpy);
			kw1 = kw0->rparent;
			break;
		  case PPar_starting:
			if (or_mode)
				kw1 = kw0->rparent;
			else
				kw1->parstate = PPar_started;
			break;
		  }
		}
	if (or_mode && !kw1->kw && KWtop - KWStack > 1) {
		kw2 = KWtop[-1];
		if (!kw2->names && kw2->parstate == PPar_starting)
			kw2 = kw2->rparent;
		if (s)
			kw1->master = kwm = kw1;
		kw1 = kw2;
		}
	alt = req = 0;
	if (s) {
		kwp = KWStack + kw1->level + 1;
		if (kwp > KWtop)
			kwp = KWtop;
		while(kwp > KWStack) {
			kw2 = *kwp--;
			if (kw2->name1) {
				dtnext = deftag + kw2->dtnext;
				L = kw2->name1len;
				strcpy(dtnext-L, kw2->name1);
				break;
				}
			}
		alt = ++kw1->nalt;
		if (*Br_top != '['/*]*/ || Br_top == kw1->Br_top) {
			req = ++kw1->nreq;
			if (*Br_top == '(' /*)*/) /* allow [(...)|...] */
				for(s1 = Br_top; --s1 > kw1->Br_top; ) {
					if (*s1 != '(' /*)*/) {
						if (*s1 == '[' /*]*/) {
							--kw1->nreq;
							req = 0;
							}
						break;
						}
					}
			}
		if (or_mode) {
			alt = --kw1->nalt;
			if (req)
				req = --kw1->nreq;
			}
		if (lastseen)
			reqchk(allowed, s);
		or_mode = 0;
		}
	lastkw = lastkw1 = kw = (KWctx*) Alloc(sizeof(KWctx));
	if (!kw0->names)
		kw->pparent = kw0;
	if (s) {
		kw->names = nam = new_StrList(s,0);
		kw->name1 = nam->val;
		kw->name1len = L = strlen(s);
		for(kwp = KWtop; kwp > KWStack; --kwp) {
			kw2 = *kwp;
			if (kw2->names) {
				if (kwp < KWtop) {
					L1 = kw2->dtnext + L + 1;
					while(++kwp <= KWtop) {
						kw2 = *kwp;
						if (!kw2->name1) {
							kw2->name1 = kw->name1;
							kw2->name1len = L;
							kw2->dtnext = L1;
							}
						}
					}
				break;
				}
			}
		nam->primary = KWKind_primary;
		kw->next = kw1->kw;
		kw1->kw = kw;
		if (lastseen == '(' /*)*/)
			kw->parstate = PPar_leftpar;
		kw->agroup = lastagroup++;
		}
	else {
		kw->objno = ++lastobjno;
		if (!kw1->kw && (kw->rparent = kw1->rparent))
			kw1 = kw->rparent;
		else
			kw->rparent = kw1;
		alt = kw1->alt;
		req = kw1->req;
		}
	kw->alt = alt;
	kw->req = req;
	kw->Br_top = Br_top;
	kw->master = kwm;
	kw->level = KWtop - KWStack;
	if (lastseen == '(' || lastseen == '[' /*])*/ || KWtop == KWStack) {
		if (++KWtop - KWStack >= KW_stacklen)
			botch("KW stack overflow");
		*KWtop = kw;
		}
	lasttag = 0;
	if (s) {
		if (dtnext > deftag)
			*dtnext++ = '/';
		if (dtnext + L >= dtend)
			botch("deftag overflow");
		memcpy(dtnext, s, L);
		*(dtnext += L) = 0;
		if (tagout)
			fprintf(tagout, "TAG \"%s\"\n", deftag);
		if (tagfname) {
			if ((th = (Taghash*)DHHlookup(deftag, &TagTab, ignoretags))) {
				++th->uses;
				lasttag = th->hh.name;
				if (!ignoretags) {
					lastkw1->tag = lasttag;
					tagimport(lastkw1, th->kw);
					}
				}
			else if (mtagout)
				fprintf(mtagout, "TAG \"%s\" #missing\n", deftag);
			}
		}
	kw->dtnext = dtnext - deftag;
	if (lastseen == 0)
		kw->kind = kwmult;
	lastseen = Saw_kwname;
	}

 static void
kw_finish(int nextkind)
{
	if (*Br_top)
		botch("unmatched '%c'", *Br_top);
	if (KWtop - KWStack > 1)
		botch("bug: KW stack botch in kw_finish");
	KWtop = KWStack;
	dtnext = deftag;
	lastseen = 0;
	kwmult = nextkind;
	}

 static void
Fnc(char *s)
{
	KWctx *kw;

	if (!(kw = lastkw1))
		botch("misplaced {...}");
	if (++kw->nfcn > 4)
		botch("too many functions in {...}");
	kw->funcs = new_StrList(s, kw->funcs);
	lastseen = Saw_func;
	}

 static const char*
tname_adj(const char *tname, int what, int kbits)
{
	Uint k = lastkw1->kind;

	switch(what) {
	 case Saw_lt:
		if (k & KWKind_caneqUb)
			tname = "<=";
		break;
	 case Saw_le:
		if (k & KWKind_strictUb)
			tname = "<";
		break;
	 case Saw_ge:
		if (k & KWKind_strictLb)
			tname = ">";
		break;
	 case Saw_gt:
		if (k & KWKind_caneqLb)
			tname = ">=";
	 }
	return tname;
	}

 static void
Saw_tok(int what, int kbits)
{
	const char *tname;

	if ((lastseen == Saw_kwname || lastseen == Saw_type) && lastkw1) {
		if (lastkw1->kind & kbits) {
			tname = tokname[what];
			if (kbits & (KWKind_Lb | KWKind_Ub))
				tname = tname_adj(tname, what, kbits);
			botch("%s already seen for keyword %s",
				tname, lastkw1->names->val);
			}
		lastseen = what;
		}
	else
		unexpected(tokname[what]);
	}

 static void
Saw_stok(int what, size_t woff)
{
	if ((lastseen == Saw_kwname || lastseen == Saw_type) && lastkw1) {
		if (*(void**)((char*)lastkw1 + woff))
			botch("%s already seen for keyword %s",
				tokname[what], lastkw1->names->val);
		lastseen = what;
		}
	else
		unexpected(tokname[what]);
	}

 static KWctx *
lenfind(char *s)
{
	KWctx *kw, *kw0, **pkw;
	StrList *sl;

	kw0 = lastkw1;
	for(pkw = KWtop; pkw > KWStack; --pkw) {
		kw = *pkw;
		for(kw = kw->kw; kw; kw = kw->next) {
			for(sl = kw->names; sl; sl = sl->next)
				if (!strcmp(sl->val, s))
					return kw;
			}
		}
	return 0;
	}

 static void
alreadyseen(const char *what)
{
	squawk("%s already given for %s", what, lastkw1->names->val);
	}

 static int
Saw_name(char *s)
{
	KWctx *kw;
	Taghash *th;
	char *s1;
	static const char notfound[] =
		"keyword \"%s\" not found in this or an enclosing context";

	if (lastkw1) {
		switch(lastseen) {
		  case Saw_dflt:
			lastseen = Saw_dfltname;
			lastdef = (Defhash*)DHHlookup(s, &DHTab, 1);
			if (!lastkw1->defname)
				lastkw1->defname = def_name(s);
			else if (lastdef->value
				 && ((s1 = lastkw1->init) || (s1 = lastkw1->cinit))
				 && strcmp(s1, lastdef->value))
					squawk("Inconsistent definitions for %s: %s and %s\n",
						lastdef->hh.name, lastdef->value, s1);
			return 0;
		  case Saw_len:
			if (lastkw1->len) {
				alreadyseen("LEN");
				goto ret1;
				}
			kw = lenfind(s);
			if (!kw)
				squawk(notfound,s);
			else {
				if ((kw->kind & KWKind_Mask) != KWKind_Int)
					squawk("%s is not of type INTEGER", kw->names->val);
				lastkw1->len = kw;
				}
			goto ret1;
		  case Saw_group:
			if (lastkw1->group)
				alreadyseen("GROUP");
			else
				strcpy(lastkw1->group = (char*)Alloc(strlen(s)+1), s);
			goto ret1;
		  case Saw_tag:
			if (tagin)
				goto new_tag;
			if (lasttag) {
				alreadyseen("TAG");
				goto ret1;
				}
			if (!tagfname && !ignoretags) {
				squawk("TAG \"%s\" not found: no tag file given", s);
				goto ret1;
				}
			th = (Taghash*)DHHlookup(s, &TagTab, ignoretags);
			if (!th)
				squawk("TAG \"%s\" not found in tag file \"%s\"", s, tagfname);
			else {
				++th->uses;
				lasttag = th->hh.name;
				if (!ignoretags) {
					lastkw1->tag = lasttag;
					tagimport(lastkw1, th->kw);
					}
				}
 ret1:
			lastseen = Saw_type;
			return 1;
		  }
		}
	else if (tagin) {
 new_tag:
		th = (Taghash*)DHHlookup(s, &TagTab, 1);
		if (th->kw)
			squawk("Tag \"%s\" already seen in tagfile %s\n", s, tagfname);
		else
			th->kw = lastkw1 = (KWctx*) Alloc(sizeof(KWctx));
		goto ret1;
		}
	botch("unexpected name \"%s\"", s);
	return 0; /* not reached */
	}

 static void
boundalready(const char *what)
{
	squawk("%s bound already given for %s", what, lastkw1->names->val);
	}

 static void
set_lastdef(char *s, int qkeep)
{
	if (!lastdef->value) {
		lastdef->value = def_name(s);
		lastdef->qkeep = qkeep;
		}
	else if (strcmp(s, lastdef->value))
		squawk("Two := values for %s: %s and %s", lastdef->hh.name,
			lastdef->value, s);
	}

 static void
Saw_num(char *s)
{
	Defhash *ld;
	double x, xa;
	char *se, **sp;
	int k;
	static double b[3];

	static char allowed[] = { Saw_dflt, Saw_dfltname, Saw_lt, Saw_le, Saw_ge, Saw_gt, 0 };

	reqchk(allowed, "number");
	x = strtod(s,&se);
	if (*se)
		botch("invalid number: \"%s\"", s);
	ld = 0;
	switch(lastseen) {
		case Saw_dflt:
		case Saw_dfltname:
			sp = &lastkw1->init;
			lastkw1->kind |= KWKind_init;
			ld = lastdef;
			if ((lastkw1->kind & KWKind_Mask) == KWKind_Int)
				x = x >= 0. ? floor(x) : ceil(x);
			b[2] = x;
			if (lastkw1->lb && x < b[0])
				squawk("default value inconsistent with lower bound");
			if (lastkw1->ub && x > b[1])
				squawk("default value inconsistent with upper bound");
			break;
		case Saw_gt:
		case Saw_ge:
			if (lastkw1->lb) {
				boundalready("lower");
				goto ret;
				}
			if ((lastkw1->kind & KWKind_Mask) == KWKind_Int) {
				xa = ceil(x);
				if (xa > x) {
					if (btype == KWKind_strictLb)
						btype = KWKind_caneqLb;
					x = xa;
					}
				}
			sp = &lastkw1->lb;
			lastkw1->kind |= btype;
			b[0] = x;
			if (lastkw1->ub && x >= b[1])
				squawk("inconsistent bounds");
			if (lastkw1->init && x > b[2])
				squawk("lower bound inconsistent with default value");
			break;
		case Saw_le:
		case Saw_lt:
			if (lastkw1->ub) {
				boundalready("upper");
				goto ret;
				}
			if ((lastkw1->kind & KWKind_Mask) == KWKind_Int) {
				xa = floor(x);
				if (xa < x) {
					if (btype == KWKind_strictUb)
						btype = KWKind_caneqUb;
					x = xa;
					}
				}
			sp = &lastkw1->ub;
			lastkw1->kind |= btype;
			b[1] = x;
			if (lastkw1->lb && x <= b[0])
				squawk("inconsistent bounds");
			if (lastkw1->init && x < b[2])
				squawk("upper bound inconsistent with default value");
			break;
		default:
			unexpected(s);
		}
	k = lastkw1->kind & KWKind_Mask;
	if (k == KWKind_Void || k == KWKind_Str)
		squawk("%s cannot accept a %s value", lastkw1->names->val, tokname[lastseen]);
	else {
		strcpy(*sp = (char*)Alloc(strlen(s)+1), s);
		if (ld)
			set_lastdef(s, 0);
		}
 ret:
	lastseen = Saw_type;
	}

#define FNC 1
#define VAL 2

/* #line 1515 "nidrgen.c" */

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp = NULL, *yy_bp = NULL;
	register int yy_act;

/* #line 1039 "nidrgen.l" */


/* #line 1669 "nidrgen.c" */

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 117 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 299 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
/* #line 1041 "nidrgen.l" */
{ ++Lineno; }
	YY_BREAK
case 2:
YY_RULE_SETUP
/* #line 1042 "nidrgen.l" */
{}
	YY_BREAK
case 3:
YY_RULE_SETUP
/* #line 1043 "nidrgen.l" */
{ Alias(yytext); }
	YY_BREAK
case 4:
YY_RULE_SETUP
/* #line 1044 "nidrgen.l" */
{ Type(KWKind_Int, yytext); }
	YY_BREAK
case 5:
YY_RULE_SETUP
/* #line 1045 "nidrgen.l" */
{ Type(KWKind_Int | KWKind_List, yytext); }
	YY_BREAK
case 6:
YY_RULE_SETUP
/* #line 1046 "nidrgen.l" */
{ kw_finish(0); }
	YY_BREAK
case 7:
YY_RULE_SETUP
/* #line 1047 "nidrgen.l" */
{ kw_finish(KWKind_1); }
	YY_BREAK
case 8:
YY_RULE_SETUP
/* #line 1048 "nidrgen.l" */
{ kw_finish(KWKind_01); }
	YY_BREAK
case 9:
YY_RULE_SETUP
/* #line 1049 "nidrgen.l" */
{ kw_finish(KWKind_12); }
	YY_BREAK
case 10:
YY_RULE_SETUP
/* #line 1050 "nidrgen.l" */
{ Type(KWKind_Real, yytext); }
	YY_BREAK
case 11:
YY_RULE_SETUP
/* #line 1051 "nidrgen.l" */
{ Type(KWKind_Real | KWKind_List, yytext); }
	YY_BREAK
case 12:
YY_RULE_SETUP
/* #line 1052 "nidrgen.l" */
{ Type(KWKind_Str, yytext); }
	YY_BREAK
case 13:
YY_RULE_SETUP
/* #line 1053 "nidrgen.l" */
{ Type(KWKind_Str | KWKind_List, yytext); }
	YY_BREAK
case 14:
YY_RULE_SETUP
/* #line 1054 "nidrgen.l" */
{ Keywd(yytext); }
	YY_BREAK
case 15:
YY_RULE_SETUP
/* #line 1055 "nidrgen.l" */
{ kw_finish(0); }
	YY_BREAK
case 16:
YY_RULE_SETUP
/* #line 1056 "nidrgen.l" */
{ Saw_stok(Saw_desc, offsetof(KWctx,desc));	BEGIN VAL; }
	YY_BREAK
case 17:
YY_RULE_SETUP
/* #line 1057 "nidrgen.l" */
{ Saw_stok(Saw_tag, offsetof(KWctx,tag));	BEGIN VAL; }
	YY_BREAK
case 18:
YY_RULE_SETUP
/* #line 1058 "nidrgen.l" */
{ Saw_stok(Saw_group, offsetof(KWctx,group));	BEGIN VAL; }
	YY_BREAK
case 19:
YY_RULE_SETUP
/* #line 1059 "nidrgen.l" */
{ Saw_stok(Saw_len, offsetof(KWctx,len));
			  lastkw1->kind |= KWKind_Len1OK;		BEGIN VAL; }
	YY_BREAK
case 20:
YY_RULE_SETUP
/* #line 1061 "nidrgen.l" */
{ Saw_stok(Saw_len, offsetof(KWctx,len));	BEGIN VAL; }
	YY_BREAK
case 21:
YY_RULE_SETUP
/* #line 1062 "nidrgen.l" */
{ Saw_tok(Saw_dflt, KWKind_init); lastdef = 0;	BEGIN VAL; }
	YY_BREAK
case 22:
YY_RULE_SETUP
/* #line 1063 "nidrgen.l" */
{ Saw_tok(Saw_ge, KWKind_Lb); btype = KWKind_caneqLb;	BEGIN VAL; }
	YY_BREAK
case 23:
YY_RULE_SETUP
/* #line 1064 "nidrgen.l" */
{ Saw_tok(Saw_gt, KWKind_Lb); btype = KWKind_strictLb;	BEGIN VAL; }
	YY_BREAK
case 24:
YY_RULE_SETUP
/* #line 1065 "nidrgen.l" */
{ Saw_tok(Saw_le, KWKind_Ub); btype = KWKind_caneqUb;	BEGIN VAL; }
	YY_BREAK
case 25:
YY_RULE_SETUP
/* #line 1066 "nidrgen.l" */
{ Saw_tok(Saw_lt, KWKind_Ub); btype = KWKind_strictUb;	BEGIN VAL; }
	YY_BREAK
case 26:
YY_RULE_SETUP
/* #line 1067 "nidrgen.l" */
{ if (Saw_name(yytext))	BEGIN INITIAL; }
	YY_BREAK
case 27:
YY_RULE_SETUP
/* #line 1068 "nidrgen.l" */
{ Saw_num(yytext);	BEGIN INITIAL; }
	YY_BREAK
case 28:
YY_RULE_SETUP
/* #line 1069 "nidrgen.l" */
{ Saw_quote();		BEGIN INITIAL; }
	YY_BREAK
case 29:
YY_RULE_SETUP
/* #line 1071 "nidrgen.l" */
{ Lbrace(); BEGIN FNC; }
	YY_BREAK
case 30:
YY_RULE_SETUP
/* #line 1072 "nidrgen.l" */
{ Rbrace(); BEGIN INITIAL; }
	YY_BREAK
case 31:
YY_RULE_SETUP
/* #line 1073 "nidrgen.l" */
{ Bar(); }
	YY_BREAK
case 32:
YY_RULE_SETUP
/* #line 1074 "nidrgen.l" */
{ Lpar(); }
	YY_BREAK
case 33:
YY_RULE_SETUP
/* #line 1075 "nidrgen.l" */
{ Rpar(); }
	YY_BREAK
case 34:
YY_RULE_SETUP
/* #line 1076 "nidrgen.l" */
{ Lsqb(); }
	YY_BREAK
case 35:
YY_RULE_SETUP
/* #line 1077 "nidrgen.l" */
{ Rsqb(); }
	YY_BREAK
case 36:
YY_RULE_SETUP
/* #line 1078 "nidrgen.l" */
{ Fnc(yytext); }
	YY_BREAK
case 37:
YY_RULE_SETUP
/* #line 1079 "nidrgen.l" */
{}
	YY_BREAK
case 38:
YY_RULE_SETUP
/* #line 1080 "nidrgen.l" */
{++Lineno;}
	YY_BREAK
case 39:
YY_RULE_SETUP
/* #line 1081 "nidrgen.l" */
{ Eat_comment(); }
	YY_BREAK
case 40:
YY_RULE_SETUP
/* #line 1082 "nidrgen.l" */
{ botch("\"%s\" unexpected", yytext); }
	YY_BREAK
case 41:
YY_RULE_SETUP
/* #line 1084 "nidrgen.l" */
ECHO;
	YY_BREAK
/* #line 1958 "nidrgen.c" */
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(FNC):
case YY_STATE_EOF(VAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 117 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 117 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 116);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}
#endif /* YY_NO_INPUT */

#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}



#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
/* #line 1084 "nidrgen.l" */


 static void
cantopen(char *what)
{ fprintf(stderr, "%s: cannot open \"%s\"\n", progname, what); }

 int
yywrap(void)
{
	if (tagin) {
		if (tagin != stdin)
			fclose(tagin);
		tagin = 0;
		Lineno = 1;
		saweof = 1;
		if (*specfile == '-' && !specfile[1]) {
			yyin = stdin;
			infname = 0;
			return 0;
			}
		if ((yyin = fopen(infname = specfile, "r")))
			return 0;
		cantopen(specfile);
		}
	return 1;
	}

 static void
Eat_comment(void)
{
	int c;

	for(;;) {
		c = input();
 c_check:
		if (c == EOF)
			botch("EOF within /* comment */");
		if (c == '*') {
			c = input();
			if (c == '/')
				return;
			goto c_check;
			}
		if (c == '\n')
			++Lineno;
		}
	}

 static void
Saw_quote(void)
{
	char buf[1024];
	char *b, *b0, *be;
	int c, c0;
	size_t L, L0, L1;
	static char escname[32];
	static char esetup[] = "\aa\bb\ff\nn\rr\tt\vv";
	static char hexdig[16] = "0123456789abcdef";

	if (!escname['\a'])
		for(b = esetup; *b; b += 2)
			escname[*b] = b[1];	/* assuming ASCII */
	b0 = b = buf;
	L = sizeof(buf);
	be = b + L - 3;	/* allow room for /xhh */
	c0 = 0;
	saweof = 0;
	for(;;) {
		c = input();
		if (c == EOF)
			botch("EOF within quoted string");
		if (b >= be) {
			L1 = b - b0;
			L0 = L;
			L <<= 1;
			be = (char*)Malloc(L, "Saw_quote");
			memcpy(be, b0, L1);
			if (b0 != buf)
				free(b0);
			b0 = be;
			b = b0 + L1;
			be = b0 + L - 3;
			}
		if (c < ' ') {
			*b++ = '\\';
			if (escname[c]) {
				if (c == '\n')
					++Lineno;
				c = escname[c];
				}
			else {
				*b++ = 'x';
				*b++ = '0' + (c >> 4);
				c = hexdig[c & 0xf];
				}
			}
		*b++ = c;
		if (c0 == '\\')
			c0 = 0;
		else {
			c0 = c;
			if (c == '"') {
				while((c = input()) <= ' ') {
					if (c == EOF) {
						c = ';';
						break;
						}
					if (c == '\n')
						++Lineno;
					}
				if (c == '"' && !saweof) {
					--b;
					continue;
					}
				unput(c);
				break;
				}
			}
		}
	b[-1] = 0;	/* replacing " */
	if (lastseen == Saw_tag) {
		if (saweof) /* kludge around poor flex design */ {
			tagin = stdin;
			Saw_name(b0);
			tagin = 0;
			}
		else
			Saw_name(b0);
		}
	else {
		L = b - b0;
		be = (char*)Alloc(L);
		memcpy(be, b0, L);
		switch(lastseen) {
		  case Saw_dflt:
		  case Saw_dfltname:
			if ((lastkw1->kind & KWKind_Mask) != KWKind_Str)
				botch("%s cannot have a string-valued := value",
					lastkw1->names->val);
			lastkw1->cinit = be;
			if (lastdef)
				set_lastdef(b0, 1);
			break;
		  case Saw_desc:
			lastkw1->desc = be;
			break;
		  case Saw_group:
			lastkw1->group = be;
			break;
		  default:
			unexpected("string");
		  }
		}
	if (b0 != buf)
		free(b0);
	lastseen = Saw_type;
	}

 static int
usage(int rc)
{
	fprintf(rc ? stderr : stdout,
	"Usage: %s [options] specfile [tagfile [defs_out [keywds_out]]]\n\
	where the last two are output files, \".\" means \"omit\", and \"-\"\n\
	means write to stdout.  Missing trailing arguments are not read\n\
	or written, except that if all outputs are missing, \". -\" is assumed.\n\
	Options may modify this behavior.\noptions:\n\
	-D		{ just write definitions to stdout }\n\
	-d		{ suppress check for ambiguity from duplicate keywords }\n\
	-e		{ expand ((...)) for debugging }\n\
	-f		{ omit functions, i.e., {...} with -p; without -p,\n\
			  supply NULL function pointers }\n\
	-G		{ for keywords with a TAG but not GROUP, do not assume\n\
			  that implictly GROUP == TAG }\n\
	-g		{ write GuiKeyWord rather than KeyWord header;\n\
			  with -p, include GUI details: TAG, DESC, GROUP, LEN }\n\
	-h headername	{ Specify header file(s), in addition to nidr.h;\n\
			  several -h options can be given;\n\
			  default = -h- ==> no headers }\n\
	-m mtagfile	{ write to mtagfile tags not found in tagfile (and quit) }\n\
	-n namespname	{ assume namespace namespname;\n\
			  default = -n Dakota\n\
			  -n- ==> no namespace }\n\
	-p[w]		{ pretty-print rather than produce KeyWord header;\n\
			  add w spaces (default 2) for each nested context. }\n\
	-s[w]		{ like -p[w], but sort the keywords }\n\
	-T outtagfile	{ write dummy tagfile to outtagfile (and quit) }\n\
	-t		{ ignore TAG fields if tagfile is not given }\n\
	-w		{ cancel warn mode: do not report (on stderr)\n\
			  the number of implicitly named start routines;\n\
			  still flag their names  with /*!!*/ }\n",
		progname);
	return rc;
	}

 static StrList *
reverse(StrList **x)
{
	StrList *s, *t, *u;

	t = 0;
	for(s = *x; s; s = u) {
		u = s->next;
		s->next = t;
		t = s;
		}
	return *x = t;
	}

 static int
kwcomp(const void *a, const void *b)
{
	return strcmp((*(const KWctx**)a)->names->val, (*(const KWctx**)b)->names->val);
	}

 static KWctx *
kwsort(KWctx *kw0)
{
	/* Sort keywords after expanding kw list with aliases; compute nkw, */
	/* including aliases. */

	KWctx *kw, *kw1, *kw2, *kwm, **x, **x0, **xe, *x00[512];
	StrList *dname, *minname, *nam, **pmin, **pnam;
	char *descsave, *groupsave;
	int agadj, nk;
	size_t L, nkw, nkwa, onkwa;

	reverse(&kw0->funcs);
	nkw = nkwa = 0;
	for(kw = kw0->kw; kw; kw = kw->next) {
		++nkw;
		pmin = &kw->names;
		minname = *pmin;
		pnam = &minname->next;
		onkwa = nkwa;
		while((nam = *pnam)) {
			dname = nam;
			++nkwa;
			if (strcmp(nam->val, minname->val) < 0) {
				pmin = pnam;
				minname = nam;
				}
			pnam = &nam->next;
			}
		agadj = 2*kw->agroup;
		kw->agroup = agadj + 1;
		if (nkwa > onkwa) {
			*pmin = minname->next;
			minname->next = kw->names;
			nam = kw->names = minname;
			nk = kw->kno;	/* ALias() made room for nk use below */
			descsave = kw->desc;
			groupsave = kw->group;
			if (dname != minname) {
				kw->desc = kw->group = 0;
				kw->agroup = agadj;
				}
			kwm = kw;
			kw = kw2 = 0;
			if (nam->primary)
				kw2 = kwm;
			while((nam = nam->next)) {
				kw1 = (KWctx*)Alloc(sizeof(KWctx));
				if (!kw)
					kw = kw1;	/* so kw->next is right */
				kw1->next = kwm->next;
				kwm->next = kw1;
				kw1->names = nam;
				kw1->master = kwm;
				kw1->kind = kwm->kind;
				kw1->kno = ++nk;
				kw1->agroup = agadj;
				if (nam == dname) {
					kw1->desc = descsave;
					kw1->group = groupsave;
					kw1->agroup = agadj + 1;
					}
				if (nam->primary)
					kw2 = kw1;
				}
			for(kw1 = kwm;; kw1 = kw1->next) {
				if (kw1 != kw2)
					kw1->pmaster = kw2;
				if (kw1 == kw)
					break;
				}
			}
		}
	kw0->nkw = (int)(nkw += nkwa);
	if (nkw <= 1)
		return kw0->kw;
	x0 = x00;
	if (nkw > sizeof(x00)/sizeof(x00[0]))
		x0 = (KWctx**)Malloc(L = nkw*sizeof(KWctx*), "kwsort");
	for(x = x0, kw = kw0->kw; kw; kw = kw->next)
		*x++ = kw;
	qsort(x0, nkw, sizeof(KWctx*), kwcomp);
	for(xe = x - 1, x = x0; x < xe; ++x) {
		if (!strcmp(x[0]->names->val, x[1]->names->val)) {
			fprintf(stderr, "%s: duplicate appearance of \"%s\"\n",
				progname, x[0]->names->val);
			++dupnames;
			}
		x[0]->next = x[1];
		}
	x[0]->next = 0;
	for(x = x0, ++xe; x < xe; ++x)
		(*x)->paoff = x - x0;
	for(x = x0; x < xe; ++x)
		if ((kw1 = (kw = *x)->pmaster))
			kw->paoff = kw1->paoff - kw->paoff;
	for(x = x0; x < xe; ++x)
		if (!(kw = *x)->pmaster)
			kw->paoff = 0;
	kw0->kw = kw = x0[0];
	if (x0 != x00)
		free(x0);
	return kw;
	}

 static int
alphanum(char *s)
{
	for(; *s; ++s)
		if (!isalnum(*s))
			return 0;
	return 1;
	}

 typedef struct Zbuf Zbuf;
 struct
Zbuf {
	char buf[80];	/* overkill */
	char *b;
	};

 static void
iput(int i, Zbuf *z)
{
	char *s;

	if (i == 0) {
		s = z->b;
		*s++ = ',';
		*s++ = '0';
		z->b = s;
		}
	else {
		if (z->b > z->buf) {
			*z->b = 0;
			printf(z->b = z->buf);
			}
		printf(",%d", i);
		}
	}

 static void
nput(char *s, Zbuf *z)
{
	char *fmt, *s1;

	if (!s || (strtod(s,&s1) == 0. && !*s1)) {
		s = z->b;
		*s++ = ',';
		*s++ = '0';
		*s++ = '.';
		z->b = s;
		}
	else {
		fmt = ",%s.";
		for(s1 = s; *s1; ++s1)
			switch(*s1) {
				case '.':
				case 'e':
				case 'E':
					fmt = ",%s";
					goto have_fmt;
				}
 have_fmt:
		if (z->b > z->buf) {
			*z->b = 0;
			printf(z->b = z->buf);
			}
		printf(fmt, s);
		}
	}

 static void
sput(char *s, Zbuf *z)
{
	if (!s) {
		s = z->b;
		*s++ = ',';
		*s++ = '0';
		z->b = s;
		}
	else {
		if (z->b > z->buf) {
			*z->b = 0;
			printf(z->b = z->buf);
			}
		printf(",\"%s\"", s);
		}
	}

 static void
kwout(KWctx *kw, KWctx **kwtop)
{
	KWctx *kw0, *kw1, *kw2, *kwm, **kws, **x, *x0[KWOUTlen0];
	StrList *S;
	Zbuf z;
	char *fmt, *s;
	int aoff, k, i, m, m1, n, roff, sentinnel;

	if (expand && !kw->names)
		return;
	if (needcomma) {
		printf(",\n");
		needcomma = 0;
		}
	kw1 = kw->kw;
	n = 0;
	if (kw->names) {
		kw0 = kw1;
		if (kw->parstate != KwStacked)
			for(kw2 = kw->pparent; kw2; kw2 = kw2->pparent) {
				kw2->next = kw1;
				kw1 = kw2;
				++n;
				}
		if (!kw0) {
			if (!--n) {
				kw->nkw = kw1->nkw;
				if (kw1->kwkno) {
					kw->kwkno = kw1->kwkno;
					return;
					}
				kw->kwkno = lastkno + 1;
				kw = kw1;
				kw1 = kw->kw;
				}
			else {
				kw2 = kw->pparent;
				if (kw2->kwknop) {
					kw->kwkno = kw2->kwknop;
					return;
					}
				kw2->kwknop = lastkno + 1;
				kw1 = kw2;
				while((kw2 = kw2->pparent)) {
					kw2->next = kw1;
					kw1 = kw2;
					}
				}
			}
		}
	for(m = 0, kw0 = kw1; kw0; kw0 = kw0->next)
		++m;
	if (expand)
		for(kw0 = kw1; kw0 && !kw0->names; kw0 = kw0->next)
			for(kw2 = kw0->kw; kw2; kw2 = kw2->next)
				++m;
	x = x0;
	if (m > KWOUTlen0)
		x = (KWctx**)Malloc(m*sizeof(KWctx*), "kwout");
	m = 0;
	kw0 = kw1;
	if (expand) {
		aoff = kw->nalt;
		roff = kw->nreq;
		for(; kw0 && !kw0->names; kw0 = kw0->next) {
			for(kw2 = kw0->kw; kw2; kw2 = kw2->next) {
				kw2->altoffset = aoff;
				kw2->reqoffset = roff;
				x[m++] = kw2;
				}
			aoff += kw0->nalt;
			roff += kw0->nreq;
			}
		kw->nalt = aoff;
		kw->nreq = roff;
		}
	for(; kw0; kw0 = kw0->next)
		x[m++] = kw0;
	sentinnel = 0;
	if (expand) {
		kw->nkw = m;
		qsort(x, m, sizeof(KWctx*), kwcomp);
		for(i = 1; i < m; ++i)
			if (!strcmp(x[i-1]->names->val, x[i]->names->val)) {
				fprintf(stderr, "%s: duplicate appearance of \"%s\"\n",
					progname, x[i]->names->val);
				++dupnames;
				}
		}
	else if (kw->nkw == 0)
		sentinnel = 1;
	m1 = m + sentinnel;
	printf("\tkw_%d[%d] = {\n", kw->kwkno = ++lastkno, m1);
	needcomma = 1;
	for(i = 0; i < m;) {
		kw1 = x[i++];
		if (!(kwm = kw1->master))
			kwm = kw1;
		fputs("\t\t{", stdout);
		z.b = z.buf;
		if (kw1->names) {
			k = kw1->kind | kw1->names->primary;
			printf(k < 16
				? "\"%s\",%d"
				: "\"%s\",0x%x", kw1->names->val, k);
			iput(kwm->nkw, &z);
			iput(kwm->alt + kwm->altoffset, &z);
			iput(kwm->req + kwm->reqoffset, &z);
			}
		else {
			printf("0,0");
			iput(kwm->nkw, &z);
			iput(0, &z);
			iput(0, &z);
			}
		if (guikeywds)
			iput(kw1->agroup, &z);
		if ((n = kwm->kwkno)) {
			if (z.b > z.buf) {
				*z.b = 0;
				printf(z.b = z.buf);
				}
			printf(",kw_%d", n);
			}
		else
			iput(0, &z);
		nput(kw1->lb, &z);
		nput(kw1->ub, &z);
		if (guikeywds) {
			nput(kw1->init, &z);
			sput(kw1->cinit, &z);
			sput(kw1->desc, &z);
			if (!(s = kw1->group) && dfltgroup)
				s = kw1->tag;
			sput(s, &z);
			if (kwm->len)
				sput(kwm->len->names->val, &z);
			goto nofuncs;
			}
		iput(kw1->paoff, &z);
		if ((S = kw1->funcs)) {
			if (z.b > z.buf) {
				*z.b = 0;
				printf(z.b = z.buf);
				}
			if (!kw1->kw) {
				reverse(&kw1->funcs);
				S = kw1->funcs;
				}
			goto funcput;
			}
		if ((S = kwm->funcs)) {
 funcput:
			if (S->next || strcmp(S->val,"0")) {
				if (z.b > z.buf) {
					*z.b = 0;
					printf(z.b = z.buf);
					}
				if (!wantfuncs)
					printf(",dummystart");
				else for(n = 0; S; S = S->next, ++n) {
					s = S->val;
					if (!(n & 1) || !strcmp(s,"0"))
						fmt = ",%s";
					else if (alphanum(s))
						fmt = ",(void*)%s";
					else
						fmt = ",(void*)(%s)";
					printf(fmt, s);
					}
				}
			}
		else if (kwm->names) {
			++missing;
			printf(",/*!!*/");
			for(kws = KWStack; ++kws < kwtop; ) {
				if (!(kw2 = *kws)->names)
					kw2 = kw2->rparent;
				printf("%s_", kw2->names->val);
				}
			printf("%s_start", kwm->names->val);
			}
 nofuncs:
		printf("}%s\n", i < m1 ? "," : "");
		}
	if (sentinnel)
		fputs("\t\t{\"\"}\n", stdout);
	printf("\t\t}");
	if (x != x0)
		free(x);
	}

 static void
hashclear(KWctx *kw)
{
	StrList *sl;

	kw->parstate = Dupchecked;
	for(kw = kw->kw; kw; kw = kw->next)
		for(sl = kw->names; sl; sl = sl->next) {
			sl->h.hnext->hprev = sl->h.hprev;
			sl->h.hprev->hnext = sl->h.hnext;
			sl->h.hprev = sl->h.hnext = 0;
			}
	}

 static void
dupfound(HashHead *h0, StrList *sl, StrList *sl1)
{
	StrList *sl2, *sl3;

	++dupnames;
	for(sl2 = sl1; sl2->h.hnext != h0; sl2 = sl3) {
		sl3 = (StrList*)sl2->h.hnext;
		if (strcmp(sl->val, sl3->val))
			break;
		}
	fprintf(stderr, "Warning: \"%s\" on line %d also appears on line%s %d",
		sl->val, sl->Lineno, "s" + (sl2 == sl1), sl1->Lineno);
	while(sl1 != sl2) {
		sl1 = (StrList*)sl1->h.hnext;
		fprintf(stderr, ", %d", sl1->Lineno);
		}
	fputs(".\n", stderr);
	}

 static KWctx **
hashadd(KWctx *kw, KWctx **kwtop)
{
	HashHead *h, *h0;
	KWctx *kw1;
	StrList *sl, *sl1;
	char *s;
	int n;
	unsigned int c, x;

	kw->parstate = Dupchecking;
	for(kw1 = kw->kw; kw1; kw1 = kw1->next)
		for(sl = kw1->names; sl; sl = sl->next) {
			x = 0;
			s = sl->val;
			while((c = *(unsigned char*)s++))
				x = 43*x + c - ' ';
			h0 = &HTab[x % HTlen];
			for(h = h0->hnext; h != h0; h = h->hnext) {
				sl1 = (StrList*)h;
				n = strcmp(sl->val, sl1->val);
				if (n <= 0) {
					if (n == 0)
						dupfound(h0,sl,sl1);
					break;
					}
				}
			sl->h.hnext = h;
			h->hprev = (sl->h.hprev = h->hprev)->hnext = (HashHead *)sl;
			}
	if ((kw1 = kw->kw))
		*++kwtop = kw1;
	return kwtop;
	}

 static void
dup_check(void)
{
	HashHead *h, *he;
	KWctx *kw, *kw1, *kw2, **kwtop, **kwbot, *plist;
	int lev;

	for(h = HTab, he = h + HTlen; h < he; ++h)
		h->hnext = h->hprev = h;
	plist = 0;
	kwtop = kwbot = KWStack;
	*kwtop = &KWbase;
	for(;;) {
		kw = *kwtop;
		lev = kw->level;
		while(plist && plist->level >= lev) {
			hashclear(plist);
			plist = plist->next;
			}
		if (kw->parstate == Dupchecking) {
			hashclear(kw);
			if ((*kwtop = kw->next))
				continue;
			if (kwtop <= kwbot)
				break;
			--kwtop;
			continue;
			}
		if ((kw1 = kw->pparent) && kw1->parstate != Dupchecking) {
			for(kw2 = kw1; plist && kw2; plist = plist->next) {
				while(kw2->level > plist->level && (kw2 = kw2->pparent));
				if (kw2 != plist)
					break;
				hashclear(plist);
				}
			kw2 = 0;
			do {
				if (kw1->kw) {
					kw1->next = kw2;
					kw2 = kw1;
					}
				}
				while((kw1 = kw1->pparent) && kw1->parstate != Dupchecking);
			while(kw2) {
				kwtop = hashadd(kw2, kwtop);
				kw1 = kw2;
				kw2 = kw2->next;
				kw1->next = plist;
				plist = kw1;
				}
			}
		kwtop = hashadd(kw, kwtop);
		}
	}

 static void
prkwname(KWctx *kw, const char *suf, int needrev)
{
	int k;
	StrList *S;
	static const char *kname[] = { "BUG", "INTEGER", "REAL", "STRING" };

	if (needrev)
		reverse(&kw->names);
	S = kw->names;
	printf("%s", S->val);
	while((S = S->next))
		printf(" ALIAS %s", S->val);
	if ((k = kw->kind & KWKind_Mask)) {
		printf(" %s", kname[k]);
		if (kw->kind & KWKind_List)
			printf("LIST");
		}
	if (kw->lb)
		printf(" %s %s", kw->kind & KWKind_strictLb ? ">" : ">=", kw->lb);
	if (kw->ub)
		printf(" %s %s", kw->kind & KWKind_strictUb ? "<" : "<=", kw->ub);
	if (kw->defname && wantfuncs) {
		if (kw->init)
			printf(" := %s %s", kw->defname, kw->init);
		else if (kw->cinit)
			printf(" := %s \"%s\"", kw->defname, kw->cinit);
		}
	else {
		if (kw->init)
			printf(" := %s", kw->init);
		else if (kw->cinit)
			printf(" := \"%s\"", kw->cinit);
		}
	if (!wantfuncs)
		goto sufchk;
	if (kw->tag)
		printf(ignoretags ? " TAG \"%s\"" : " /*TAG \"%s\"*/", kw->tag);
	if (kw->funcs) {
		fputs(" {", stdout);
		reverse(&kw->funcs);
		for(S = kw->funcs;;) {
			fputs(S->val, stdout);
			if (!(S = S->next))
				break;
			putchar(',');
			}
		putchar('}');
		}
	if (kw->len)
		printf(" LEN %s", kw->len->names->val);
	if (kw->group)
		printf(" GROUP \"%s\"", kw->group);
	if (kw->desc)
		printf(" DESC \"%s\"", kw->desc);
 sufchk:
	if (suf)
		fputs(suf, stdout);
	if (needrev == 2)
		reverse(&kw->names);
	}

 static KWctx *
kwrev(KWctx **pkw)
{
	KWctx *kw, *kw0, *kw1;
	kw1 = *pkw;
	for(kw0 = 0; (kw = kw1); kw0 = kw) {
		kw1 = kw->next;
		kw->next = kw0;
		}
	return *pkw = kw0;
	}

 static void
paradj(int needrev)
{
	KWctx *kw, *kw1, **kwp, **kwtop, **kwbot;

	kwtop = kwbot = KWStack;
	*kwtop = &KWbase;
	if (needrev)
		kwrev(kwtop);
	for(;; --kwtop) {
		for(kw = *kwtop; kw; kw = kw->next) {
 top:
			if (needrev && (kw1 = kw->kw) && kw1->next)
				kwrev(&kw->kw);
			if ((kw1 = kw->pparent) && kw1->parstate != Parchecked) {
				kwp = &kw->pparent;
				for(;;) {
					if (kw1->kw) {
						*kwtop++ = kw1;
						kw1->parstate = Parchecked;
						*kwp = kw1;
						kwp = &kw1->pparent;
						}
					if (!(kw1 = *kwp = kw1->pparent)
					 || kw1->parstate == Parchecked)
						break;
					}
				}
			if (kw->kw) {
				if ((*kwtop = kw->next))
					++kwtop;
				kw = kw->kw;
				goto top;
				}
			}
		if (kwtop <= kwbot)
			break;
		}
	}

 static KWctx *
masteradj(KWctx *kw)
{
	/* to help print (nm1 | nm2 foo goo), make nm2 "master" */
	KWctx *kw1, *kw2, *kw3, *kwm, *rv;

	for(kw1 = kw, kw3 = 0; kw1; kw1 = kw1->next) {
		if ((kw2 = kw1->master))
			kw3 = kw2->master = kw2;
		}
	if (!kw3)
		return kw;
	for(rv = kw; kw; kw = kw->next) {
		kwm = kw->master;
		if ((kw1 = kw->next) && kw1->master == kwm && kwm) {
			kw3 = kw->kw ? kw : 0;
			do {
				kw2 = kw1;
				if (kw1->kw) {
					if (kw3)
						botch("Two masters in masteradj!");
					kw3 = kw1;
					}
				}
				while((kw1 = kw1->next) && kw1->master == kwm);
			if (kw3 || kw2->pparent) {
				if (kw2 != kw3) {
					kw2->pparent = kw3->pparent;
					kw2->kw = kw3->kw;
					kw3->kw = 0;
					}
				for(;;kw = kw->next) {
					kw->master = kw2;
					if (kw == kw2)
						break;
					}
				}
			else
				for(;;kw = kw->next) {
					kw->master = 0;
					if (kw == kw2)
						break;
					}
			kw = kw2;
			}
		}
	return rv;
	}

 static void
xmasteradj(KWctx **x, int n)
{
	/* variant of masteradj for pretty_ex1 */
	KWctx *kw, *kw1, *kw2, *kw3, *kwm;
	int i, j;

	for(i = 0, kw3 = 0; i < n; ++i) {
		kw1 = x[i];
		if ((kw2 = kw1->master))
			kw3 = kw2->master = kw2;
		}
	if (!kw3)
		return;
	for(i = 0; i < n; i = j) {
		j = i + 1;
		kw = x[i];
		kwm = kw->master;
		if (j < n && kwm && (kw1 = x[j])->master == kwm) {
			kw3 = kw->kw ? kw : 0;
			do {
				kw2 = kw1;
				if (kw1->kw) {
					if (kw3)
						botch("Two masters in xmasteradj!");
					kw3 = kw1;
					}
				}
				while(++j < n && (kw1 = x[j])->master == kwm);
			if (kw3 || kw2->pparent) {
				if (kw2 != kw3) {
					kw2->pparent = kw3->pparent;
					kw2->kw = kw3->kw;
					kw3->kw = 0;
					}
				for(;;kw = x[++i]) {
					kw->master = kw2;
					if (kw == kw2)
						break;
					}
				}
			else
				for(;; kw = x[++i]) {
					kw->master = 0;
					if (kw == kw2)
						break;
					}
			}
		}
	}

 static void
do_indent(int indent)
{
	for(indent += 8; indent >= 8; indent -= 8)
		putchar('\t');
	for(; indent > 0; --indent)
		putchar(' ');
	}

 static void
do_indent1(int indent)	/* write indent-1 spaces */
{
	while(--indent > 0)
		putchar(' ');
	}

 static const char *KEYKIND[4] = { "KEYWORD ", "KEYWORD01 ", "KEYWORD1 ", "KEYWORD12 " };

 static void
pretty_print(int iinc, int needrev)
{
	KWctx *kw, *kw1, *kw2, *kw3, **kwtop, **kwbot, *plist;
	const char *s;
	int alt, i, indent, lev, needindent, needspace;

	kwtop = kwbot = KWStack;
	indent = 0;
	plist = 0;
	needindent = 1;
	for(kw1 = KWbase.kw; kw1;) {
		fputs(KEYKIND[(kw1->kind >> KWtopshift) & 3], stdout);
		prkwname(kw1, "\n", needrev);
		*kwtop = masteradj(kw1->kw);
		alt = 0;
		for(;;--kwtop) {
	 top:
			for(kw = *kwtop; kw; kw = kw->next) {
				lev = kw->level;
				if (needindent) {
					do_indent(indent);
					needindent = 0;
					}
				if (plist
				 && (plist->level > lev
				  || (plist->level == lev && plist != kw->pparent))) {
 finishpar:
					*kwtop = kw;
					*++kwtop = plist;
					*++kwtop = masteradj(plist->kw);
					plist->alt = alt;
					alt = 0;
					plist = plist->next;
					goto top;
					}
				if (kw->parstate == Printing) {
					s = !kw->names || /*[(*/kw->req ? ")\n" : "]\n";
					if (kw->kw && !kw->req
					 && kw->next && kw->next->alt == kw->alt) {
						s = /*(*/ ")\n";
						indent -= iinc;
						}
					fputs(s, stdout);
					needindent = 1;
					alt = kw->alt;
					indent -= iinc;
					if (!kw->names) {
						alt = kw->alt;
						goto bot;
						}
					continue;
					}
				if (plist)
					for (kw2 = kw->pparent;
							kw2 && kw2->parstate != Printing;
							kw2 = kw2->pparent) {
						if (plist->level >= kw2->level)
							goto finishpar;
						}
				needindent = 1;
				needspace = 0;
				if (alt == kw->alt) {
					putchar('|');
					needspace = 1;
					}
				if ((kw2 = kw->pparent) && kw2->parstate != Printing) {
					kw3 = 0;
					do {
						if (kw2->parstate == Printing)
							break;
						if (kw2->kw) {
							kw2->next = kw3;
							kw3 = kw2;
							kw2->parstate = Printing;
							if (needspace) {
								putchar('\n');
								needspace = 0;
								do_indent(indent);
								}
							indent += iinc;
							putchar('('); /*)*/
							do_indent1(iinc);
							}
						}
						while((kw2 = kw2->pparent));
					while(kw3) {
						kw2 = kw3->next;
						kw3->next = plist;
						plist = kw3;
						kw3 = kw2;
						}
					}
				if ((kw2 = kw->master) && kw == kw2)
					kw2 = 0;
				if (!kw->kw && (!kw2 || kw2->parstate == Leftput)) {
					if (needspace)
						putchar(' ');
					if (!kw->req) {
						if (alt != kw->alt) {
							fputs("[ ", stdout);
							alt = kw->alt;
							}
						s = /*[*/ " ]\n";
						if ((kw2 = kw->next) && kw2->alt == alt)
							s = "\n";
						prkwname(kw, s, needrev);
						continue;
						}
					alt = kw->alt;
					prkwname(kw, "\n", needrev);
					continue;
					}
				if (kw->parstate == Leftput) {
					if (needspace)
						goto putspace;
					}
				else {
					if (needspace) {
						putchar('\n');
						do_indent(indent);
						}
					putchar(kw->req ? '(' : '['); /*])*/
					if (kw->kw && !kw->req
					 && kw->next && kw->next->alt == kw->alt) {
						do_indent1(iinc);
						putchar('('/*)*/);
						indent += iinc;
						}
					indent += iinc;
 putspace:
					do_indent1(iinc);
					}
				kw->parstate = Printing;
				prkwname(kw, "\n", needrev);
				if (kw2) {
					alt = kw->alt;
					kw2->parstate = Leftput;
					continue;
					}
				alt = 0;
				*kwtop = kw;
				*++kwtop = masteradj(kw->kw);
				goto top;
				}
 bot:
			if (kwtop == kwbot) {
				if (plist) {
					*kwtop++ = plist;
					*kwtop++ = masteradj(plist->kw);
					plist->alt = alt;
					alt = 0;
					plist = plist->next;
					}
				else {
					if (indent) {
						if (needindent)
							do_indent(indent);
						fputs(/*(*/")\n", stdout);
						needindent = 1;
						indent -= iinc;
						}
					break;
					}
				}
			}
		if (!(kw1 = kw1->next))
			break;
		putchar('\n');
		}
	}

 static void
Output(StrList *headers, StrList *nsname, int hwant, int nwant)
{
	KWctx *kw, *kw1, *kw2, **kwtop, **kwbot;
	StrList *h;

	if (hwant && headers) {
		printf("#include \"nidr.h\"\n");
		for(h = reverse(&headers); h; h = h->next)
			printf(*h->val == '<' /*>*/
				? "#include %s\n"
				: "#include \"%s\"\n", h->val);
		}
	if (nwant) {
		if (!nsname)
			nsname = new_StrList("Dakota", nsname);
		putchar('\n');
		for(h = reverse(&nsname); h; h = h->next)
			printf("namespace %s {\n", h->val); /*}*/
		}
	printf("\n/** %d distinct keywords (plus %d aliases) **/\n\nstatic %sKeyWord\n",
		lastagroup, nalias, guikeywds ? "Gui" : "");
	kwtop = kwbot = KWStack;
	*kwtop = &KWbase;
	for(;;--kwtop) {
 top:
		for(kw = *kwtop; kw; kw = kw->next) {
			if ((kw->master && kw->master != kw)
			|| ((!(kw1 = kw->pparent) || kw->parstate == KwStacked) && !kw->kw)
			|| kw->kwkno)
				continue;
			if (kw1 && kw1->parstate != KwStacked) {
				if ((kw1 = kw->pparent) && kw1->parstate != KwStacked) {
					kw1->parstate = KwStacked;
					*kwtop = kw;
					*++kwtop = kw1;
					kw2 = *++kwtop = kwsort(kw1);
					do kw2->parstate = KwStacked;
						while((kw2 = kw2->next));
					while((kw1 = kw1->pparent) && kw1->parstate != KwStacked) {
						kw1->parstate = KwStacked;
						*++kwtop = kw1;
						kw2 = *++kwtop = kwsort(kw1);
						do kw2->parstate = KwStacked;
							while((kw2 = kw2->next));
						}
					goto top;
					}
				if (!kw1 && !kw->kw)
					continue;
				}
			if (!kw->nkw && kw->kw) {
				*kwtop = kw;
				*++kwtop = kwsort(kw);
				goto top;
				}
			kwout(kw, kwtop);
			}
		if (kwtop == kwbot)
			break;
		}
	printf(";\n\n");
	if (nwant) {
		for(h = reverse(&nsname); h; h = h->next)
			printf("} // namespace %s\n", h->val);
		putchar('\n');
		}
	printf("KeyWord Dakota_Keyword_Top = {\"KeywordTop\",0,%d,%d,%d",
		KWbase.nkw, KWbase.alt, KWbase.req);
	putchar(',');
	if (nwant)
		for(h = reverse(&nsname); h; h = h->next)
			printf("%s::", h->val);
	printf("kw_%d};\n", KWbase.kwkno);
	if (startwarn && missing && !guikeywds)
		fprintf(stderr, "%s: %d start routines implicitly named.\n",
			progname, missing);
	}

 typedef int (*KWcomp)(const void*, const void*);

 static const char **zalt;

 static int
kwcomp1(const void *a, const void *b)
{
	const KWctx *ka, *kb;

	ka = *(const KWctx**)a;
	kb = *(const KWctx**)b;
	if (ka->req) {
		if (!kb->req)
			return -1;
		}
	else if (kb->req)
		return 1;
	if (ka->alt == kb->alt) {
		if (ka->master != kb->master) {
			if (!ka->master)
				return -1;
			if (!kb->master)
				return 1;
			ka = ka->master;
			kb = kb->master;
			}
		return strcmp(ka->names->val, kb->names->val);
		}
	return strcmp(zalt[ka->alt], zalt[kb->alt]);
	}

 static int
kwcomp2(const void *a, const void *b)
{
	const KWctx *ka, *kb, *pa, *pb;

	ka = *(const KWctx**)a;
	kb = *(const KWctx**)b;
	if (ka->req) {
		if (!kb->req)
			return -1;
		}
	else if (kb->req)
		return 1;
	if (ka->alt == kb->alt) {
		pa = ka->master ? ka->master->pparent : ka->pparent;
		pb = kb->master ? kb->master->pparent : kb->pparent;
		if (pa != pb)
			return ka->objno - kb->objno;
		if (ka->master != kb->master) {
			if (!ka->master)
				return -1;
			if (!kb->master)
				return 1;
			ka = ka->master;
			kb = kb->master;
			}
		return strcmp(ka->names->val, kb->names->val);
		}
	return strcmp(zalt[ka->alt], zalt[kb->alt]);
	}

 static void
do_sort(KWctx *kw, KWcomp KWcmp)
{
	KWctx *kw1, *kwm, **x, *x0[KWPlen];
	const char *z0[KWPlen];
	int i, n, na;

	for(n = 0, kw1 = kw->kw; kw1; kw1 = kw1->next) {
		++n;
		reverse(&kw1->names);
		}
	if (n <= 1)
		return;
	x = n > KWPlen ? (KWctx**)Malloc(n*sizeof(KWctx*), "do_sort") : x0;
	na = kw->nalt + 1;
	zalt = na <= KWPlen ? z0 : (const char**)Malloc(na*sizeof(const char*), "do_sort");
	memset(zalt, 0, na*sizeof(const char*));
	for(n = 0, kw1 = kw->kw; kw1; kw1 = kw1->next) {
		x[n++] = kw1;
		if ((kwm = kw1->master))
			kwm->master = kwm;
		if (!zalt[i = kw1->alt]
		 || strcmp(kw1->names->val, zalt[i]) < 0)
			zalt[i] = kw1->names->val;
		}
	qsort(x, n--, sizeof(KWctx*), KWcmp);
	for(i = 0; i < n; ++i)
		x[i]->next = x[i+1];
	x[n]->next = 0;
	kw->kw = x[0];
	if (zalt != z0)
		free(zalt);
	if (x != x0)
		free(x);
	}

 static void
ksort(KWcomp KWcmp)
{
	KWctx *kw, *kw1, **kwtop, **kwtop0, **kwbot;

	kwtop = kwbot = KWStack;

	for(*kwtop = &KWbase;; --kwtop) {
 top:
		kw = *kwtop;
 top1:
		while(kw) {
			if ((kw1 = kw->pparent) && kw1->parstate != Sorted) {
				*kwtop = kw;
				kwtop0 = kwtop;
				do {
					kw1->parstate = Sorted;
					*++kwtop = kw1;
					}
					while((kw1 = kw1->pparent) && kw1->parstate != Sorted);
				if (kwtop > kwtop0)
					goto top;
				}
			if (kw->kw) {
				do_sort(kw, KWcmp);
				if ((*kwtop = kw->next))
					++kwtop;
				kw = *kwtop = kw->kw;
				goto top1;
				}
			kw = kw->next;
			}
		if (kwtop <= kwbot)
			break;
		}
	}

 static void
pretty_ex1(KWctx *kw, KWctx *prevkw, KWctx *nextkw, int indent, int iinc, int needrev)
{
	KWctx *kw0, *kw1, *kw2, *kwm, *kwp, *kwp0, **x, *y, *y1;
	const char *suf, *z0[KWPlen];
	int ep, i, i0, ia, j, n, na, np;

	x = 0;
	kw1 = kw->kw;
	if (needrev == 1)
		needrev = 2;
	if ((kwp0 = kwp = kw->pparent) && (!kw->master || kw->master == kw)) {
		for(n = 0;;) {
			if (kwp->parstate != Printing) {
				kwp->parstate = Printing;
				for(kw1 = kwp->kw; kw1; kw1 = kw1->next)
					kw1->pparent = 0;	/* avoid infinite loops */
				}
			for(kw1 = kwp->kw; kw1; kw1 = kw1->next)
				++n;
			if (!(kw1 = kwp->pparent))
				break;
			kwp = kwp->pparent = kw1;
			}
		np = n;
		for(kw1 = kw->kw; kw1; kw1 = kw1->next)
			++n;
		y = y1 = (KWctx*)Malloc(np*sizeof(KWctx) + n*sizeof(KWctx*), "pretty_ex1");
		x = (KWctx**)(y + np);
		for(i = 0, kw1 = kw->kw; kw1; kw1 = kw1->next)
			x[i++] = kw1;
		i0 = i;
		for(kwp = kwp0; kwp; kwp = kwp->pparent) {
			j = i;
			na = i + kwp->nalt;
			for(kw1 = kwp->kw; kw1; kw1 = kw1->next, ++y1) {
				memcpy(y1, kw1, sizeof(KWctx));
				x[i++] = y1;
				y1->alt += j;
				}
			}
		if (!needrev) {
			for(j = i0; j < n; ++j) {
				kw1 = x[j];
				kw1->nreq = -(kw1->nreq + 1);
				}
			zalt = ++na <= KWPlen ? z0
				: (const char**)Malloc(na*sizeof(const char*), "pretty_ex1");
			memset(zalt, 0, na*sizeof(const char*));
			for(j = 0; j < n; ++j) {
				kw1 = x[j];
				if ((kwm = kw1->master))
					kwm->master = kwm;
				if (!zalt[i = kw1->alt]
				 || strcmp(kw1->names->val, zalt[i]) < 0)
					zalt[i] = kw1->names->val;
				}
			qsort(x, n, sizeof(KWctx*), kwcomp1);
			if (zalt != z0)
				free(zalt);
			for(j = 0; j < n; ++j) {
				kw1 = x[j];
				if (kw1->nreq < 0) {
					kw1->nreq = -(kw1->nreq + 1);
					kw1->pparent = 0;
					}
				}
			}
		kw1 = x[0];
		xmasteradj(x, n);
		}
	if (kw1) {
		if (!x)
			kw1 = masteradj(kw->kw);
		ep = kw->req;
		if (prevkw && kw->alt == prevkw->alt) {
			ia = kw->master && kw->master == prevkw->master ? iinc : 0;
			do_indent(indent + ia);
			if (!prevkw->master || prevkw->master != kw->master) {
				fputs("|\n", stdout);
				do_indent(indent + ia);
				putchar('(');
				}
			else
				putchar('|');
			}
		else {
			do_indent(indent);
			if (kw->req)
				putchar('('/*)*/);
			else {
				putchar('[');
				if (nextkw && !nextkw->req && kw->alt == nextkw->alt) {
					ep = 1;
					do_indent1(iinc);
					putchar('(');
					indent += iinc;
					}
				}
			}
		do_indent1(iinc);
		indent += iinc;
		prkwname(kw, "\n", needrev);
		i = 0;
		kw0 = 0;
		while(kw1) {
			if (x)
				kw2 = ++i >= n ? 0 : x[i];
			else
				kw2 = kw1->next;
			pretty_ex1(kw1, kw0, kw2, indent, iinc, needrev);
			kw0 = kw1;
			kw1 = kw2;
			}
		if (x)
			free(y);
		do_indent(indent);
		fputs(ep ? ")\n" : "]\n", stdout);
		}
	else {
		if (prevkw && kw->alt == prevkw->alt
		 && kw->master && kw->master == prevkw->master)
			indent += iinc;
		do_indent(indent);
		suf = "\n";
		if (prevkw && kw->alt == prevkw->alt) {
			if (kw->master && kw->master != prevkw->master) {
				fputs("|\n", stdout);
				do_indent(indent);
				fputs("( ", stdout);
				}
			else {
				fputs("| ", stdout);
				if (!kw->req)
					goto rbcheck;
				}
			}
		else if (kw->req) {
			if (prevkw && prevkw->master != kw->master)
				fputs("( ", stdout);
			}
		else {
			fputs("[ ", stdout);
 rbcheck:
			if (!nextkw || nextkw->alt != kw->alt)
				suf = " ]\n";
			}
		prkwname(kw, suf, needrev);
		}
	}

 static void
pretty_expand(int iinc, int needrev)
{
	KWctx *kw, *kw0, *kw1, *kw2;

	if ((kw = KWbase.kw)) for(;;) {
		masteradj(kw->kw);
		fputs(KEYKIND[(kw->kind >> KWtopshift) & 3], stdout);
		prkwname(kw, "\n", needrev);
		kw0 = 0;
		for(kw1 = kw->kw; kw1; kw1 = kw2) {
			kw2 = kw1->next;
			pretty_ex1(kw1, kw0, kw2, 0, iinc, needrev);
			kw0 = kw1;
			}
		if (!(kw = kw->next))
			break;
		putchar('\n');
		}
	}

 static int
Str_option(char *s, char ***pav, int *want, StrList **ps)
{
	if (*++s || (s = *++*pav)) {
		if (*s == '-' && ! s[1])
			*want = 0;
		else
			*ps = new_StrList(s, *ps);
		return 0;
		}
	return 1;
	}

 static int
version(void)
{
	printf("nidrgen version 20090403\n");
	return 0;
	}

 static int
tagcomp(const void *a, const void *b)
{
	return strcmp(*(const char**)a, *(const char**)b);
	}

 static int
unused_tags()
{
	Taghash *th;
	char **x;
	size_t i, nbad;

	nbad = 0;
	for(th = (Taghash*)TagTab.lastdh; th; th = (Taghash*)th->hh.thread)
		if (!th->uses)
			++nbad;
	if (!nbad)
		return 0;
	x = (char**)Malloc(nbad*sizeof(char*), "unsed_tags");
	for(i = 0, th = (Taghash*)TagTab.lastdh; th; th = (Taghash*)th->hh.thread)
		if (!th->uses)
			x[i++] = th->hh.name;
	fprintf(stderr, "%lu unused tag definition%s in %s:\n",
		(unsigned long)nbad, "s" + (nbad == 1), tagfname);
	if (nbad > 1)
		qsort(x, nbad, sizeof(char*), tagcomp);
	for(i = 0; i < nbad; ++i)
		fprintf(stderr, "\t\"%s\"\n", x[i]);
	free(x);
	return 1;
	}

 static int
defcomp(const void *a, const void *b)
{
	return strcmp((*(const Defhash**)a)->hh.name, (*(const Defhash**)b)->hh.name);
	}

 static void
write_defs(FILE *f)
{
	Defhash *d, **x, **x1;
	DefhashHead *dh;
	size_t i, n;

	n = DHTab.nent;
	x = x1 = (Defhash**)Malloc(n*sizeof(Defhash*), "write_defs");
	for(dh = DHTab.lastdh, i = 0; dh; dh = dh->thread) {
		if (++i > n)
			botch("lastdef count botch");
		*x1++ = (Defhash*)dh;
		}
	qsort(x, n, sizeof(Defhash*), defcomp);
	for(i = 0; i < n; ++i) {
		d = x[i];
		fprintf(f, d->qkeep ? "#define %s \"%s\"\n"
			: "#define %s %s\n",
			d->hh.name, d->value);
		}
	}

 int
main(int argc, char **argv)
{
	FILE *f;
	StrList *headers, *mtagname, *nsname, *outtagname;
	char *defsout, *ofname, *s, *se;
	int defwrite, dupcheck, hwant, needrev, nwant, pprint, sort, x;

	KWStack[0] = &KWbase;
	DHTab.nalloc  = (sizeof(Defhash) + sizeof(void*) - 1)/sizeof(void*);
	TagTab.nalloc = (sizeof(Taghash) + sizeof(void*) - 1)/sizeof(void*);
	KWbase.names = new_StrList("$top",0);
	progname = argv[0];
	if (argc <= 1)
 usage1:	return usage(1);
	headers = mtagname = nsname = outtagname = 0;
	defsout = ofname = 0;
	dupcheck = hwant = needrev = nwant = 1;
	defwrite = pprint = sort = 0;
 nextopt:
	while((s = *++argv) && *s == '-' && s[1]) {
		while(*++s)
		switch(*s) {
		 case 'D':
			defwrite = 1;
			break;
		 case 'T':
			if (Str_option(s, &argv, &hwant, &outtagname))
				goto usage1;
			goto nextopt;
		 case 'd':
			dupcheck = 0;
			break;
		 case 'e':
			expand = 1;
			break;
		 case 'f':
			wantfuncs = 0;
			ignoretags = 1;
			break;
		 case 'g':
			guikeywds = 1;
			break;
		 case 'G':
			dfltgroup = 0;
			break;
		 case 'h':
			if (Str_option(s, &argv, &hwant, &headers))
				goto usage1;
			goto nextopt;
		 case 'm':
			if (Str_option(s, &argv, &hwant, &mtagname))
				goto usage1;
			goto nextopt;
		 case 'n':
			if (Str_option(s, &argv, &nwant, &nsname))
				goto usage1;
			goto nextopt;
		 case 't':
			ignoretags = 1;
			break;
		 case 's':
			sort = 1;
			needrev = 0;
			for(;;++s) {
				switch(s[1]) {
				  case 'e': expand = 1;
					    continue;
				  case 'f': wantfuncs = 0;
				  case 'p': continue;
				  }
				break;
				}
			/* no break */
		 case 'p':
			pprint = 2;
			for(;;++s) {
				switch(s[1]) {
				  case 'e':
					expand = 1;
					continue;
				  case 'f':
					wantfuncs = 0;
					continue;
				  case 's':
					sort = 1;
					needrev = 0;
					continue;
				  case 't':
					ignoretags = 1;
					continue;
				  }
				break;
				}
			if (*++s) {
				pprint = (int)strtol(s,&se,10);
				if (pprint < 1 || se)
					goto usage1;
				}
			goto nextopt;
		 case 'v':
			return version();
		 case 'w':
			startwarn = 0;
			break;
		 case '?':
			return usage(s[1] != 0);
		 case '-':
			if (!strcmp(++s,"help"))
				return usage(0);
			if (!strcmp(s,"version"))
				return version();
			if (!*s) {
				s = *++argv;
				goto argsdone;
				}
			/* no break */
		  default:
			goto usage1;
		  }
		}
 argsdone:
	if (!s || (argv[1] && argv[2] && argv[3] && argv[4]))
		return usage(1);
	if ((tagfname = argv[1])) {
		specfile = s;
		s = tagfname;
		lastseen = Saw_kwname;
		lastkw1 = &KWbase;
		if ((defsout = argv[2]))
			ofname = argv[3];
		}
	else if (mtagout) {
		fprintf(stderr, "%s: -m specified but no tagfile given.\n", progname);
		return 1;
		}
	if (*s == '-' && !s[1])
		yyin = stdin;
	else if (!(yyin = fopen(infname = s, "r"))) {
		cantopen(s);
		return 1;
		}
	if (specfile)
		tagin = yyin;
	if ((mtagname && (!(mtagout = fopen(s = mtagname->val, "w"))))
	 || (outtagname && !(tagout = fopen(s = outtagname->val, "w")))) {
		cantopen(s);
		return 1;
		}
	if ((x = yylex())) {
		fprintf(stderr, "\n%s: Surprise return %d from yylex()\n", progname, x);
		return x;
		}
	if (mtagout)
		fclose(mtagout);
	if (tagout)
		fclose(tagout);
	if (tagout || mtagout)
		goto done;
	if (Br_top > Br_stack) {
		fputs("Missing ", stderr);
		do putc(/*[*/ *Br_top-- == '(' ? ')' : ']', stderr);
			while(Br_top >Br_stack);
		fputs(" at end of file.\n", stderr);
		return 1;
		}
	if (nsquawk)
		return 1;
	if (tagfname && unused_tags())
		return 1;
	if (KWbase.kw) {
		paradj(needrev);
		if (dupcheck)
			dup_check();
		}
	if (ofname && !freopen(ofname, "w", stdout)) {
		fprintf(stderr, "%s: Cannot open output file \"%s\"\n", progname, ofname);
		return 1;
		}
	if (KWbase.kw) {
		if (pprint) {
			if (expand) {
				if (sort)
					ksort(kwcomp1);
				pretty_expand(pprint, needrev);
				}
			else {
				if (sort)
					ksort(kwcomp2);
				pretty_print(pprint, needrev);
				}
			}
		else if (!defwrite)
			Output(headers, nsname, hwant, nwant);
		else if (DHTab.lastdh)
			write_defs(stdout);
		}
	if (!defwrite && defsout) {
		f = fopen(defsout,"w");
		if (!f) {
			fprintf(stderr, "%s:  cannot open defs file \"%s\"\n",
				progname, defsout);
			return 1;
			}
		write_defs(f);
		fclose(f);
		}
 done:
	return dupnames > 0;
	}
