########################################################################
# Variables to be set by user
########################################################################
# input directory name
idn = "./outdir/"	

## Test problem list.
problems = %w{sp5 sp10};

## Create combinations of solvers
##        0      1        2
list = ["l", "g", "d"];
combos = [[1], [2], [1,2], [0,1,2]];

## Create run names
runs = ["r1", "r2"];

########################################################################
# Main program
########################################################################

problems.each { |prob| 

  combos.each{ |comb|
    
    # combination name
    combname = "";
    comb.each { |ci|
      combname = combname + list[ci];
    }
    
    # reset summary results
    sum_ntrials = 0;		# number of trials
    sum_nsuccess = 0;		# number of failed trials
    sum_ne = 0;			# total number of evaluations
    sum_neg = 0;		# total number of GSS evaluations
    sum_ned = 0;		# total number of DIRECT evaluations
    sum_nel = 0;		# total number of LHS evaluations
    sum_nc = 0;			# total number of cached evaluations
    sum_ns = 0;			# total number of shared evaluations
    sum_time = 0;		# total time

    runs.each{ |run|

      # reset results
      $fmin = -9999;		# minimum value found
      $pe = -1; 		# percent error
      $success = '0';		# 'T' is global min is found, 'F' otherwise
      $ne = 0;			# number of evaluations
      $neg = 0;			# number of GSS evaluations
      $ned = 0;			# number of DIRECT evaluations
      $nel = 0;			# number of LHS evaluations
      $nc = -1;			# number of cached evaluations
      $ns = -1;			# number of shared evaluations
      $time = -1;		# total time for run
      $time2 = -1;		# another way of calcuation the total time (should match the first)

      # input mix name
      imn = run + "_" + prob + "_" + combname;
      
      ########################################
      # Grab results from dot-out file
      ########################################
      # name of input file corresponding to dot-out file
      ifn_out = idn + imn + ".out"	
      
      # Scan dot-out file
      IO.foreach(ifn_out){ |line|
	if (line.include?("LISTENER: fBest = "))
	  # Sample line ->
	  # LISTENER: fBest = 3.97945000e-01
	  tmp = line.split(" "); 
	  $fmin = tmp[3];
	elsif (line.include?("LISTENER: Percent Error = "))
	  # Sample line ->
	  # LISTENER: Percent Error = 0.011309374
	  tmp = line.split(" ");
	  $pe = tmp[4];
	elsif (line.include?("LISTENER: Best Point Found?"))
	  # Sample line ->
	  # LISTENER: Best Point Found? F
	  tmp = line.split;
	  $success = tmp[4];
	elsif (line.include?("LISTENER: Total Eval Count: "))
	  # Sample line ->
	  # LISTENER: Total Eval Count: 1041
	  tmp = line.split(" ");
	  $ne = tmp[4];
	elsif (line.include?("Number of Cached Evaluations:"))
	  # Sample line ->
	  # Number of Cached Evaluations: 27
	  # Note similarity to other relevant line below --- need to be 
	  # careful regarding include test.
	  tmp = line.split(":");
	  $nc = tmp[1].strip;
	elsif (line.include?("Number of Cached Evaluations (from pending list)"))
	  # Sample line ->
	  # Number of Cached Evaluations (from pending list): 0
	  tmp = line.split(":");
	  $ns = tmp[1].strip;
	elsif (line.include?("LISTENER: Total Run Time: "))
	  # Sample line ->
	  # LISTENER: Total Run Time: 44
	  tmp = line.split;
	  $time = tmp[4];
	end
      }
      
      
      ########################################
      # Grab results from dot-listener file
      ########################################
      
      # name of input file corresponding to dot-listener file
      ifn_listener = idn + imn + ".listener" 
      
      # scan through the dot-listener file to find the last line that 
      # reports a point and to find the number of evals for each citizen 
      IO.foreach(ifn_listener){ |line|
	if (line.include?("time"))
	  $lastline = line;
	end
	if (line.include?("GSS"))
	  $neg +=1;
	elsif (line.include?("DIRECT"))
	  $ned += 1;
	elsif (line.include?("LHS"))
	  $nel += 1;
	end    
      }
      
      # read out the time
      # Sample Line -> (artifically broken to 2nd line)
      # 1041, 0.398483, Citizen 2(DIRECT), tag=1040, f=[ 0.398483 ], 
      # x=[-3.1310014 5.6824417 ] time=[42] re=[0.14651923]
      tmp = $lastline.split('time=[');
      tmp = tmp[1].split(']');
      $time2 = tmp[0];
      
      ########################################
      # Update summary results
      ########################################

      sum_ntrials += 1;
      if ($success == "T")
	sum_nsuccess += 1;
	sum_ne += $ne.to_i;
	sum_neg += $neg.to_i;
	sum_ned += $ned.to_i;
	sum_nel += $nel.to_i;
	sum_nc += $nc.to_i;	
	sum_ns += $ns.to_i;	
	sum_time += $time.to_i;
      end

      ########################################
      # Output results that have been collected
      ########################################
      
      printf("%3s %4s %3s ", run, prob, combname)
      printf("%s %10g %7.3f ",$success, $fmin, $pe);
      printf("%4d (%4d,%4d,%4d) ", $ne, $nel, $neg, $ned);
      printf("%3d %3d ", $nc, $ns);
      printf("%2d %2d", $time, $time2); 
      printf("\n");

    }

    
    printf("SUM %4s %3s ", prob, combname)
    printf("%-20s ", "Solved " + sum_nsuccess.to_s + "/" + sum_ntrials.to_s);
    if (sum_nsuccess > 0)
      printf("%4d (%4d,%4d,%4d) ", sum_ne/sum_nsuccess, sum_nel/sum_nsuccess, sum_neg/sum_nsuccess, sum_ned/sum_nsuccess);
      printf("%3d %3d ", sum_nc/sum_nsuccess, sum_ns/sum_nsuccess);
      printf("%2d", sum_time/sum_nsuccess)
    end
    printf("\n");


#    printf("%4s %3s SUM %d of %d ", prob, combname, sum_nsuccess, sum_ntrials);

#      printf("%4d=%4d+%4d+%4d %3d %3d %2d \n", sum_ne/sum_ntrials, sum_nel/sum_ntrials, sum_neg/sum_ntrials, sum_ned/sum_ntrials, sum_nc/sum_ntrials, sum_ns/sum_ntrials, sum_time/sum_ntrials)
#    else
#      printf("\n");
#    end
  }
}
