/* This is third-party software that is distributed with Acro.
 * For licensing information concerning this file, see the Acro home page:
 * http://software.sandia.gov/Acro
 */

///////////////////////////////////////////////////////////////////
/*****************************************************************
Name: Hussein A. Abbass,
Artificial Life and Adaptive Robotics Laboratory - ALAR
School of ITEE, UNSW@ADFA, Australia
*******************************************************************/
///////////////////////////////////////////////////////////////////
#include "assert.h"
#include "Random.h"

Random::Random()
{
 idum = (long) -12345; // this is the seed
 IA   = 16807;
 IM   = 2147483647;
 AM   = (1.0/IM);
 IQ   = 127773;
 IR   = 2836;
 NTAB = 32;
 NDIV = (1+(IM-1)/NTAB);
 EPS  = 1.2e-7;
 RNMX = (1.0-EPS) /* largest double less than 1 */;
 iy=0;
 iv = new long[NTAB]; assert((iv)!= 0);
}

void Random::setSeed(int X) { idum = (long) -X; }

void Random::setSeed(long X) { idum = -X; }

double Random::nextGaussian(double mean,double stdev)
{
double x = (double) nextGaussian();
return (double) (x * stdev + mean);
}

double Random::nextDouble()
{
 int j;
 long k;
 double temp;
 if (idum <=0 || !iy)
    {
     if (-idum < 1) idum=1; else idum = -idum;
     for (j=NTAB+7;j>=0;j--)
         {
          k=idum/IQ;
          idum=IA*(idum-k*IQ)-IR*k; if (idum < 0) idum +=IM; if (j < NTAB) iv[j] = idum;
         }
     iy=iv[0];
    }
 k=idum/IQ;
 idum=IA*(idum-k*IQ)-IR*k;
 if (idum < 0) idum += IM;
 j= (int) (iy/NDIV);
 iy=iv[j];
 iv[j]= idum;
 //cout << "RNMX " << RNMX << " temp " << temp << endl;
 if ((temp=AM*iy) > RNMX) return RNMX; else return temp;
}

double Random::nextGaussian()
{
 static int iset=0;
 static double gset;
 double fac,rsq,v1,v2;
 if (iset ==0)
    {
     do
       {
        v1=2.0*nextDouble()-1.0; v2=2.0*nextDouble()-1.0; rsq=v1*v1+v2*v2;
       }
     while(rsq>=1.0 ||rsq ==0.0);
     fac =sqrt(-2.0*log(rsq)/rsq);
     gset=v1*fac;
     iset=1;
     return v2*fac;
    }
    else
    {
     iset=0;
     return gset;
    }
}
