/*  _________________________________________________________________________
 *
 *  Coliny: A Library of COLIN optimizers
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top Coliny directory.
 *  _________________________________________________________________________
 */

/**
 * \file coliny.h
 *
 * Global header for Coliny.
 */

/**
 * \namespace coliny
 *
 * The namespace used to encapsulate classes for the Coliny optimization
 * library.
 */

#include <acro_config.h>
#ifndef coliny_coliny_h
#define coliny_coliny_h

#include <coliny/Direct.h>
#include <coliny/DirectMisc.h>
#include <coliny/PDirect.h>
#include <coliny/DockingPS.h>
#include <coliny/PatternSearch.h>
#include <coliny/SolisWets.h>
#include <coliny/c_EAgeneric.h>
#include <coliny/DomainInfoBase.h>
#include <coliny/DomainInfoMixedInteger.h>
#include <coliny/DomainOpsArray.h>
#include <coliny/DomainOpsBase.h>
#include <coliny/DomainOpsBinary.h>
#include <coliny/DomainOpsIntArray.h>
#include <coliny/DomainOpsMixedInteger.h>
#include <coliny/DomainOpsRealArray.h>
#include <coliny/DynamicGSS.h>
#include <coliny/EAbase.h>
#include <coliny/EAgeneric.h>
#include <coliny/EAindividual.h>
#include <coliny/EAminlp.h>
#include <coliny/EAops_array.h>
#include <coliny/EAops.h>
#include <coliny/EAops_intarray.h>
#include <coliny/EApoint.h>
#include <coliny/panmictic_selection.h>
#include <coliny/PEAbase.h>
#include <coliny/selection.h>
#include <coliny/Grasp.h>
#include <coliny/MultiStart.h>
#include <coliny/APPS.h>
#include <coliny/Cobyla2.h>
#include <coliny/DOT.h>
#include <coliny/PLGO.h>
#include <coliny/TCC.h>
#include <coliny/RandomMOO.h>
#include <coliny/MultiStatePS.h>

#endif
