/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

//
// OptSolver test commandshell interface
//

#include <acro_config.h>
#include <colin/ColinUtilib.h>
#include "TestOptSolver.h"

using namespace std;

void TestOptSolver::minimize()
{
real tmp;
problem.EvalF(curr, tmp);
best().value()= tmp;

int j=0;
while (best().value() > accuracy) {
  for (unsigned int i=0; i<curr.size(); i++)
    curr[i] -= 0.0001;
  problem.EvalF(curr,tmp);
  best().value()= tmp;
  cout << j << " " << best().value() << " " << curr << endl;
  j++;
  }
}

void AnotherOptSolver::minimize()
{
real tmp;
problem.EvalF(curr, tmp);
best().value() = tmp;

int j=0;
while (best().value() > accuracy) {
  for (unsigned int i=0; i<curr.size(); i++)
    curr[i] -= 0.0001;
  problem.EvalF(curr,tmp);
  best().value()= tmp;
  cout << j << " " << best().value() << " " << curr << endl;
  j++;
  }
}
