/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file OptSolverHandle.h
 *
 * Defines the colin::OptSolverHandle class.
 */

#ifndef colin_OptSolverHandle_h
#define colin_OptSolverHandle_h

#include <acro_config.h>
#include <colin/OptSolverWrapper.h>
#include <colin/GenericOptSolver.h>

namespace colin {

/// A generic optimization solver base class.
template <class DomainT, class ResponseT=AppResponse<> >
class OptSolverHandle : public GenericOptSolver<DomainT,ResponseT>
{
public:

  /// Constructor
  OptSolverHandle(OptSolverWrapper<DomainT,ResponseT>* wrapper_, bool own_flag_)
	: wrapper(wrapper_), own_flag(own_flag_)
	{}

  /// Constructor
  OptSolverHandle(OptSolverHandle<DomainT,ResponseT>* handle)
	{ *this = handle; }

  ///
  OptSolverHandle<DomainT,ResponseT>& operator=(OptSolverHandle<DomainT,ResponseT>* handle)
	{
	if (handle) {
	   wrapper = handle->wrapper;
	   handle->wrapper = 0;
	   delete handle;
	   }
	else {
	   wrapper=0;
	   }
	own_flag=true;
	return *this;
	}

  /// Destructor
  virtual ~OptSolverHandle()
	{ if (wrapper && own_flag) delete wrapper; }

  /// Reset the state of the solver.
  void reset()
	{
	GenericOptSolver<DomainT,ResponseT>::reset();
	wrapper->base().reset();
	}

  ///
  void minimize()
	{
	wrapper->base().minimize();
        wrapper->opt_response(this->opt_response());
	}

  ///
  virtual OptProblem<DomainT,ResponseT> & get_problem()
	{ return wrapper->get_problem(); }

  ///
  virtual const OptProblem<DomainT,ResponseT> & get_problem() const
	{ return wrapper->get_problem(); }

  ///
  virtual void set_problem(OptProblem<DomainT,ResponseT>& prob)
	{ wrapper->set_problem(prob); }

  ///
  void set_initial_point(DomainT& pt)
	{ wrapper->set_initial_point(pt); }

  ///
  OptResponse<DomainT,ResponseT>& opt_response()
	{ return wrapper->opt_response(); }

  ///
  OptSolverBase& base()
	{ return wrapper->base; }

  ///
  OptSolverBase* operator->()
	{ return (*wrapper).operator->(); }

  ///
  const OptSolverBase* operator->() const
	{ return (*wrapper).operator->(); }

  /// A pointer to the core solver information.
  OptSolverWrapper<DomainT,ResponseT>* wrapper;

  /// If true, then delete the wrapper
  bool own_flag;

};

}

#endif
