/*  _________________________________________________________________________
 *
 *  COLIN: A Common Optimization Library INterface
 *  Copyright (c) 2003, Sandia National Laboratories.
 *  This software is distributed under the GNU Lesser General Public License.
 *  For more information, see the README.html file in the top COLIN directory.
 *  _________________________________________________________________________
 */

/**
 * \file ForkCallApplication.h
 *
 */

//
// ForkCallApplication.h
//

#ifndef colin_ForkCallApplication_h
#define colin_ForkCallApplication_h

#include <acro_config.h>
#if 0

#include <colin/ColinApplication.h>
#include <colin/ColinForkCallAnalysisCode.h>

namespace colin {

/** Application interface class that spawns executables using forks.
*/
template <class DomainT, class ResponseT, class StringT=string>
class ForkCallApplication : public OptApplication<DomainT,ResponseT> {
 
public:
 
  /**@name General Routines */
  //@{
  /// Generic constructor.
  ForkCallApplication() : OptApplication<DomainT,ResponseT>() {}

  ///
  virtual ~ForkCallApplication() {}
  //@}

  ///
  void setup(const StringT& program, const StringT& input_filename,
				const StringT& output_filename,
				int mode,
				bool ctr_suffix=true,
				bool remove_files=true)
		{app_mode=mode;
		 simulator.setup(program,input_filename,output_filename,
					ctr_suffix,!remove_files);}

  ///
  void set_simulator(ForkCallAnalysisCode<DomainT,ResponseT,StringT>& 
				simulator_) {simulator = simulator_;}

  ///
  ForkCallAnalysisCode<DomainT,ResponseT,StringT>& get_simulator() const
		{return simulator;}

  ///
  void synchronize();

protected:

  ///
  void process(DomainT& point, ResponseT& response, int counter);

  ///
  ForkCallAnalysisCode<DomainT,ResponseT,StringT> simulator;

  ///
  void DoEval(DomainT& point, int& priority,
				ResponseT* response, bool synch_flag);
};



//============================================================================
//
//
template <class DomainT, class ResponseT, class StringT>
void ForkCallApplication<DomainT,ResponseT,StringT>::synchronize()
{
while (response_list.size() > 0) {
#if 0	/// TODO
  ErrAbort("ForkCallApplication::synchronize -- unfinished.  Need to specify the list of points.");

  OptPoint point;
  ListItem<OptResponse*>* item = response_list.head();
  while (item != NULL) {
    ListItem<OptResponse*>* nextitem = response_list.next(item);
    RWCString file_to_test =
      simulator.results_fname(item->data()->id);
    struct stat buf;
    if (stat( (char*)file_to_test.data(),&buf ) != -1) {
        process(point,*(item->data()), item->data()->id);
        OptResponseDestr(item->data()); // Free this response object
        response_list.remove(item);
        }
    item = nextitem;
    }
#endif
  }

}


//============================================================================
//
//
template <class DomainT, class ResponseT, class StringT>
void ForkCallApplication<DomainT,ResponseT,StringT>::
	process(DomainT& point, ResponseT& response, int counter)
{
simulator.read_results_file(response, counter);
update_response(point,response);   
}


//============================================================================
//
//
template <class DomainT, class ResponseT, class StringT>
void ForkCallApplication<DomainT,ResponseT,StringT>
	::DoEval(DomainT& point, int& /*priority*/,
				ResponseT* response, bool synch_flag)
{
verify(response->mode);

if (response_exists(point,*response)) {
   if (!synch_flag)
      ResponseT :: deallocate (response);
   return;
   }

//
// We assume that constraints and function evaluations are both being
// computed here.
//
nprob_ctr++;
neval_ctr++;
if ((num_eq_constr+num_ineq_constr)>0)
   nconstr_ctr++;

simulator.define_filenames(response->id);
simulator.write_parameters_file(point,response->request_vector(),response->id);
CommandShell spawned_shell;
simulator.spawn_evaluation(synch_flag);
if (!synch_flag) 
   response_list.push_back(response);
else
   process(point,*response,response->id);
}

}

#endif

#endif
