/*
================================================================================
    PROJECT:

        Eddy C++ Configuration Project

    CONTENTS:

        Contains the definition of the EDDY_CURRENT_FUNCTION macro.

    NOTES:

        This code is based on the Boost current function code found at
        http://www.boost.org.  The following is the disclaimer at the head
        of the current_function.hpp file in the boost project:

            boost/current_function.hpp - BOOST_CURRENT_FUNCTION

            Copyright (c) 2002 Peter Dimov and Multi Media Ltd.

            Distributed under the Boost Software License, Version 1.0. (See
            accompanying file LICENSE_1_0.txt or copy at
            http://www.boost.org/LICENSE_1_0.txt)

            http://www.boost.org/libs/utility/current_function.html

        The following is the Boost license provided in accordance with the
        requirements set forth by its use.  It it not necessarily the
        licence under which this code is being distributed.  See the section
        on COPYRIGHT for that information.

            Boost Software License - Version 1.0 - August 17th, 2003

            Permission is hereby granted, free of charge, to any person or
            organization obtaining a copy of the software and accompanying
            documentation covered by this license (the "Software") to use,
            reproduce, display, distribute, execute, and transmit the Software,
            and to prepare derivative works of the Software, and to permit
            third-parties to whom the Software is furnished to do so, all
            subject to the following:

            The copyright notices in the Software and this entire statement,
            including the above license grant, this restriction and the
            following disclaimer, must be included in all copies of the
            Software, in whole or in part, and all derivative works of the
            Software, unless such copies or derivative works are solely in the
            form of machine-executable object code generated by a source
            language processor.

            THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
            EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
            MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, TITLE AND
            NON-INFRINGEMENT. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR ANYONE
            DISTRIBUTING THE SOFTWARE BE LIABLE FOR ANY DAMAGES OR OTHER
            LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, ARISING FROM,
            OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
            DEALINGS IN THE SOFTWARE.

    PROGRAMMERS:

        John Eddy (jpeddy@sandia.gov) (JE)

    ORGANIZATION:

        Sandia National Laboratories

    COPYRIGHT:

        See the LICENSE file in the top level JEGA directory.

    VERSION:

        1.0.0

    CHANGES:

        Thu Feb 02 09:32:21 2005 - Original Version (JE)

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the definition of the EDDY_CURRENT_FUNCTION macro.
 */




/*
================================================================================
Prevent Multiple Inclusions
================================================================================
*/
#ifndef EDDY_CONFIG_CURRENT_FUNCTION_HPP
#define EDDY_CONFIG_CURRENT_FUNCTION_HPP


/*
================================================================================
Includes
================================================================================
*/
#include "config.hpp"

/*
================================================================================
Set Current Function Definition
================================================================================
*/
#if  defined(__GNUC__) || \
    (defined(__MWERKS__) && (__MWERKS__ >= 0x3000)) || \
    (defined(__ICC) && (__ICC >= 600))

# define EDDY_CURRENT_FUNCTION __PRETTY_FUNCTION__

 // this clause handles the microsoft compilers.
#elif defined(__FUNCSIG__)

/// Expands to the undecorated signature of the enclosing function
# define EDDY_CURRENT_FUNCTION __FUNCSIG__

#elif (defined(__INTEL_COMPILER) && (__INTEL_COMPILER >= 600)) || \
      (defined(__IBMCPP__) && (__IBMCPP__ >= 500))

# define EDDY_CURRENT_FUNCTION __FUNCTION__

#elif defined(__BORLANDC__) && (__BORLANDC__ >= 0x550)

# define EDDY_CURRENT_FUNCTION __FUNC__

#elif defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 199901)

# define EDDY_CURRENT_FUNCTION __func__

#else

# define EDDY_CURRENT_FUNCTION "(unknown function)"

#endif


/*
================================================================================
End of Multiple Inclusion Check
================================================================================
*/
#endif // EDDY_CONFIG_CURRENT_FUNCTION_HPP
