/*
================================================================================
    PROJECT:

        John Eddy's Genetic Algorithms (JEGA) Managed Front End

    CONTENTS:

        Implementation of class MGeneticAlgorithmEvaluator.

    NOTES:

        See notes of MGeneticAlgorithmEvaluator.hpp.

    PROGRAMMERS:

        

    ORGANIZATION:

        

    COPYRIGHT:

        This library is free software; you can redistribute it and/or
        modify it under the terms of the GNU Lesser General Public
        License as published by the Free Software Foundation; either
        version 2.1 of the License, or (at your option) any later version.
        
        This library is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
        Lesser General Public License for more details.
        
        You should have received a copy of the GNU Lesser General Public
        License along with this library; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
        USA

    VERSION:

        1.0.0

    CHANGES:

        Mon Feb 23 15:08:29 2009 - Original Version ()

================================================================================
*/




/*
================================================================================
Document This File
================================================================================
*/
/** \file
 * \brief Contains the implementation of the MGeneticAlgorithmEvaluator class.
 */




/*
================================================================================
Includes
================================================================================
*/
#include <stdafx.h>
#include <MGeneticAlgorithmEvaluator.hpp>

#pragma unmanaged
#include <GeneticAlgorithmEvaluator.hpp>
#include <utilities/include/EDDY_DebugScope.hpp>
#pragma managed






/*
================================================================================
Namespace Using Directives
================================================================================
*/








/*
================================================================================
Begin Namespace
================================================================================
*/
namespace JEGA {
    namespace FrontEnd {
        namespace Managed {





/*
================================================================================
Static Member Data Definitions
================================================================================
*/








/*
================================================================================
Mutators
================================================================================
*/








/*
================================================================================
Accessors
================================================================================
*/

std::size_t
MGeneticAlgorithmEvaluator::GetNumberEvaluations(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_evaler != 0x0)
    return this->_evaler->GetNumberEvaluations();
}

std::size_t
MGeneticAlgorithmEvaluator::GetMaxEvaluations(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_evaler != 0x0)
    return this->_evaler->GetMaxEvaluations();
}

std::size_t
MGeneticAlgorithmEvaluator::GetEvaluationConcurrency(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_evaler != 0x0)
    return this->_evaler->GetEvaluationConcurrency();
}







/*
================================================================================
Public Methods
================================================================================
*/

bool
MGeneticAlgorithmEvaluator::IsMaxEvalsExceeded(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_evaler != 0x0)
    return this->_evaler->IsMaxEvalsExceeded();
}

bool
MGeneticAlgorithmEvaluator::IsMaxEvalsReached(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_evaler != 0x0)
    return this->_evaler->IsMaxEvalsReached();
}

void
MGeneticAlgorithmEvaluator::Detach(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    this->_evaler = 0x0;
}






/*
================================================================================
Subclass Visible Methods
================================================================================
*/








/*
================================================================================
Subclass Overridable Methods
================================================================================
*/

const JEGA::Algorithms::GeneticAlgorithmEvaluator&
MGeneticAlgorithmEvaluator::Manifest(
    )
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_evaler != 0x0)
    return *this->_evaler;
}








/*
================================================================================
Private Methods
================================================================================
*/








/*
================================================================================
Structors
================================================================================
*/


MGeneticAlgorithmEvaluator::MGeneticAlgorithmEvaluator(
    const JEGA::Algorithms::GeneticAlgorithmEvaluator* toWrap
    ) :
        _evaler(toWrap)
{
    EDDY_FUNC_DEBUGSCOPE
    EDDY_ASSERT(this->_evaler != 0x0)
}




/*
================================================================================
End Namespace
================================================================================
*/
        } // namespace Managed
    } // namespace FrontEnd
} // namespace JEGA

