C***********************************************************************
C Dempster-Shafer Evidence Theory implementation.
C Sandia National Laboratories 2006.
C
C At the present time, the Dempster-Shafer Evidence Theory implementation 
C is being distributed as part of the DAKOTA framework, under the DAKOTA GNU
C GPL (see the README, COPYRIGHT, and LICENSE file in the top Dakota 
C directory for more information).
C***********************************************************************
      SUBROUTINE INPUT(MAXV,MAXINT,NV,NI,
     1     BPA,VMIN,VMAX)
C*****READ DEMPSTER-SHAFER INTERVALS
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION NI(MAXV)
      DIMENSION BPA(MAXINT*MAXV),VMIN(MAXINT*MAXV),VMAX(MAXINT*MAXV)
C
C
C*****OPEN FILE CONTAINING DEMPSTER-SHAFER INTERVAL DEFINITIONS
      OPEN (1, FILE='DDS.INP', STATUS='OLD')
C*****READ NUMBER OF VARIABLES
      READ(1,*) NV
C*****LOOP OVER VARIABLES
      DO 2000 IV=1,NV
C********READ NUMBER OF INTERVALS
         READ(1,*) NI(IV)
C********LOOP OVER INTERVALS
         DO 1000 II=1,NI(IV)
C***********READ BPA, MINIMUM VALUE, AND MAXIMUM VALUE FOR CURRENT INTERVAL
C            READ(1,*) BPA(II,IV), VMIN(II,IV), VMAX(II,IV)
            READ(1,*) BPA((IV-1)*MAXINT+II), VMIN((IV-1)*MAXINT+II),
     1                VMAX((IV-1)*MAXINT+II)
 1000    CONTINUE
 2000 CONTINUE
C*****CLOSE FILE CONTAINING DEMPSTER-SHAFER INTERVAL DEFINITIONS
      CLOSE (1)
C*****WRITE NUMBER OF VARIABLES
      IF (NV .EQ. 1) THEN
         WRITE(2,2001) NV
      ELSE
         WRITE(2,2002) NV
      ENDIF
C*****LOOP OVER VARIABLES
      DO 4000 IV=1,NV
C********LOOP OVER INTERVALS FOR CURRENT VARIABLE
         DO 3000 II=1,NI(IV)
C***********WRITE BASIC PROBABILITY ASSIGNMENT, MINIMUM VALUE FOR CURRENT
C***********VARIABLE, AND MAXIMUM VALUE FOR CURRENT VARIABLE
            WRITE(2,2003) IV, II, BPA((IV-1)*MAXINT+II),
     1                    VMIN((IV-1)*MAXINT+II), VMAX((IV-1)*MAXINT+II)
 3000    CONTINUE
 4000 CONTINUE
      RETURN
C*****FORMAT STATEMENTS
 2001 FORMAT(I5,' VARIABLE',
     1      /' BASIC PROBABILITY INVERVALS FOR EACH VARIABLE',
     2      /'  VAR INT    BPA      MINIMUM     MAXIMUM')
 2002 FORMAT(I5,' VARIABLES',
     1      /' BASIC PROBABILITY INVERVALS FOR EACH VARIABLE',
     2      /'  VAR INT    BPA      MINIMUM     MAXIMUM')
 2003 FORMAT(1X,2I4,F9.5,1P2E12.4)
      END
