#include <iostream.h>
#include <fstream.h>
#include <iomanip.h>
#include <stdlib.h>
#include <math.h>

/* ---------------------------------------------------------------
    Weight calculator for Transportation Cask Shape Optimization
           Michael Eldred, Sandia National Laboratories,
                     C++, January 20, 1995
   --------------------------------------------------------------- */

/* Define symbolic constants */

#define MAXDESVAR 6 /* Maximum number of design variables */


main(int argc, char** argv)

{
     if(argc != 2) {
       cout << "Invalid command usage \n" << endl;
       exit(0);
     }

/* declarations */
     ifstream fin_dakota_temp_file(argv[1]); 

     if (!fin_dakota_temp_file) {
        cout << "Cannot open file";
        exit(1);
     }

     int numdesvar;
     float x[MAXDESVAR+1];
     char label[80];

/* Set format for cout output */
     cout << setprecision(10);
//     cout.setf(ios::scientific);
     
/* Read in design variable values from Dakota temporary file */
     fin_dakota_temp_file >> numdesvar >> label;
     for(int i=1; i<=numdesvar; i++) {
        fin_dakota_temp_file >> x[i] >> label;
//        cout << i << " " << x[i] << " " << label << "\n";
     }

     float pi=3.14159265359;
// Densities of impact limiter and insulation in lb_m/in^3
// Updated 2/28/95
// gamma = rho*32.2 ft/s^2 = lb_f/in^3  [32.2 lb_m = 1 slug]
     float dimplim=.01620;
     float dinsul=.02894;
// Overall dimensions of cask
     float conrad=3.0;
     float conhgt=20.68;

/* Weight of insulation */

// volume of outer cylinder top & bottom: 2*(Pi r^2 t)
     float TpBtOutVol=2*pi*pow(conrad+x[1]+x[2]+x[3],2)*x[6];
// volume of outer cylinder minus t&b: Pi (Rout^2-Rinn^2)*h
     float SkinOutVol=pi*(pow(conrad+x[1]+x[2]+x[3],2)-pow(conrad+x[1]+x[2],2))*(conhgt+2*x[4]+2*x[5]);
// volume of inner cylinder top & bottom: 2*(Pi r^2 t)
     float TpBtInVol=2*pi*pow(conrad,2)*x[4];
// volume of inner cylinder minus t&b: Pi (Rout^2-Rinn^2)*h
     float SkinInVol=pi*(pow(conrad+x[1],2)-pow(conrad,2))*(conhgt+2*x[4]);

     float wtins=dinsul*(TpBtOutVol+SkinOutVol+TpBtInVol+SkinInVol);

/* Weight of impact limiter */

// volume of top and bottom wire mesh regions (solid): 2*(Pi r^2 t)
     float TpBtVol=2*pi*pow(conrad+x[1]+x[2],2)*x[5];
// volume of center wire mesh region (toroidal): Pi (Rout^2-Rinn^2)*h
     float MidVol=pi*(pow(conrad+x[1]+x[2],2)-pow(conrad+x[1],2))*(conhgt+2*x[4]);

     float wtimplim=dimplim*(TpBtVol+MidVol);

     float TOTALwt=wtins+wtimplim;
     cout << TOTALwt << "\n";

}
