/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*  $Id: dlog.c,v 1.6 2002/11/11 13:50:50 gropp Exp $
 *
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include "dlog.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifdef IN_THE_FUTURE_WE_MAY_WANT_TO_MAKE_DLOG_NETWORK_BYTE_ORDER
#if !(defined(WORDS_BIGENDIAN))
/*
    CLOGByteSwapInt - Swap bytes in an integer
*/
void CLOGByteSwapInt(int *buff, int n)
{
    int  i,j,tmp =0;
    int  *tptr = &tmp;          /* Need to access tmp indirectly to get */
    /* arround the bug in DEC-ALPHA compilers*/
    char *ptr1,*ptr2 = (char *) &tmp;

    for ( j=0; j<n; j++ )
    {
	ptr1 = (char *) (buff + j);
	for (i=0; i<sizeof(int); i++)
	{
	    ptr2[i] = ptr1[sizeof(int)-1-i];
	}
	buff[j] = *tptr;
    }
}

/*
    CLOGByteSwapDouble - Swap bytes in a double
*/
void CLOGByteSwapDouble(double *buff, int n)
{
    int    i,j;
    double tmp,*buff1 = (double *) buff;
    double *tptr = &tmp;          /* take care pf bug in DEC-ALPHA g++ */
    char   *ptr1,*ptr2 = (char *) &tmp;

    for ( j=0; j<n; j++ )
    {
	ptr1 = (char *) (buff1 + j);
	for (i=0; i<sizeof(double); i++)
	{
	    ptr2[i] = ptr1[sizeof(double)-1-i];
	}
	buff1[j] = *tptr;
    }
}
#else
void CLOGByteSwapDouble (double *buff, int n){}
void CLOGByteSwapInt (int *buff, int n) {}
#endif
#endif

static int WriteFileData(const char *pBuffer, int length, FILE *fout)
{
    int num_written;

    while (length)
    {
	num_written = fwrite(pBuffer, 1, length, fout);
	if (num_written == -1)
	{
	    printf("Error: fwrite failed - %s\n", strerror(errno));
	    return errno;
	}

	/*printf("fwrite(%d)", num_written);fflush(stdout);*/

	length -= num_written;
	pBuffer += num_written;
    }
    return 0;
}

static void WriteDiskEvent(DLOG_Struct *pDLOG)
{
    /* write the in record */
    pDLOG->DiskEvent.event = pDLOG->nDiskEventIDIn;
    WriteFileData((const char *)&pDLOG->DiskHeader, sizeof(DLOG_HEADER), pDLOG->pOutput->f);
    WriteFileData((const char *)&pDLOG->DiskEvent, sizeof(DLOG_OPEN_EVENT), pDLOG->pOutput->f);

    /* write the out record */
    pDLOG->DiskHeader.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    pDLOG->DiskEvent.event = pDLOG->nDiskEventIDOut;
    WriteFileData((const char *)&pDLOG->DiskHeader, sizeof(DLOG_HEADER), pDLOG->pOutput->f);
    WriteFileData((const char *)&pDLOG->DiskEvent, sizeof(DLOG_OPEN_EVENT), pDLOG->pOutput->f);

    pDLOG->DiskEvent.data++;
}

DLOG_Struct* DLOG_InitLog(int rank, int size)
{
    DLOG_Struct* pDLOG;

    pDLOG = (DLOG_Struct*)malloc(sizeof(DLOG_Struct));
    if (pDLOG == NULL)
	return NULL;

    pDLOG->rank = rank;
    pDLOG->size = size;
    pDLOG->nCurEventId = 500;
    pDLOG->nCurStateId = 500;
    pDLOG->dFirstTimestamp = 0.0;
    sprintf(pDLOG->pszFileName, "log%d.dlog", rank);

    pDLOG->pOutput = DLOG_CreateOutputStruct(pDLOG->pszFileName);
    if (pDLOG->pOutput == NULL)
    {
	printf("DLOG Error: unable to allocate an output structure.\n");
	free(pDLOG);
	return NULL;
    }

    DLOG_EnableLogging(pDLOG);

    /* get two events to use to mark when the log is writing to the disk */
    pDLOG->nDiskEventIDIn = DLOG_GetNextEvent(pDLOG);
    pDLOG->nDiskEventIDOut = DLOG_GetNextEvent(pDLOG);
    /* save the parts of the header and event that do not change */
    pDLOG->DiskEvent.data = 0;
    pDLOG->DiskHeader.type = DLOG_OPEN_EVENT_TYPE;
    pDLOG->DiskHeader.length = sizeof(DLOG_HEADER) + sizeof(DLOG_OPEN_EVENT);
    pDLOG->DiskHeader.procid = rank;
    /* put the description of the state in the log file */
    DLOG_DescribeOpenState(pDLOG, pDLOG->nDiskEventIDIn, pDLOG->nDiskEventIDOut, "DLOG_DISK", "red");

    DLOG_DisableLogging(pDLOG);

    return pDLOG;
}

int DLOG_FinishLog(DLOG_Struct* pDLOG, char *filename)
{
    DLOG_HEADER header;

    /* FixUpBuffer(); */
    pDLOG->DiskHeader.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    WriteFileData(pDLOG->pOutput->buffer, pDLOG->pOutput->pCurHeader - pDLOG->pOutput->buffer, pDLOG->pOutput->f);
    pDLOG->pOutput->pCurHeader = pDLOG->pOutput->buffer;
    WriteDiskEvent(pDLOG);

    header.type = DLOG_ENDLOG_TYPE;
    header.length = sizeof(DLOG_HEADER);
    header.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    header.procid = pDLOG->rank;
    WriteFileData((const char *)&header, sizeof(DLOG_HEADER), pDLOG->pOutput->f);

    DLOG_CloseOutputStruct(&pDLOG->pOutput);

    return 0;
}

void DLOG_EnableLogging(DLOG_Struct* pDLOG)
{
    pDLOG->bLogging = TRUE;
}

void DLOG_DisableLogging(DLOG_Struct* pDLOG)
{
    pDLOG->bLogging = FALSE;
}

void DLOG_SaveFirstTimestamp(DLOG_Struct* pDLOG)
{
    pDLOG->dFirstTimestamp = DLOG_timestamp();
}

int DLOG_GetNextEvent(DLOG_Struct* pDLOG)
{
    return pDLOG->nCurEventId++;
}

void DLOG_LogEvent(DLOG_Struct *pDLOG, int event, double starttime)
{
    DLOG_HEADER *pHeader;
    DLOG_EVENT *pEvent;

    printf("foo on you\n");
    return;

    if (pDLOG->bLogging == FALSE)
	return;

    if (pDLOG->pOutput->pCurHeader + sizeof(DLOG_HEADER) + sizeof(DLOG_EVENT) > pDLOG->pOutput->pEnd)
    {
	/* FixUpBuffer(); */
	pDLOG->DiskHeader.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
	WriteFileData(pDLOG->pOutput->buffer, pDLOG->pOutput->pCurHeader - pDLOG->pOutput->buffer, pDLOG->pOutput->f);
	WriteDiskEvent(pDLOG);
	pDLOG->pOutput->pCurHeader = pDLOG->pOutput->buffer;
    }

    pHeader = (DLOG_HEADER*)pDLOG->pOutput->pCurHeader;
    pEvent = (DLOG_EVENT*)((char*)pHeader + sizeof(DLOG_HEADER));

    pHeader->type = DLOG_EVENT_TYPE;
    pHeader->length = sizeof(DLOG_HEADER) + sizeof(DLOG_EVENT);
    pHeader->timestamp = pEvent->end_time = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    pHeader->procid = pDLOG->rank;
    pEvent->start_time = starttime;
    pEvent->event = event;

    /* advance the current position pointer */
    pDLOG->pOutput->pCurHeader += pHeader->length;
}

void DLOG_LogOpenEvent(DLOG_Struct* pDLOG, int event, int data)
{
    DLOG_HEADER *pHeader;
    DLOG_OPEN_EVENT *pEvent;

    if (pDLOG->bLogging == FALSE)
	return;

    if (pDLOG->pOutput->pCurHeader + sizeof(DLOG_HEADER) + sizeof(DLOG_OPEN_EVENT) > pDLOG->pOutput->pEnd)
    {
	/* FixUpBuffer(); */
	pDLOG->DiskHeader.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
	WriteFileData(pDLOG->pOutput->buffer, pDLOG->pOutput->pCurHeader - pDLOG->pOutput->buffer, pDLOG->pOutput->f);
	WriteDiskEvent(pDLOG);
	pDLOG->pOutput->pCurHeader = pDLOG->pOutput->buffer;
    }

    pHeader = (DLOG_HEADER*)pDLOG->pOutput->pCurHeader;
    pEvent = (DLOG_OPEN_EVENT*)((char*)pHeader + sizeof(DLOG_HEADER));

    pHeader->type = DLOG_OPEN_EVENT_TYPE;
    pHeader->length = sizeof(DLOG_HEADER) + sizeof(DLOG_OPEN_EVENT);
    pHeader->timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    pHeader->procid = pDLOG->rank;
    pEvent->event = event;
    pEvent->data = data;

    /* advance the current position pointer */
    pDLOG->pOutput->pCurHeader += pHeader->length;
}

void DLOG_LogSend(DLOG_Struct* pDLOG, int dest, int tag, int size)
{
    DLOG_HEADER *pHeader;
    DLOG_ARROW *pArrow;

    if (pDLOG->bLogging == FALSE)
	return;

    if (pDLOG->pOutput->pCurHeader + sizeof(DLOG_HEADER) + sizeof(DLOG_ARROW) > pDLOG->pOutput->pEnd)
    {
	/* FixUpBuffer(); */
	pDLOG->DiskHeader.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
	WriteFileData(pDLOG->pOutput->buffer, pDLOG->pOutput->pCurHeader - pDLOG->pOutput->buffer, pDLOG->pOutput->f);
	WriteDiskEvent(pDLOG);
	pDLOG->pOutput->pCurHeader = pDLOG->pOutput->buffer;
    }

    pHeader = (DLOG_HEADER*)pDLOG->pOutput->pCurHeader;
    pArrow = (DLOG_ARROW*)((char*)pHeader + sizeof(DLOG_HEADER));

    pHeader->type = DLOG_ARROW_TYPE;
    pHeader->length = sizeof(DLOG_HEADER) + sizeof(DLOG_ARROW);
    pHeader->timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    pHeader->procid = pDLOG->rank;

    pArrow->event = LOG_MESG_SEND;
    pArrow->data = dest;
    pArrow->tag = tag;
    pArrow->length = size;

    /* advance the current position pointer */
    pDLOG->pOutput->pCurHeader += pHeader->length;
}

void DLOG_LogRecv(DLOG_Struct* pDLOG, int src, int tag, int size)
{
    DLOG_HEADER *pHeader;
    DLOG_ARROW *pArrow;

    if (pDLOG->bLogging == FALSE)
	return;

    if (pDLOG->pOutput->pCurHeader + sizeof(DLOG_HEADER) + sizeof(DLOG_ARROW) > pDLOG->pOutput->pEnd)
    {
	/* FixUpBuffer(); */
	pDLOG->DiskHeader.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
	WriteFileData(pDLOG->pOutput->buffer, pDLOG->pOutput->pCurHeader - pDLOG->pOutput->buffer, pDLOG->pOutput->f);
	WriteDiskEvent(pDLOG);
	pDLOG->pOutput->pCurHeader = pDLOG->pOutput->buffer;
    }

    pHeader = (DLOG_HEADER*)pDLOG->pOutput->pCurHeader;
    pArrow = (DLOG_ARROW*)((char*)pHeader + sizeof(DLOG_HEADER));

    pHeader->type = DLOG_ARROW_TYPE;
    pHeader->length = sizeof(DLOG_HEADER) + sizeof(DLOG_ARROW);
    pHeader->timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    pHeader->procid = pDLOG->rank;

    pArrow->event = LOG_MESG_RECV;
    pArrow->data = src;
    pArrow->tag = tag;
    pArrow->length = size;

    /* advance the current position pointer */
    pDLOG->pOutput->pCurHeader += pHeader->length;
}

void DLOG_LogCommID(DLOG_Struct* pDLOG, int id)
{
    DLOG_HEADER *pHeader;
    DLOG_COMM *pComm;

    if (pDLOG->bLogging == FALSE)
	return;

    if (pDLOG->pOutput->pCurHeader + sizeof(DLOG_HEADER) + sizeof(DLOG_COMM) > pDLOG->pOutput->pEnd)
    {
	/* FixUpBuffer(); */
	pDLOG->DiskHeader.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
	WriteFileData(pDLOG->pOutput->buffer, pDLOG->pOutput->pCurHeader - pDLOG->pOutput->buffer, pDLOG->pOutput->f);
	WriteDiskEvent(pDLOG);
	pDLOG->pOutput->pCurHeader = pDLOG->pOutput->buffer;
    }

    pHeader = (DLOG_HEADER*)pDLOG->pOutput->pCurHeader;
    pComm = (DLOG_COMM*)((char*)pHeader + sizeof(DLOG_HEADER));

    pHeader->type = DLOG_COMM_TYPE;
    pHeader->length = sizeof(DLOG_HEADER) + sizeof(DLOG_COMM);
    pHeader->timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    pHeader->procid = pDLOG->rank;

    pComm->etype = DLOG_COMM_TYPE;
    pComm->newcomm = id;

    /* advance the current position pointer */
    pDLOG->pOutput->pCurHeader += pHeader->length;
}

void DLOG_DescribeState(DLOG_Struct* pDLOG, int state, char *name, char *color)
{
    DLOG_HEADER *pHeader;
    DLOG_STATE *pState;

    if (pDLOG->bLogging == FALSE)
	return;

    if (pDLOG->pOutput->pCurHeader + sizeof(DLOG_HEADER) + sizeof(DLOG_STATE) > pDLOG->pOutput->pEnd)
    {
	/* FixUpBuffer(); */
	pDLOG->DiskHeader.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
	WriteFileData(pDLOG->pOutput->buffer, pDLOG->pOutput->pCurHeader - pDLOG->pOutput->buffer, pDLOG->pOutput->f);
	WriteDiskEvent(pDLOG);
	pDLOG->pOutput->pCurHeader = pDLOG->pOutput->buffer;
    }

    pHeader = (DLOG_HEADER*)pDLOG->pOutput->pCurHeader;
    pState = (DLOG_STATE*)((char*)pHeader + sizeof(DLOG_HEADER));

    pHeader->type = DLOG_STATE_TYPE;
    pHeader->length = sizeof(DLOG_HEADER) + sizeof(DLOG_STATE);
    pHeader->timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    pHeader->procid = pDLOG->rank;

    pState->stateid = state;
    if (color)
    {
	strncpy(pState->color, color, DLOG_COLOR_LENGTH);
	pState->color[DLOG_COLOR_LENGTH-1] = '\0';
    }
    else
    {
	pState->color[0] = '\0';
    }
    if (name)
    {
	strncpy(pState->description, name, DLOG_DESCRIPTION_LENGTH);
	pState->description[DLOG_DESCRIPTION_LENGTH-1] = '\0';
    }
    else
    {
	pState->description[0] = '\0';
    }

    /* advance the current position pointer */
    pDLOG->pOutput->pCurHeader += pHeader->length;
}

void DLOG_DescribeOpenState(DLOG_Struct* pDLOG, int start, int end, char *name, char *color)
{
    DLOG_HEADER *pHeader;
    DLOG_OPEN_STATE *pState;

    if (pDLOG->bLogging == FALSE)
	return;

    if (pDLOG->pOutput->pCurHeader + sizeof(DLOG_HEADER) + sizeof(DLOG_OPEN_STATE) > pDLOG->pOutput->pEnd)
    {
	/* FixUpBuffer(); */
	pDLOG->DiskHeader.timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
	WriteFileData(pDLOG->pOutput->buffer, pDLOG->pOutput->pCurHeader - pDLOG->pOutput->buffer, pDLOG->pOutput->f);
	WriteDiskEvent(pDLOG);
	pDLOG->pOutput->pCurHeader = pDLOG->pOutput->buffer;
    }

    pHeader = (DLOG_HEADER*)pDLOG->pOutput->pCurHeader;
    pState = (DLOG_OPEN_STATE*)((char*)pHeader + sizeof(DLOG_HEADER));

    pHeader->type = DLOG_OPEN_STATE_TYPE;
    pHeader->length = sizeof(DLOG_HEADER) + sizeof(DLOG_OPEN_STATE);
    pHeader->timestamp = DLOG_timestamp() - pDLOG->dFirstTimestamp;
    pHeader->procid = pDLOG->rank;

    pState->stateid = pDLOG->nCurStateId++;
    pState->startetype = start;
    pState->endetype = end;
    if (color)
    {
	strncpy(pState->color, color, DLOG_COLOR_LENGTH);
	pState->color[DLOG_COLOR_LENGTH-1] = '\0';
    }
    else
    {
	pState->color[0] = '\0';
    }
    if (name)
    {
	strncpy(pState->description, name, DLOG_DESCRIPTION_LENGTH);
	pState->description[DLOG_DESCRIPTION_LENGTH-1] = '\0';
    }
    else
    {
	pState->description[0] = '\0';
    }

    /* advance the current position pointer */
    pDLOG->pOutput->pCurHeader += pHeader->length;
}
